/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.nbt.VMapNBT;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerGreedData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerGreed";
    protected VMapNBT<UUID, ArtifactData> data = VMapNBT.ofUUID(ArtifactData::new);

    public ArtifactData get(Player player) {
        return this.get(player.m_142081_());
    }

    public ArtifactData get(UUID playerId) {
        return (ArtifactData)this.data.computeIfAbsent(playerId, uuid -> new ArtifactData());
    }

    public void onArtifactCompleted(UUID playerId) {
        if (!this.get((UUID)playerId).completedArtifacts) {
            this.get((UUID)playerId).completedArtifacts = true;
            this.m_77762_();
        }
    }

    public void onHeraldCompleted(UUID playerId) {
        if (!this.get((UUID)playerId).completedHerald) {
            this.get((UUID)playerId).completedHerald = true;
            this.m_77762_();
        }
    }

    private static PlayerGreedData create(CompoundTag tag) {
        PlayerGreedData data = new PlayerGreedData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.data.deserializeNBT(nbt.m_128437_("Data", 10));
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("Data", (Tag)this.data.serializeNBT());
        return nbt;
    }

    public static PlayerGreedData get(MinecraftServer server) {
        return (PlayerGreedData)server.m_129783_().m_8895_().m_164861_(PlayerGreedData::create, PlayerGreedData::new, DATA_NAME);
    }

    public static PlayerGreedData get() {
        return PlayerGreedData.get(ServerLifecycleHooks.getCurrentServer());
    }

    public static class ArtifactData
    implements INBTSerializable<CompoundTag> {
        protected boolean completedArtifacts = false;
        protected boolean completedHerald = false;

        public boolean hasCompletedArtifacts() {
            return this.completedArtifacts;
        }

        public boolean hasCompletedHerald() {
            return this.completedHerald;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128379_("CompletedArtifacts", this.completedArtifacts);
            nbt.m_128379_("CompletedHerald", this.completedHerald);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.completedArtifacts = nbt.m_128471_("CompletedArtifacts");
            this.completedHerald = nbt.m_128471_("CompletedHerald");
        }
    }
}

