/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.HistoricFavoritesMessage;
import iskallia.vault.util.NetcodeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;

public class PlayerHistoricFavoritesData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerHistoricFavorites";
    private final Map<UUID, HistoricFavorites> playerMap = new HashMap<UUID, HistoricFavorites>();
    private static final String TAG_PLAYER_LIST = "playerList";
    private static final String TAG_FAVORITES_LIST = "favoritesList";

    public static PlayerHistoricFavoritesData get(ServerLevel level) {
        return PlayerHistoricFavoritesData.get(level.m_142572_());
    }

    public static PlayerHistoricFavoritesData get(MinecraftServer server) {
        return (PlayerHistoricFavoritesData)server.m_129783_().m_8895_().m_164861_(PlayerHistoricFavoritesData::create, PlayerHistoricFavoritesData::new, DATA_NAME);
    }

    private static PlayerHistoricFavoritesData create(CompoundTag compoundTag) {
        return new PlayerHistoricFavoritesData(compoundTag);
    }

    private PlayerHistoricFavoritesData() {
    }

    private PlayerHistoricFavoritesData(CompoundTag compoundTag) {
        this();
        this.load(compoundTag);
    }

    public Map<UUID, HistoricFavorites> getPlayerMap() {
        return this.playerMap;
    }

    public HistoricFavorites getHistoricFavorites(Player player) {
        return this.getHistoricFavorites(player.m_142081_());
    }

    public HistoricFavorites getHistoricFavorites(UUID playerUuid) {
        return this.playerMap.computeIfAbsent(playerUuid, x$0 -> new HistoricFavorites((UUID)x$0));
    }

    private void load(CompoundTag compoundTag) {
        ListTag playerList = compoundTag.m_128437_(TAG_PLAYER_LIST, 8);
        ListTag favoritesList = compoundTag.m_128437_(TAG_FAVORITES_LIST, 10);
        if (playerList.size() != favoritesList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.getHistoricFavorites(playerUUID).deserializeNBT(favoritesList.m_128728_(i));
        }
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        ListTag playerList = new ListTag();
        ListTag favoritesList = new ListTag();
        this.playerMap.forEach((key, value) -> {
            playerList.add((Object)StringTag.m_129297_((String)key.toString()));
            favoritesList.add((Object)value.serializeNBT());
        });
        compoundTag.m_128365_(TAG_PLAYER_LIST, (Tag)playerList);
        compoundTag.m_128365_(TAG_FAVORITES_LIST, (Tag)favoritesList);
        return compoundTag;
    }

    public class HistoricFavorites {
        private UUID playerUuid;
        private List<UUID> favoritesUUID;

        public HistoricFavorites(UUID playerUuid) {
            this.playerUuid = playerUuid;
            this.favoritesUUID = new ArrayList<UUID>();
        }

        public List<UUID> getFavorites() {
            return this.favoritesUUID;
        }

        private static PlayerHistoricFavoritesData create(CompoundTag tag) {
            PlayerHistoricFavoritesData data = new PlayerHistoricFavoritesData();
            data.load(tag);
            return data;
        }

        public void deserializeNBT(CompoundTag tag) {
            ListTag list = tag.m_128437_("favorites", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tradeTag = list.m_128728_(i);
                this.favoritesUUID.add(tradeTag.m_128342_("uuid"));
            }
            this.playerUuid = tag.m_128342_("uuid");
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            ListTag list = new ListTag();
            this.favoritesUUID.forEach(uuid -> {
                CompoundTag tradeTag = new CompoundTag();
                tradeTag.m_128362_("uuid", uuid);
                list.add((Object)tradeTag);
            });
            tag.m_128365_("favorites", (Tag)list);
            tag.m_128362_("uuid", this.playerUuid);
            return tag;
        }

        public void syncToClient(MinecraftServer server) {
            NetcodeUtils.runIfPresent(server, this.playerUuid, player -> ModNetwork.CHANNEL.sendTo((Object)new HistoricFavoritesMessage(this.favoritesUUID), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT));
        }

        public static PlayerHistoricFavoritesData get(ServerLevel world) {
            return HistoricFavorites.get(world.m_142572_());
        }

        public static PlayerHistoricFavoritesData get(MinecraftServer server) {
            return (PlayerHistoricFavoritesData)server.m_129783_().m_8895_().m_164861_(PlayerHistoricFavoritesData::create, PlayerHistoricFavoritesData::new, PlayerHistoricFavoritesData.DATA_NAME);
        }
    }
}

