/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.config.gear.VaultGearCraftingConfig;
import iskallia.vault.gear.crafting.ProficiencyType;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ProficiencyMessage;
import iskallia.vault.util.MiscUtils;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.network.NetworkDirection;

public class PlayerProficiencyData
extends SavedData {
    private static final Random rand = new Random();
    protected static final String DATA_NAME = "the_vault_PlayerProficiency";
    private final Map<UUID, Map<ProficiencyType, Integer>> playerProficiencies = new HashMap<UUID, Map<ProficiencyType, Integer>>();

    private PlayerProficiencyData() {
    }

    private PlayerProficiencyData(CompoundTag tag) {
        this.load(tag);
    }

    public Integer getProficiency(Player player, ProficiencyType type) {
        return this.getProficiency(player.m_142081_(), type);
    }

    public Integer getProficiency(UUID playerId, ProficiencyType type) {
        if (type == ProficiencyType.UNKNOWN) {
            return 0;
        }
        return this.playerProficiencies.getOrDefault(playerId, Collections.emptyMap()).getOrDefault((Object)type, 0);
    }

    public void setProficiency(UUID playerId, ProficiencyType type, int value) {
        if (type == ProficiencyType.UNKNOWN) {
            return;
        }
        VaultGearCraftingConfig cfg = ModConfigs.VAULT_GEAR_CRAFTING_CONFIG;
        this.playerProficiencies.computeIfAbsent(playerId, id -> new EnumMap(ProficiencyType.class)).put(type, Mth.m_14045_((int)value, (int)0, (int)cfg.getTotalCategoryProficiency()));
        this.m_77762_();
    }

    public void updateProficiency(ServerPlayer player, ProficiencyType type, int value) {
        if (type == ProficiencyType.UNKNOWN) {
            return;
        }
        UUID playerId = player.m_142081_();
        int thisProficiency = this.getProficiency(playerId, type);
        VaultGearCraftingConfig cfg = ModConfigs.VAULT_GEAR_CRAFTING_CONFIG;
        int totalProficiency = this.getTotalProficiency(playerId);
        int availableProficiencyGain = Math.max(cfg.getTotalCategoryProficiency() - thisProficiency, 0);
        int valueToAdd = Math.min(availableProficiencyGain, value);
        this.playerProficiencies.computeIfAbsent(playerId, id -> new EnumMap(ProficiencyType.class)).put(type, thisProficiency + valueToAdd);
        int valueToCut = Math.max(totalProficiency + valueToAdd - cfg.getTotalMaximumProficiency(), 0);
        this.removeRandomProficiencyExcluding(playerId, valueToCut, type);
        this.sendProficiencyInformation(player);
        this.m_77762_();
    }

    private int getTotalProficiency(UUID playerId) {
        return this.playerProficiencies.getOrDefault(playerId, Collections.emptyMap()).values().stream().mapToInt(i -> i).sum();
    }

    private void removeRandomProficiencyExcluding(UUID playerId, int amount, ProficiencyType excluded) {
        if (amount <= 0) {
            return;
        }
        Map<ProficiencyType, Integer> proficiencies = this.playerProficiencies.getOrDefault(playerId, Collections.emptyMap());
        for (int i = 0; i < amount; ++i) {
            List<ProficiencyType> proficiencyTypes = proficiencies.entrySet().stream().filter(entry -> entry.getKey() != excluded).filter(entry -> (Integer)entry.getValue() > 0).map(Map.Entry::getKey).toList();
            ProficiencyType randomType = MiscUtils.getRandomEntry(proficiencyTypes, rand);
            if (randomType == null) continue;
            proficiencies.put(randomType, Math.max((Integer)proficiencies.get((Object)randomType) - 1, 0));
        }
    }

    public void sendProficiencyInformation(ServerPlayer player) {
        float maxProficiency = ModConfigs.VAULT_GEAR_CRAFTING_CONFIG.getTotalCategoryProficiency();
        HashMap<ProficiencyType, Float> percentages = new HashMap<ProficiencyType, Float>();
        for (ProficiencyType type : ProficiencyType.values()) {
            int amount = this.getProficiency((Player)player, type);
            percentages.put(type, Float.valueOf(Mth.m_14036_((float)((float)amount / maxProficiency), (float)0.0f, (float)1.0f)));
        }
        ModNetwork.CHANNEL.sendTo((Object)new ProficiencyMessage(percentages), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    protected void load(CompoundTag tag) {
        this.playerProficiencies.clear();
        for (String playerIdStr : tag.m_128431_()) {
            UUID playerId = UUID.fromString(playerIdStr);
            EnumMap<ProficiencyType, Integer> proficiencies = new EnumMap<ProficiencyType, Integer>(ProficiencyType.class);
            CompoundTag proficiencyTag = tag.m_128469_(playerIdStr);
            for (String proficiencyName : proficiencyTag.m_128431_()) {
                ProficiencyType type = ProficiencyType.valueOf(proficiencyName);
                proficiencies.put(type, proficiencyTag.m_128451_(proficiencyName));
            }
            this.playerProficiencies.put(playerId, proficiencies);
        }
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        this.playerProficiencies.forEach((playerId, proficiencies) -> {
            CompoundTag proficiencyTag = new CompoundTag();
            proficiencies.forEach((type, amount) -> proficiencyTag.m_128365_(type.name(), (Tag)IntTag.m_128679_((int)amount)));
            tag.m_128365_(playerId.toString(), (Tag)proficiencyTag);
        });
        return tag;
    }

    public static PlayerProficiencyData get(ServerLevel world) {
        return PlayerProficiencyData.get(world.m_142572_());
    }

    public static PlayerProficiencyData get(MinecraftServer server) {
        return (PlayerProficiencyData)server.m_129783_().m_8895_().m_164861_(PlayerProficiencyData::new, PlayerProficiencyData::new, DATA_NAME);
    }
}

