/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.pylon.PylonBuff;
import iskallia.vault.nbt.VListNBT;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="the_vault", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerPylons
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerPylons";
    protected VListNBT<PylonBuff<?>, CompoundTag> buffs = VListNBT.of(PylonBuff::fromNBT);
    protected boolean initialized;

    public static void add(Vault vault, Player player, PylonBuff.Config<?> config) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        Object buff = config.build();
        ((PylonBuff)buff).setPlayer(player);
        if (vault != null) {
            ((PylonBuff)buff).setVault(vault);
        }
        ((PylonBuff)buff).initServer(server);
        ((PylonBuff)buff).onAdd(server);
        PlayerPylons.get().buffs.add((PylonBuff<?>)buff);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        PlayerPylons pylons = PlayerPylons.get();
        if (!pylons.initialized) {
            pylons.buffs.forEach(pylon -> pylon.initServer(server));
            pylons.initialized = true;
        }
        pylons.buffs.forEach(buff -> buff.onTick(server));
        pylons.buffs.removeIf(pylon -> {
            if (pylon.isDone()) {
                pylon.onRemove(server);
                pylon.releaseServer();
                return true;
            }
            return false;
        });
    }

    @SubscribeEvent
    public static void onServerStop(ServerStoppedEvent event) {
        PlayerPylons.get().buffs.forEach(PylonBuff::releaseServer);
    }

    public boolean m_77764_() {
        return true;
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("buffs", (Tag)this.buffs.serializeNBT());
        return nbt;
    }

    private static PlayerPylons load(CompoundTag nbt) {
        PlayerPylons data = new PlayerPylons();
        data.buffs.deserializeNBT(nbt.m_128437_("buffs", 10));
        return data;
    }

    public static PlayerPylons get() {
        return (PlayerPylons)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(PlayerPylons::load, PlayerPylons::new, DATA_NAME);
    }
}

