/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.random.RandomSource;
import iskallia.vault.core.vault.influence.VaultGod;
import iskallia.vault.init.ModDynamicModels;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModSounds;
import iskallia.vault.nbt.VMapNBT;
import iskallia.vault.util.calc.GodAffinityHelper;
import iskallia.vault.world.data.DiscoveredModelsData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerReputationData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerInfluences";
    protected VMapNBT<UUID, Entry> entries = VMapNBT.ofUUID(Entry::new);

    public static void attemptFavour(Player player, VaultGod god, RandomSource random) {
        float chance = GodAffinityHelper.getAffinityPercent((LivingEntity)player, god);
        if (random.nextFloat() >= chance) {
            return;
        }
        BlockPos pos = player.m_142538_();
        player.f_19853_.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), ModSounds.FAVOUR_UP, SoundSource.PLAYERS, 0.4f, 0.7f);
        MutableComponent msg = new TextComponent("You gained a favour!").m_130940_(god.getChatColor());
        player.m_5661_((Component)msg, true);
        PlayerReputationData.addReputation(player.m_142081_(), god, 1);
    }

    public static int getReputation(UUID player, VaultGod god) {
        if (!PlayerReputationData.get().entries.containsKey(player)) {
            return 0;
        }
        return PlayerReputationData.get().entries.get((Object)player).reputation.getOrDefault((Object)god, 0);
    }

    public static void addReputation(UUID playerUUID, VaultGod god, int reputation) {
        Entry entry = (Entry)PlayerReputationData.get().entries.computeIfAbsent(playerUUID, uuid -> new Entry());
        entry.addReputation(god, reputation);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        ServerPlayer player = server.m_6846_().m_11259_(playerUUID);
        if (player == null) {
            return;
        }
        entry.reputation.forEach((vaultGod, updatedReputation) -> {
            if (updatedReputation >= 25) {
                DiscoveredModelsData discoveredModelsData = DiscoveredModelsData.get(server);
                if (vaultGod == VaultGod.IDONA) {
                    discoveredModelsData.discoverAllArmorPieceAndBroadcast((Player)player, ModDynamicModels.Armor.IDONAS_ARMOUR);
                    discoveredModelsData.discoverModelAndBroadcast((Item)ModItems.SWORD, ModDynamicModels.Swords.IDONAS_SWORD.getId(), (Player)player);
                    discoveredModelsData.discoverModelAndBroadcast((Item)ModItems.AXE, ModDynamicModels.Axes.IDONAS_SCYTHE.getId(), (Player)player);
                } else if (vaultGod == VaultGod.TENOS) {
                    discoveredModelsData.discoverAllArmorPieceAndBroadcast((Player)player, ModDynamicModels.Armor.TENOS_ARMOUR);
                    discoveredModelsData.discoverModelAndBroadcast((Item)ModItems.AXE, ModDynamicModels.Axes.TENOS_STAFF.getId(), (Player)player);
                } else if (vaultGod == VaultGod.VELARA) {
                    discoveredModelsData.discoverAllArmorPieceAndBroadcast((Player)player, ModDynamicModels.Armor.VELARAS_ARMOUR);
                    discoveredModelsData.discoverModelAndBroadcast((Item)ModItems.SWORD, ModDynamicModels.Swords.VELARAS_GREATSWORD.getId(), (Player)player);
                    discoveredModelsData.discoverModelAndBroadcast((Item)ModItems.AXE, ModDynamicModels.Axes.VELARAS_HAMMER.getId(), (Player)player);
                } else if (vaultGod == VaultGod.WENDARR) {
                    discoveredModelsData.discoverAllArmorPieceAndBroadcast((Player)player, ModDynamicModels.Armor.WENDARRS_ARMOUR);
                    discoveredModelsData.discoverModelAndBroadcast((Item)ModItems.SWORD, ModDynamicModels.Swords.WENDARRS_GREATSWORD.getId(), (Player)player);
                    discoveredModelsData.discoverModelAndBroadcast((Item)ModItems.AXE, ModDynamicModels.Axes.WENDARRS_CLOCKAXE.getId(), (Player)player);
                }
            }
        });
    }

    private static PlayerReputationData load(CompoundTag nbt) {
        PlayerReputationData data = new PlayerReputationData();
        data.entries.deserializeNBT(nbt.m_128437_("entries", 10));
        return data;
    }

    public boolean m_77764_() {
        return true;
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("entries", (Tag)this.entries.serializeNBT());
        return nbt;
    }

    public static PlayerReputationData get() {
        return (PlayerReputationData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(PlayerReputationData::load, PlayerReputationData::new, DATA_NAME);
    }

    private static class Entry
    implements INBTSerializable<CompoundTag> {
        private final Map<VaultGod, Integer> reputation = new HashMap<VaultGod, Integer>();
        private int version = 1;

        private Entry() {
        }

        public void addReputation(VaultGod god, int reputation) {
            reputation = Math.min(25 - this.reputation.getOrDefault((Object)god, 0), reputation);
            this.reputation.put(god, this.reputation.getOrDefault((Object)god, 0) + reputation);
            int total = this.reputation.values().stream().mapToInt(Integer::intValue).sum();
            Random random = new Random();
            for (int i = 0; i < total - 25; ++i) {
                ArrayList<VaultGod> gods = new ArrayList<VaultGod>(Arrays.asList(VaultGod.values()));
                gods.remove((Object)god);
                gods.removeIf(god1 -> this.reputation.getOrDefault(god1, 0) <= 0);
                if (gods.isEmpty()) continue;
                VaultGod remove = (VaultGod)((Object)gods.get(random.nextInt(gods.size())));
                this.reputation.put(remove, this.reputation.getOrDefault((Object)remove, 0) - 1);
            }
        }

        public void migrate() {
            if (this.version == 0) {
                this.reputation.clear();
                this.version = 1;
            }
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            ListTag reputationList = new ListTag();
            this.reputation.forEach((vaultGod, reputation) -> {
                CompoundTag entry = new CompoundTag();
                entry.m_128359_("God", vaultGod.getName());
                entry.m_128405_("Reputation", reputation.intValue());
                reputationList.add((Object)entry);
            });
            nbt.m_128365_("Reputations", (Tag)reputationList);
            nbt.m_128405_("Version", this.version);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.reputation.clear();
            ListTag reputationList = nbt.m_128437_("Reputations", 10);
            for (int i = 0; i < reputationList.size(); ++i) {
                CompoundTag entry = reputationList.m_128728_(i);
                this.reputation.put(VaultGod.fromName(entry.m_128461_("God")), entry.m_128451_("Reputation"));
            }
            this.version = nbt.m_128451_("Version");
            this.migrate();
        }
    }
}

