/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.DynamicOps;
import iskallia.vault.VaultMod;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.world.data.InventorySnapshot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import org.apache.logging.log4j.Logger;

public class PlayerSpiritRecoveryData
extends SavedData {
    private static final String DATA_NAME = "the_vault_PlayerSpiritRecovery";
    private static final String PLAYER_DROPS_TAG = "playerDrops";
    private static final String SPIRIT_RECOVERY_MULTIPLIERS_TAG = "spiritRecoveryMultipliers";
    private static final String HERO_DISCOUNTS_TAG = "heroDiscounts";
    private static final String LAST_VAULT_LEVELS_TAG = "lastVaultLevels";
    private static final String VAULT_SPIRIT_DATA_TAG = "vaultSpiritData";
    private static final String PLAYER_IMMEDIATE_RESPAWN_SPIRIT_DATA_TAG = "playerImmediateRespawnSpiritData";
    @Deprecated
    private final Map<UUID, List<ItemStack>> playerDrops = new HashMap<UUID, List<ItemStack>>();
    @Deprecated
    private final Map<UUID, Integer> lastVaultLevels = new HashMap<UUID, Integer>();
    private final Map<UUID, Set<SpiritData>> vaultSpiritData = new HashMap<UUID, Set<SpiritData>>();
    private final Map<UUID, Float> spiritRecoveryMultipliers = new HashMap<UUID, Float>();
    private final Map<UUID, Float> heroDiscounts = new HashMap<UUID, Float>();
    private final Map<UUID, Integer> playerSpiritRecoveries = new HashMap<UUID, Integer>();

    public static PlayerSpiritRecoveryData get(ServerLevel world) {
        return (PlayerSpiritRecoveryData)world.m_142572_().m_129783_().m_8895_().m_164861_(PlayerSpiritRecoveryData::create, PlayerSpiritRecoveryData::new, DATA_NAME);
    }

    private static PlayerSpiritRecoveryData create(CompoundTag tag) {
        PlayerSpiritRecoveryData data = new PlayerSpiritRecoveryData();
        data.load(tag);
        return data;
    }

    @Deprecated
    public void removeDrops(UUID playerId) {
        this.playerDrops.remove(playerId);
        this.m_77762_();
    }

    @Deprecated
    public void removeLastVaultLevel(UUID playerId) {
        this.lastVaultLevels.remove(playerId);
        this.m_77762_();
    }

    @Deprecated
    public Optional<Integer> getLastVaultLevel(UUID playerId) {
        return Optional.ofNullable(this.lastVaultLevels.get(playerId));
    }

    @Deprecated
    public List<ItemStack> getDrops(UUID playerId) {
        return this.playerDrops.getOrDefault(playerId, Collections.emptyList());
    }

    private void load(CompoundTag tag) {
        this.playerSpiritRecoveries.clear();
        ListTag data = tag.m_128437_("PlayerData", 10);
        data.forEach(t -> {
            if (t instanceof CompoundTag) {
                CompoundTag entry = (CompoundTag)t;
                this.playerSpiritRecoveries.put(entry.m_128342_("uuid"), entry.m_128451_("count"));
            }
        });
        this.playerDrops.clear();
        if (tag.m_128425_(PLAYER_DROPS_TAG, 10)) {
            CompoundTag playerDropsTag = tag.m_128469_(PLAYER_DROPS_TAG);
            playerDropsTag.m_128431_().forEach(playerId -> {
                ListTag dropsListTag = playerDropsTag.m_128437_(playerId, 10);
                ArrayList drops = new ArrayList();
                dropsListTag.forEach(dropTag -> drops.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)dropTag))));
                this.playerDrops.put(UUID.fromString(playerId), drops);
            });
        }
        this.spiritRecoveryMultipliers.clear();
        if (tag.m_128441_(SPIRIT_RECOVERY_MULTIPLIERS_TAG)) {
            CompoundTag multipliersTag = tag.m_128469_(SPIRIT_RECOVERY_MULTIPLIERS_TAG);
            multipliersTag.m_128431_().forEach(playerId -> this.spiritRecoveryMultipliers.put(UUID.fromString(playerId), Float.valueOf(multipliersTag.m_128457_(playerId))));
        }
        if (tag.m_128441_(HERO_DISCOUNTS_TAG)) {
            CompoundTag discountsTag = tag.m_128469_(HERO_DISCOUNTS_TAG);
            discountsTag.m_128431_().forEach(playerId -> this.heroDiscounts.put(UUID.fromString(playerId), Float.valueOf(discountsTag.m_128457_(playerId))));
        }
        this.lastVaultLevels.clear();
        if (tag.m_128441_(LAST_VAULT_LEVELS_TAG)) {
            CompoundTag levelsTag = tag.m_128469_(LAST_VAULT_LEVELS_TAG);
            levelsTag.m_128431_().forEach(playerId -> this.lastVaultLevels.put(UUID.fromString(playerId), levelsTag.m_128451_(playerId)));
        }
        this.vaultSpiritData.clear();
        if (tag.m_128441_(VAULT_SPIRIT_DATA_TAG)) {
            CompoundTag dataTag = tag.m_128469_(VAULT_SPIRIT_DATA_TAG);
            dataTag.m_128431_().forEach(playerId -> {
                CompoundTag vaultSpiritDataTag = dataTag.m_128469_(playerId);
                HashSet vaultSpiritDataSet = new HashSet();
                vaultSpiritDataTag.m_128431_().forEach(vaultId -> vaultSpiritDataSet.add(SpiritData.deserialize(vaultSpiritDataTag.m_128469_(vaultId))));
                this.vaultSpiritData.put(UUID.fromString(playerId), vaultSpiritDataSet);
            });
        }
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        compoundTag.m_128365_("PlayerData", (Tag)this.serializeSpiritRecoveries());
        if (!this.playerDrops.isEmpty()) {
            compoundTag.m_128365_(PLAYER_DROPS_TAG, (Tag)this.serializePlayerDrops());
        }
        if (!this.spiritRecoveryMultipliers.isEmpty()) {
            compoundTag.m_128365_(SPIRIT_RECOVERY_MULTIPLIERS_TAG, (Tag)this.serializeSpiritRecoveryMultipliers());
        }
        if (!this.heroDiscounts.isEmpty()) {
            compoundTag.m_128365_(HERO_DISCOUNTS_TAG, (Tag)this.serializeHeroDiscounts());
        }
        if (!this.lastVaultLevels.isEmpty()) {
            compoundTag.m_128365_(LAST_VAULT_LEVELS_TAG, (Tag)this.serializeLastVaultLevels());
        }
        if (!this.vaultSpiritData.isEmpty()) {
            compoundTag.m_128365_(VAULT_SPIRIT_DATA_TAG, (Tag)this.serializeVaultSpiritData());
        }
        return compoundTag;
    }

    private CompoundTag serializeVaultSpiritData() {
        CompoundTag ret = new CompoundTag();
        this.vaultSpiritData.forEach((playerId, dataSet) -> {
            CompoundTag dataNbt = new CompoundTag();
            dataSet.forEach(data -> dataNbt.m_128365_(data.vaultId.toString(), (Tag)data.serialize()));
            ret.m_128365_(playerId.toString(), (Tag)dataNbt);
        });
        return ret;
    }

    private ListTag serializeSpiritRecoveries() {
        ListTag spiritRecoveries = new ListTag();
        this.playerSpiritRecoveries.forEach((uuid, count) -> {
            CompoundTag entry = new CompoundTag();
            entry.m_128362_("uuid", uuid);
            entry.m_128405_("count", count.intValue());
            spiritRecoveries.add((Object)entry);
        });
        return spiritRecoveries;
    }

    private CompoundTag serializeHeroDiscounts() {
        CompoundTag tag = new CompoundTag();
        this.heroDiscounts.forEach((playerId, discount) -> tag.m_128350_(playerId.toString(), discount.floatValue()));
        return tag;
    }

    private CompoundTag serializePlayerDrops() {
        CompoundTag tag = new CompoundTag();
        this.playerDrops.forEach((playerId, drops) -> tag.m_128365_(playerId.toString(), (Tag)PlayerSpiritRecoveryData.serializeStacks(drops)));
        return tag;
    }

    private static ListTag serializeStacks(List<ItemStack> lootStacks) {
        ListTag lootStacksNbt = new ListTag();
        lootStacks.forEach(stack -> lootStacksNbt.add((Object)stack.m_41739_(new CompoundTag())));
        return lootStacksNbt;
    }

    private CompoundTag serializeSpiritRecoveryMultipliers() {
        CompoundTag tag = new CompoundTag();
        this.spiritRecoveryMultipliers.forEach((playerId, multiplier) -> tag.m_128350_(playerId.toString(), multiplier.floatValue()));
        return tag;
    }

    private CompoundTag serializeLastVaultLevels() {
        CompoundTag tag = new CompoundTag();
        this.lastVaultLevels.forEach((playerId, level) -> tag.m_128405_(playerId.toString(), level.intValue()));
        return tag;
    }

    public void setSpiritRecoveryMultiplier(UUID playerId, float multiplier) {
        this.spiritRecoveryMultipliers.put(playerId, Float.valueOf(Math.max(1.0f, multiplier)));
        this.m_77762_();
    }

    public void increaseMultiplierOnRecovery(UUID playerId) {
        this.setSpiritRecoveryMultiplier(playerId, this.getSpiritRecoveryMultiplier(playerId) + ModConfigs.SPIRIT.perRecoveryMultiplierIncrease);
        this.playerSpiritRecoveries.compute(playerId, (uuid, count) -> {
            int n;
            if (count == null) {
                n = 1;
            } else {
                count = count + 1;
                n = count;
            }
            return n;
        });
        this.m_77762_();
    }

    public int getSpiritRecoveryCount(UUID playerUuid) {
        return this.playerSpiritRecoveries.getOrDefault(playerUuid, 0);
    }

    public void decreaseMultiplierOnCompletion(UUID playerId) {
        this.setSpiritRecoveryMultiplier(playerId, this.getSpiritRecoveryMultiplier(playerId) * ModConfigs.SPIRIT.getCompletionMultiplierDecrease());
    }

    public void setHeroDiscount(UUID heroId, Random random) {
        this.heroDiscounts.put(heroId, Float.valueOf(Math.max(this.getHeroDiscount(heroId), ModConfigs.SPIRIT.getHeroDiscount(random))));
        this.m_77762_();
    }

    public float getHeroDiscount(UUID heroId) {
        return this.heroDiscounts.getOrDefault(heroId, Float.valueOf(0.0f)).floatValue();
    }

    public void removeHeroDiscount(UUID playerId) {
        this.heroDiscounts.remove(playerId);
        this.m_77762_();
    }

    public float getSpiritRecoveryMultiplier(UUID playerId) {
        return this.spiritRecoveryMultipliers.getOrDefault(playerId, Float.valueOf(1.0f)).floatValue();
    }

    public void putVaultSpiritData(SpiritData spiritData) {
        this.vaultSpiritData.computeIfAbsent(spiritData.vaultId, u -> new HashSet()).add(spiritData);
        this.m_77762_();
    }

    public void removeVaultSpiritData(UUID vaultId) {
        this.vaultSpiritData.remove(vaultId);
        this.m_77762_();
    }

    public void removeVaultSpiritData(UUID playerId, UUID vaultId) {
        this.vaultSpiritData.computeIfPresent(vaultId, (p, dataSet) -> {
            dataSet.removeIf(data -> data.playerId.equals(playerId));
            return dataSet;
        });
        this.m_77762_();
    }

    public Set<SpiritData> getVaultSpiritData(UUID vaultId) {
        return this.vaultSpiritData.getOrDefault(vaultId, Collections.emptySet());
    }

    public static final class SpiritData {
        private final UUID vaultId;
        private final UUID playerId;
        @Deprecated
        private final List<ItemStack> drops;
        private final InventorySnapshot inventorySnapshot;
        private final int vaultLevel;
        private final int playerLevel;
        private final ResourceKey<Level> respawnDimension;
        private final BlockPos respawnPos;
        private final GameProfile playerGameProfile;

        public SpiritData(UUID vaultId, UUID playerId, InventorySnapshot inventorySnapshot, int vaultLevel, int playerLevel, ResourceKey<Level> respawnDimension, BlockPos respawnPos, GameProfile playerGameProfile) {
            this(vaultId, playerId, Collections.emptyList(), inventorySnapshot, vaultLevel, playerLevel, respawnDimension, respawnPos, playerGameProfile);
        }

        private SpiritData(UUID vaultId, UUID playerId, List<ItemStack> drops, InventorySnapshot inventorySnapshot, int vaultLevel, int playerLevel, ResourceKey<Level> respawnDimension, BlockPos respawnPos, GameProfile playerGameProfile) {
            this.vaultId = vaultId;
            this.playerId = playerId;
            this.drops = drops;
            this.inventorySnapshot = inventorySnapshot;
            this.vaultLevel = vaultLevel;
            this.playerLevel = playerLevel;
            this.respawnDimension = respawnDimension;
            this.respawnPos = respawnPos;
            this.playerGameProfile = playerGameProfile;
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("vaultId", this.vaultId);
            tag.m_128362_("playerId", this.playerId);
            tag.m_128365_("drops", (Tag)PlayerSpiritRecoveryData.serializeStacks(this.drops));
            tag.m_128405_("vaultLevel", this.vaultLevel);
            tag.m_128405_("playerLevel", this.playerLevel);
            ResourceLocation.f_135803_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.respawnDimension.m_135782_()).resultOrPartial(arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0)).ifPresent(dimNbt -> tag.m_128365_("respawnDimension", dimNbt));
            tag.m_128356_("respawnPos", this.respawnPos.m_121878_());
            tag.m_128365_("playerGameProfile", (Tag)NbtUtils.m_129230_((CompoundTag)new CompoundTag(), (GameProfile)this.playerGameProfile));
            tag.m_128365_("inventorySnapshot", (Tag)this.inventorySnapshot.serializeNBT());
            return tag;
        }

        public static SpiritData deserialize(CompoundTag tag) {
            InventorySnapshot invSnapshot = new InventorySnapshot(false, false);
            invSnapshot.deserializeNBT(tag.m_128469_("inventorySnapshot"));
            return new SpiritData(tag.m_128342_("vaultId"), tag.m_128342_("playerId"), SpiritData.deserializeStacks(tag.m_128437_("drops", 10)), invSnapshot, tag.m_128451_("vaultLevel"), tag.m_128451_("playerLevel"), (ResourceKey<Level>)Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_("respawnDimension")).resultOrPartial(arg_0 -> ((Logger)VaultMod.LOGGER).error(arg_0)).orElse(Level.f_46428_), BlockPos.m_122022_((long)tag.m_128454_("respawnPos")), NbtUtils.m_129228_((CompoundTag)tag.m_128469_("playerGameProfile")));
        }

        private static List<ItemStack> deserializeStacks(ListTag lootStacksNbt) {
            ArrayList<ItemStack> lootStacks = new ArrayList<ItemStack>();
            lootStacksNbt.forEach(nbt -> lootStacks.add(ItemStack.m_41712_((CompoundTag)((CompoundTag)nbt))));
            return lootStacks;
        }

        public UUID vaultId() {
            return this.vaultId;
        }

        public UUID playerId() {
            return this.playerId;
        }

        public List<ItemStack> drops() {
            return this.drops;
        }

        public int vaultLevel() {
            return this.vaultLevel;
        }

        public int playerLevel() {
            return this.playerLevel;
        }

        public ResourceKey<Level> respawnDimension() {
            return this.respawnDimension;
        }

        public BlockPos respawnPos() {
            return this.respawnPos;
        }

        public GameProfile playerGameProfile() {
            return this.playerGameProfile;
        }

        public InventorySnapshot inventorySnapshot() {
            return this.inventorySnapshot;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            SpiritData that = (SpiritData)obj;
            return Objects.equals(this.vaultId, that.vaultId) && Objects.equals(this.playerId, that.playerId) && Objects.equals(this.drops, that.drops) && this.vaultLevel == that.vaultLevel && this.playerLevel == that.playerLevel && Objects.equals(this.respawnDimension, that.respawnDimension) && Objects.equals(this.respawnPos, that.respawnPos) && Objects.equals(this.playerGameProfile, that.playerGameProfile);
        }

        public int hashCode() {
            return Objects.hash(this.vaultId, this.playerId, this.drops, this.vaultLevel, this.playerLevel, this.respawnDimension, this.respawnPos, this.playerGameProfile);
        }

        public String toString() {
            return "SpiritData[vaultId=" + this.vaultId + ", playerId=" + this.playerId + ", drops=" + this.drops + ", inventorySnapshot=" + this.inventorySnapshot + ", vaultLevel=" + this.vaultLevel + ", playerLevel=" + this.playerLevel + ", respawnDimension=" + this.respawnDimension + ", respawnPos=" + this.respawnPos + ", playerGameProfile=" + this.playerGameProfile + "]";
        }
    }
}

