/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.skill.PlayerVaultStats;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.snapshot.AttributeSnapshotHelper;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerTalentsData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerTalents";
    private Map<UUID, TalentTree> playerMap = new HashMap<UUID, TalentTree>();
    private final Set<UUID> scheduledMerge = new HashSet<UUID>();
    private TalentTree previous;

    public TalentTree getTalents(Player player) {
        return this.getTalents(player.m_142081_());
    }

    public TalentTree getTalents(UUID uuid) {
        return this.playerMap.computeIfAbsent(uuid, uuid1 -> (TalentTree)ModConfigs.TALENTS.get().orElse(new TalentTree()).copy());
    }

    public void setTalents(Player player, TalentTree talentTree) {
        ServerPlayer serverPlayer;
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            this.getTalents(player).getAll(LearnableSkill.class, Skill::isUnlocked).forEach(skill -> skill.onRemove(SkillContext.of(serverPlayer)));
        }
        this.playerMap.put(player.m_142081_(), talentTree);
        if (player instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)player;
            talentTree.getAll(LearnableSkill.class, Skill::isUnlocked).forEach(skill -> skill.onAdd(SkillContext.of(serverPlayer)));
            talentTree.sync(SkillContext.of(serverPlayer));
        }
        this.m_77762_();
    }

    public PlayerTalentsData resetTalentTree(ServerPlayer player) {
        return this;
    }

    public boolean m_77764_() {
        return true;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer()) {
            PlayerTalentsData data = PlayerTalentsData.get((ServerLevel)event.world);
            TalentTree current = ModConfigs.TALENTS.get().orElse(null);
            if (data.previous != current && current != null) {
                data.previous = current;
                data.scheduledMerge.addAll(data.playerMap.keySet());
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer() && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            PlayerTalentsData data = PlayerTalentsData.get(player2.m_183503_());
            if (data.scheduledMerge.remove(player2.m_142081_())) {
                ModConfigs.TALENTS.get().ifPresent(tree -> {
                    SkillContext context = SkillContext.of(player2);
                    data.playerMap.get(player2.m_142081_()).mergeFrom((Skill)tree.copy(), context);
                    PlayerVaultStats stats = PlayerVaultStatsData.get((ServerLevel)player.f_19853_).getVaultStats((Player)player2);
                    stats.setSkillPoints(context.getLearnPoints());
                    stats.setRegretPoints(context.getRegretPoints());
                    AttributeSnapshotHelper.getInstance().refreshSnapshotDelayed(player2);
                });
            }
            data.getTalents((Player)player2).onTick(SkillContext.of(player2));
        }
    }

    private static PlayerTalentsData create(CompoundTag tag) {
        PlayerTalentsData data = new PlayerTalentsData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.playerMap.clear();
        this.scheduledMerge.clear();
        ListTag playerList = nbt.m_128437_("Players", 8);
        ListTag talentList = nbt.m_128437_("Talents", 10);
        if (playerList.size() != talentList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (int i = 0; i < playerList.size(); ++i) {
            UUID playerUUID = UUID.fromString(playerList.m_128778_(i));
            Adapters.SKILL.readNbt((Tag)talentList.m_128728_(i)).ifPresent(tree -> {
                this.playerMap.put(playerUUID, (TalentTree)tree);
                this.scheduledMerge.add(playerUUID);
            });
        }
        this.m_77762_();
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag talentList = new ListTag();
        this.playerMap.forEach((uuid, researchTree) -> Adapters.SKILL.writeNbt(researchTree).ifPresent(tag -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            talentList.add(tag);
        }));
        nbt.m_128365_("Players", (Tag)playerList);
        nbt.m_128365_("Talents", (Tag)talentList);
        return nbt;
    }

    public static PlayerTalentsData get(ServerLevel world) {
        return PlayerTalentsData.get(world.m_142572_());
    }

    public static PlayerTalentsData get(MinecraftServer srv) {
        return (PlayerTalentsData)srv.m_129783_().m_8895_().m_164861_(PlayerTalentsData::create, PlayerTalentsData::new, DATA_NAME);
    }
}

