/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.config.PlayerTitlesConfig;
import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.item.crystal.data.serializable.INbtSerializable;
import iskallia.vault.nbt.VMapNBT;
import iskallia.vault.network.message.UpdateTitlesDataMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerTitlesData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerCustomNames";
    public static PlayerTitlesData CLIENT = new PlayerTitlesData();
    public VMapNBT<UUID, Entry> entries = VMapNBT.ofUUID(Entry::new);

    public void putAll(Map<UUID, Entry> entries) {
        this.entries.putAll(entries);
    }

    public static void setCustomName(Player player, String id, PlayerTitlesConfig.Affix affix) {
        PlayerTitlesData.setCustomName(player.m_142081_(), id, affix, player.f_19853_.m_5776_());
    }

    public static void setCustomName(UUID uuid, String id, PlayerTitlesConfig.Affix affix, boolean isClient) {
        VMapNBT<UUID, Entry> entries = isClient ? PlayerTitlesData.CLIENT.entries : PlayerTitlesData.get().entries;
        Entry entry = (Entry)entries.computeIfAbsent(uuid, _uuid -> new Entry());
        if (affix == PlayerTitlesConfig.Affix.PREFIX) {
            entry.setPrefix(id);
        } else if (affix == PlayerTitlesConfig.Affix.SUFFIX) {
            entry.setSuffix(id);
        }
        entry.setChanged(true);
    }

    public static Optional<MutableComponent> getCustomName(Player player, Component name, Type type) {
        return PlayerTitlesData.getCustomName(player.m_142081_(), name, type, player.f_19853_.m_5776_());
    }

    public static Optional<MutableComponent> getCustomName(UUID uuid, Component name, Type type, boolean isClient) {
        VMapNBT<UUID, Entry> entries = isClient ? PlayerTitlesData.CLIENT.entries : PlayerTitlesData.get().entries;
        return ((Entry)entries.computeIfAbsent(uuid, _uuid -> new Entry())).getCustomName(name, type);
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            ModNetwork.CHANNEL.sendTo((Object)new UpdateTitlesDataMessage(PlayerTitlesData.get().entries), player2.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        HashMap<UUID, Entry> changed = new HashMap<UUID, Entry>();
        PlayerTitlesData.get().entries.forEach((uuid, entry) -> {
            if (entry.changed) {
                changed.put((UUID)uuid, (Entry)entry);
                entry.setChanged(false);
            }
        });
        if (!changed.isEmpty()) {
            ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new UpdateTitlesDataMessage(changed));
        }
    }

    public boolean m_77764_() {
        return true;
    }

    private static PlayerTitlesData load(CompoundTag nbt) {
        PlayerTitlesData data = new PlayerTitlesData();
        data.entries.deserializeNBT(nbt.m_128437_("entries", 10));
        return data;
    }

    @Nonnull
    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("entries", (Tag)this.entries.serializeNBT());
        return nbt;
    }

    public static PlayerTitlesData get() {
        return (PlayerTitlesData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(PlayerTitlesData::load, PlayerTitlesData::new, DATA_NAME);
    }

    public static class Entry
    implements INbtSerializable<CompoundTag> {
        private String prefix;
        private String suffix;
        private boolean changed;

        public Entry() {
            this(null, null);
        }

        public Entry(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.changed = true;
        }

        public Optional<String> getPrefix() {
            return Optional.ofNullable(this.prefix);
        }

        public Optional<String> getSuffix() {
            return Optional.ofNullable(this.suffix);
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
            this.setChanged(true);
        }

        public void setSuffix(String suffix) {
            this.suffix = suffix;
            this.setChanged(true);
        }

        public void setChanged(boolean changed) {
            this.changed = changed;
        }

        public Optional<MutableComponent> getCustomName(Component name, Type type) {
            MutableComponent prefix = ModConfigs.PLAYER_TITLES.get(PlayerTitlesConfig.Affix.PREFIX, this.prefix).map(title -> title.getDisplay(type)).flatMap(PlayerTitlesConfig.Display::getComponent).orElse(null);
            MutableComponent suffix = ModConfigs.PLAYER_TITLES.get(PlayerTitlesConfig.Affix.SUFFIX, this.suffix).map(title -> title.getDisplay(type)).flatMap(PlayerTitlesConfig.Display::getComponent).orElse(null);
            if (prefix == null && suffix == null) {
                return Optional.empty();
            }
            TextComponent component = new TextComponent("");
            if (prefix != null) {
                component.m_7220_((Component)prefix);
            }
            component.m_7220_(name);
            if (suffix != null) {
                component.m_7220_((Component)suffix);
            }
            return Optional.of(component);
        }

        @Override
        public Optional<CompoundTag> writeNbt() {
            CompoundTag nbt = new CompoundTag();
            Adapters.UTF_8.writeNbt(this.prefix).ifPresent(tag -> nbt.m_128365_("Prefix", tag));
            Adapters.UTF_8.writeNbt(this.suffix).ifPresent(tag -> nbt.m_128365_("Suffix", tag));
            return Optional.of(nbt);
        }

        @Override
        public void readNbt(CompoundTag nbt) {
            this.prefix = Adapters.UTF_8.readNbt(nbt.m_128423_("Prefix")).orElse(null);
            this.suffix = Adapters.UTF_8.readNbt(nbt.m_128423_("Suffix")).orElse(null);
        }

        public Entry copy() {
            Entry entry = new Entry();
            entry.prefix = this.prefix;
            entry.suffix = this.suffix;
            entry.changed = this.changed;
            return entry;
        }
    }

    public static enum Type {
        CHAT,
        TAB_LIST;

    }
}

