/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.altar.AltarInfusionRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;

public class PlayerVaultAltarData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_PlayerAltarRecipes";
    private Map<UUID, AltarInfusionRecipe> playerMap = new HashMap<UUID, AltarInfusionRecipe>();
    private HashMap<UUID, List<BlockPos>> playerAltars = new HashMap();

    public AltarInfusionRecipe getRecipe(Player player) {
        return this.getRecipe(player.m_142081_());
    }

    public AltarInfusionRecipe getRecipe(UUID uuid) {
        return this.playerMap.get(uuid);
    }

    public AltarInfusionRecipe getRecipe(ServerPlayer player, BlockPos pos) {
        AltarInfusionRecipe recipe = this.playerMap.computeIfAbsent(player.m_142081_(), k -> new AltarInfusionRecipe(player, pos));
        this.m_77762_();
        return recipe;
    }

    public boolean hasRecipe(UUID uuid) {
        return this.playerMap.containsKey(uuid) && !this.playerMap.get(uuid).getRequiredItems().isEmpty();
    }

    public PlayerVaultAltarData addRecipe(UUID uuid, AltarInfusionRecipe recipe) {
        this.playerMap.put(uuid, recipe);
        this.m_77762_();
        return this;
    }

    public PlayerVaultAltarData removeRecipe(UUID uuid) {
        this.playerMap.remove(uuid);
        this.m_77762_();
        return this;
    }

    public List<BlockPos> getAltars(UUID uuid) {
        this.playerAltars.computeIfAbsent(uuid, k -> new ArrayList());
        this.m_77762_();
        return this.playerAltars.get(uuid);
    }

    public PlayerVaultAltarData addAltar(UUID uuid, BlockPos altarPos) {
        this.getAltars(uuid).add(altarPos);
        this.m_77762_();
        return this;
    }

    public PlayerVaultAltarData removeAltar(UUID uuid, BlockPos altarPos) {
        this.getAltars(uuid).remove(altarPos);
        this.m_77762_();
        return this;
    }

    private static PlayerVaultAltarData create(CompoundTag tag) {
        PlayerVaultAltarData data = new PlayerVaultAltarData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        UUID playerUUID;
        int i;
        ListTag playerList = nbt.m_128437_("PlayerEntries", 8);
        ListTag recipeList = nbt.m_128437_("AltarRecipeEntries", 10);
        ListTag playerBlockPosList = nbt.m_128437_("PlayerBlockPosEntries", 8);
        ListTag blockPosList = nbt.m_128437_("BlockPosEntries", 9);
        if (playerList.size() != recipeList.size() || playerBlockPosList.size() != blockPosList.size()) {
            throw new IllegalStateException("Map doesn't have the same amount of keys as values");
        }
        for (i = 0; i < playerList.size(); ++i) {
            playerUUID = UUID.fromString(playerList.m_128778_(i));
            this.playerMap.put(playerUUID, new AltarInfusionRecipe(recipeList.m_128728_(i)));
        }
        for (i = 0; i < playerBlockPosList.size(); ++i) {
            playerUUID = UUID.fromString(playerBlockPosList.m_128778_(i));
            ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
            for (Tag compound : blockPosList.m_128744_(i)) {
                CompoundTag posTag = (CompoundTag)compound;
                BlockPos pos = NbtUtils.m_129239_((CompoundTag)posTag);
                positions.add(pos);
            }
            this.playerAltars.put(playerUUID, positions);
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag playerList = new ListTag();
        ListTag recipeList = new ListTag();
        ListTag playerBlockPosList = new ListTag();
        ListTag blockPosList = new ListTag();
        this.playerMap.forEach((uuid, recipe) -> {
            playerList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            recipeList.add((Object)recipe.serializeNBT());
        });
        this.playerAltars.forEach((uuid, altarPositions) -> {
            playerBlockPosList.add((Object)StringTag.m_129297_((String)uuid.toString()));
            ListTag positions = new ListTag();
            altarPositions.forEach(pos -> positions.add((Object)NbtUtils.m_129224_((BlockPos)pos)));
            blockPosList.add((Object)positions);
        });
        nbt.m_128365_("PlayerEntries", (Tag)playerList);
        nbt.m_128365_("AltarRecipeEntries", (Tag)recipeList);
        nbt.m_128365_("PlayerBlockPosEntries", (Tag)playerBlockPosList);
        nbt.m_128365_("BlockPosEntries", (Tag)blockPosList);
        return nbt;
    }

    public static PlayerVaultAltarData get(ServerLevel world) {
        return (PlayerVaultAltarData)world.m_142572_().m_129783_().m_8895_().m_164861_(PlayerVaultAltarData::create, PlayerVaultAltarData::new, DATA_NAME);
    }

    public static PlayerVaultAltarData get() {
        return (PlayerVaultAltarData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(PlayerVaultAltarData::create, PlayerVaultAltarData::new, DATA_NAME);
    }
}

