/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.SkyVaultsChunkGenerator;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.quest.QuestState;
import iskallia.vault.quest.base.InVaultQuest;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber
public class QuestStatesData
extends SavedData {
    protected static final String DATA_NAME = "the_vault_QuestStates";
    private boolean isSkyVaultWorld = false;
    private final Map<UUID, QuestState> STATES = new HashMap<UUID, QuestState>();

    public QuestStatesData() {
    }

    public QuestStatesData(CompoundTag tag) {
        this.load(tag);
    }

    public void registerQuestEvents() {
        if (SkyVaultsChunkGenerator.matches((Level)ServerLifecycleHooks.getCurrentServer().m_129783_())) {
            ModConfigs.SKY_QUESTS.getQuests().stream().filter(quest -> !(quest instanceof InVaultQuest)).forEach(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        } else {
            ModConfigs.QUESTS.getQuests().stream().filter(quest -> !(quest instanceof InVaultQuest)).forEach(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).register(arg_0));
        }
    }

    public void setExpertMode(ServerLevel level) {
        for (QuestState state : this.STATES.values()) {
            state.setExpertMode(level);
        }
    }

    public boolean isSkyVaultWorld() {
        return this.isSkyVaultWorld;
    }

    public QuestState getState(ServerPlayer player) {
        return this.getState(player.m_142081_());
    }

    private QuestState getState(UUID playerId) {
        if (!this.STATES.containsKey(playerId)) {
            QuestState state = new QuestState(playerId);
            this.STATES.put(playerId, state);
            this.m_77762_();
        }
        return this.STATES.get(playerId);
    }

    public static QuestStatesData create(CompoundTag tag) {
        return new QuestStatesData(tag);
    }

    public void load(@NotNull CompoundTag tag) {
        this.isSkyVaultWorld = tag.m_128471_("isSkyVaultWorld");
        for (String key : tag.m_128431_()) {
            if (key.equals("isSkyVaultWorld")) continue;
            UUID playerId = UUID.fromString(key);
            this.getState(playerId).deserializeNBT(tag.m_128469_(key));
        }
        this.m_77762_();
    }

    @NotNull
    public CompoundTag m_7176_(@NotNull CompoundTag tag) {
        tag.m_128379_("isSkyVaultWorld", this.isSkyVaultWorld);
        this.STATES.forEach((uuid, questState) -> tag.m_128365_(uuid.toString(), (Tag)questState.serializeNBT()));
        return tag;
    }

    public static QuestStatesData get() {
        return (QuestStatesData)ServerLifecycleHooks.getCurrentServer().m_129783_().m_8895_().m_164861_(QuestStatesData::create, QuestStatesData::new, DATA_NAME);
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        QuestStatesData.get().getState(player2).initialize();
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor world = event.getWorld();
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if (!serverLevel.equals(ServerLifecycleHooks.getCurrentServer().m_129783_())) {
            return;
        }
        QuestStatesData.get().registerQuestEvents();
    }
}

