/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.core.data.adapter.Adapters;
import iskallia.vault.core.net.ArrayBitBuffer;
import iskallia.vault.core.net.BitBuffer;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.network.message.ClientboundSyncSkillAltarDataMessage;
import iskallia.vault.skill.base.GroupedSkill;
import iskallia.vault.skill.base.LearnableSkill;
import iskallia.vault.skill.base.Skill;
import iskallia.vault.skill.base.SkillContext;
import iskallia.vault.skill.base.SpecializedSkill;
import iskallia.vault.skill.base.TieredSkill;
import iskallia.vault.skill.source.SkillSource;
import iskallia.vault.skill.tree.AbilityTree;
import iskallia.vault.skill.tree.TalentTree;
import iskallia.vault.util.nbt.NBTHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SkillAltarData
extends SavedData {
    public static final Comparator<? super TieredSkill> TIERED_SKILL_HIGHEST_LEVEL_COMPARATOR = Comparator.comparingInt(TieredSkill::getUnmodifiedTier).reversed().thenComparing(Skill::getName);
    protected static final String DATA_NAME = "the_vault_SkillAltar";
    public static final Comparator<SpecializedSkill> SPECIALIZED_SKILL_HIGHEST_LEVEL_COMPARATOR = Comparator.comparingInt(skill -> ((TieredSkill)skill.getSpecialization()).getUnmodifiedTier()).reversed().thenComparing(Skill::getName);
    private Map<UUID, Map<Integer, SkillTemplate>> playerSkillTemplates = new HashMap<UUID, Map<Integer, SkillTemplate>>();
    private final Set<UUID> scheduledMerge = new HashSet<UUID>();
    private AbilityTree previousAbilities;
    private TalentTree previousTalents;

    public boolean m_77764_() {
        return true;
    }

    public static SkillAltarData create(CompoundTag tag) {
        SkillAltarData data = new SkillAltarData();
        data.load(tag);
        return data;
    }

    public void updateTemplateIcon(UUID playerId, int templateIndex, SkillIcon icon) {
        Map<Integer, SkillTemplate> templates = this.playerSkillTemplates.get(playerId);
        if (templates == null) {
            return;
        }
        SkillTemplate template = templates.get(templateIndex);
        if (template == null) {
            return;
        }
        template.setIcon(icon);
        this.syncPlayerIconKeys(playerId);
        this.m_77762_();
    }

    public void saveSkillTemplate(UUID playerId, AbilityTree abilityTree, TalentTree talentTree, int templateIndex, SkillIcon icon) {
        AbilityTree abilities = (AbilityTree)abilityTree.copy();
        TalentTree talents = (TalentTree)talentTree.copy();
        this.playerSkillTemplates.computeIfAbsent(playerId, uuid -> new HashMap()).put(templateIndex, new SkillTemplate(abilities, talents, icon));
        this.syncPlayerIconKeys(playerId);
        this.m_77762_();
    }

    public void saveSkillTemplate(UUID playerId, int templateIndex, SkillTemplate template) {
        this.playerSkillTemplates.computeIfAbsent(playerId, uuid -> new HashMap()).put(templateIndex, template);
        this.syncPlayerIconKeys(playerId);
        this.m_77762_();
    }

    private void syncPlayerIconKeys(UUID playerId) {
        Map<Integer, SkillTemplate> templates = this.playerSkillTemplates.get(playerId);
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new ClientboundSyncSkillAltarDataMessage(playerId, SkillAltarData.getOrderedAbilityIconKeys(templates)));
    }

    public Map<Integer, SkillTemplate> getSkillTemplates(UUID playerId) {
        return this.playerSkillTemplates.getOrDefault(playerId, new HashMap());
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer()) {
            SkillAltarData data = SkillAltarData.get((ServerLevel)event.world);
            AbilityTree currentAbilities = ModConfigs.ABILITIES.get().orElse(null);
            TalentTree currentTalents = ModConfigs.TALENTS.get().orElse(null);
            if (data.previousAbilities != currentAbilities && currentAbilities != null) {
                data.previousAbilities = currentAbilities;
                data.scheduledMerge.addAll(data.playerSkillTemplates.keySet());
            }
            if (data.previousTalents != currentTalents && currentTalents != null) {
                data.previousTalents = currentTalents;
                data.scheduledMerge.addAll(data.playerSkillTemplates.keySet());
            }
        }
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side.isServer() && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            SkillAltarData data = SkillAltarData.get(player2.m_183503_());
            if (data.scheduledMerge.remove(player2.m_142081_())) {
                for (SkillTemplate template : data.playerSkillTemplates.get(player2.m_142081_()).values()) {
                    ModConfigs.ABILITIES.get().ifPresent(tree -> template.abilities.mergeFrom((Skill)tree.copy(), SkillContext.empty(0, 0, 0)));
                    ModConfigs.TALENTS.get().ifPresent(tree -> template.talents.mergeFrom((Skill)tree.copy(), SkillContext.empty(0, 0, 0)));
                }
            }
        }
    }

    public void load(CompoundTag nbt) {
        this.playerSkillTemplates = NBTHelper.readMap(nbt, "playerSkillTemplates", UUID::fromString, (uuid, skillTemplatesNbt) -> Optional.of(NBTHelper.deserializeMap((CompoundTag)skillTemplatesNbt, Integer::valueOf, (tagName, tag) -> Optional.of(SkillTemplate.deserializeNBT((CompoundTag)tag))))).orElseGet(HashMap::new);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        NBTHelper.writeMap(nbt, "playerSkillTemplates", this.playerSkillTemplates, UUID::toString, skillTemplates -> NBTHelper.serializeMap(skillTemplates, String::valueOf, SkillTemplate::serializeNBT));
        return nbt;
    }

    public static SkillAltarData get(ServerLevel world) {
        return (SkillAltarData)world.m_142572_().m_129783_().m_8895_().m_164861_(SkillAltarData::create, SkillAltarData::new, DATA_NAME);
    }

    @Nullable
    public SkillTemplate getSkillTemplate(UUID uuid, int templateIndex) {
        if (!this.playerSkillTemplates.containsKey(uuid)) {
            return null;
        }
        return this.playerSkillTemplates.get(uuid).get(templateIndex);
    }

    public void syncTo(ServerPlayer player) {
        HashMap<UUID, List<SkillIcon>> playerAbilityIconKeys = new HashMap<UUID, List<SkillIcon>>();
        this.playerSkillTemplates.forEach((uuid, skillTemplates) -> playerAbilityIconKeys.put((UUID)uuid, SkillAltarData.getOrderedAbilityIconKeys(skillTemplates)));
        ModNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundSyncSkillAltarDataMessage(playerAbilityIconKeys));
    }

    private static List<SkillIcon> getOrderedAbilityIconKeys(Map<Integer, SkillTemplate> skillTemplates) {
        ArrayList<SkillIcon> list = new ArrayList<SkillIcon>();
        for (int i = 0; i < skillTemplates.size(); ++i) {
            if (!skillTemplates.containsKey(i)) continue;
            list.add(skillTemplates.get(i).getIcon());
        }
        return list;
    }

    public static class SkillTemplate {
        private final AbilityTree abilities;
        private final TalentTree talents;
        private SkillIcon icon;

        public SkillTemplate(AbilityTree abilities, TalentTree talents, SkillIcon icon) {
            this.abilities = abilities;
            this.talents = talents;
            this.icon = icon;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            this.abilities.writeNbt().ifPresent(abilitiesNbt -> nbt.m_128365_("abilities", (Tag)abilitiesNbt));
            this.talents.writeNbt().ifPresent(talentsNbt -> nbt.m_128365_("talents", (Tag)talentsNbt));
            nbt.m_128365_("icon", (Tag)this.icon.serializeNBT());
            return nbt;
        }

        public static SkillTemplate deserializeNBT(CompoundTag nbt) {
            AbilityTree abilities = new AbilityTree();
            abilities.readNbt(nbt.m_128469_("abilities"));
            TalentTree talents = new TalentTree();
            talents.readNbt(nbt.m_128469_("talents"));
            if (nbt.m_128441_("topAbilityKey")) {
                return new SkillTemplate(abilities, talents, new SkillIcon(nbt.m_128461_("topAbilityKey"), false));
            }
            return new SkillTemplate(abilities, talents, SkillIcon.deserializeNBT(nbt.m_128469_("icon")));
        }

        public SkillIcon getIcon() {
            return this.icon;
        }

        public TalentTree getTalents() {
            return this.talents;
        }

        public AbilityTree getAbilities() {
            return this.abilities;
        }

        public static void writeTo(@Nullable SkillTemplate template, FriendlyByteBuf buffer) {
            if (template == null) {
                buffer.writeBoolean(false);
                return;
            }
            buffer.writeBoolean(true);
            ArrayBitBuffer bitBuffer = ArrayBitBuffer.empty();
            Adapters.SKILL.writeBits(template.abilities, (BitBuffer)bitBuffer);
            Adapters.SKILL.writeBits(template.talents, (BitBuffer)bitBuffer);
            buffer.m_130091_(bitBuffer.toLongArray());
            template.icon.writeTo(buffer);
        }

        @Nullable
        public static SkillTemplate readFrom(FriendlyByteBuf buffer) {
            if (!buffer.readBoolean()) {
                return null;
            }
            ArrayBitBuffer bitBuffer = ArrayBitBuffer.backing(buffer.m_178381_(), 0);
            AbilityTree abilities = Adapters.SKILL.readBits(bitBuffer).orElse(null);
            TalentTree talents = Adapters.SKILL.readBits(bitBuffer).orElse(null);
            return new SkillTemplate(abilities, talents, SkillIcon.readFrom(buffer));
        }

        public void setIcon(SkillIcon icon) {
            this.icon = icon;
        }

        public String exportToString() {
            StringJoiner abilitiesJoiner = new StringJoiner("|");
            this.abilities.iterate(SpecializedSkill.class, skill -> SkillTemplate.addSkillIfSpeccedInto(abilitiesJoiner, skill.getSpecialization()));
            StringJoiner talentsJoiner = new StringJoiner("|");
            this.talents.iterate(LearnableSkill.class, learnableSkill -> {
                if (!(learnableSkill instanceof GroupedSkill)) {
                    SkillTemplate.addSkillIfSpeccedInto(talentsJoiner, learnableSkill);
                }
            });
            return abilitiesJoiner + ";" + talentsJoiner + ";" + this.icon.key() + "|" + (this.icon.isTalent() ? 1 : 0);
        }

        private static void addSkillIfSpeccedInto(StringJoiner abilitiesJoiner, LearnableSkill learnableSkill) {
            TieredSkill tieredSkill;
            int tier;
            if (learnableSkill instanceof TieredSkill && (tier = (tieredSkill = (TieredSkill)learnableSkill).getUnmodifiedTier()) > 0) {
                abilitiesJoiner.add(learnableSkill.getId() + ":" + tier);
            }
        }

        public static DeserializationResult<SkillTemplate> fromString(String data) {
            String[] split = data.trim().split(";");
            if (split.length != 3) {
                return DeserializationResult.invalid("Template data must include abilities, talents and icon divided with ';'");
            }
            String[] abilitiesString = split[0].split("\\|");
            String[] talentsString = split[1].split("\\|");
            String[] iconString = split[2].split("\\|");
            SkillContext context = new SkillContext(100, 1000, 1000, SkillSource.empty());
            AbilityTree abilities = new AbilityTree();
            abilities.mergeFrom(ModConfigs.ABILITIES.get().orElse(null), context);
            for (String abilityString : abilitiesString) {
                String[] abilitySplit = abilityString.split(":");
                if (abilitySplit.length != 2) {
                    return DeserializationResult.invalid("Invalid ability '" + abilityString + "' must include name and tier divided with ':'");
                }
                if (ModConfigs.ABILITIES.get().flatMap(allAbilities -> allAbilities.getForId(abilitySplit[0])).isEmpty()) {
                    return DeserializationResult.invalid("Invalid ability '" + abilitySplit[0] + "' no such ability exists");
                }
                String specializationId = abilitySplit[0];
                int tier = Integer.parseInt(abilitySplit[1]);
                for (int i = 0; i < tier; ++i) {
                    abilities.learn(specializationId, context);
                }
                abilities.specialize(specializationId, context);
            }
            TalentTree talents = new TalentTree();
            talents.mergeFrom(ModConfigs.TALENTS.get().orElse(null), context);
            for (String talentString : talentsString) {
                String[] talentSplit = talentString.split(":");
                if (talentSplit.length != 2) {
                    return DeserializationResult.invalid("Invalid talent '" + talentString + "' must include name and tier divided with ':'");
                }
                if (ModConfigs.TALENTS.get().flatMap(allTalents -> allTalents.getForId(talentSplit[0])).isEmpty()) {
                    return DeserializationResult.invalid("Invalid talent '" + talentSplit[0] + "' no such talent exists");
                }
                String talentId = talentSplit[0];
                int tier = Integer.parseInt(talentSplit[1]);
                for (int i = 0; i < tier; ++i) {
                    talents.learn(talentId, context);
                }
            }
            SkillIcon icon = iconString.length == 2 ? new SkillIcon(iconString[0], iconString[1].equals("1")) : new SkillIcon("", false);
            return DeserializationResult.valid(new SkillTemplate(abilities, talents, icon));
        }
    }

    public record SkillIcon(String key, boolean isTalent) {
        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("key", this.key);
            nbt.m_128379_("isTalent", this.isTalent);
            return nbt;
        }

        public static SkillIcon deserializeNBT(CompoundTag nbt) {
            return new SkillIcon(nbt.m_128461_("key"), nbt.m_128471_("isTalent"));
        }

        public void writeTo(FriendlyByteBuf buffer) {
            buffer.m_130070_(this.key);
            buffer.writeBoolean(this.isTalent);
        }

        public static SkillIcon readFrom(FriendlyByteBuf buffer) {
            return new SkillIcon(buffer.m_130277_(), buffer.readBoolean());
        }
    }

    public record DeserializationResult<T>(boolean valid, String message, T deserializedValue) {
        public static <T> DeserializationResult<T> valid(T value) {
            return new DeserializationResult<T>(true, "", value);
        }

        public static <T> DeserializationResult<T> invalid(String message) {
            return new DeserializationResult<Object>(false, message, null);
        }
    }
}

