/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.gear.attribute.type.VaultGearAttributeTypeMerger;
import iskallia.vault.gear.data.AttributeGearData;
import iskallia.vault.init.ModGearAttributes;
import iskallia.vault.world.data.InventorySnapshotData;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SoulboundSnapshotData
extends InventorySnapshotData {
    protected static final String DATA_NAME = "the_vault_Soulbound";

    @Override
    protected boolean shouldSnapshotItem(Player player, ItemStack stack) {
        return !stack.m_41619_() && ((AttributeGearData)((Object)AttributeGearData.read(stack))).get(ModGearAttributes.SOULBOUND, VaultGearAttributeTypeMerger.anyTrue()) != false;
    }

    @SubscribeEvent
    public static void onTick(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        if (!player.m_6084_() || !(player.f_19853_ instanceof ServerLevel)) {
            return;
        }
        ServerLevel world = (ServerLevel)event.player.f_19853_;
        SoulboundSnapshotData data = SoulboundSnapshotData.get(world);
        if (data.hasSnapshot(player)) {
            data.restoreSnapshot(player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onDeath(LivingDeathEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)entity;
        SoulboundSnapshotData data = SoulboundSnapshotData.get(sPlayer.m_183503_());
        if (!data.hasSnapshot((Player)sPlayer)) {
            data.createSnapshot((Player)sPlayer);
        }
    }

    private static SoulboundSnapshotData create(CompoundTag tag) {
        SoulboundSnapshotData data = new SoulboundSnapshotData();
        data.load(tag);
        return data;
    }

    public static SoulboundSnapshotData get(ServerLevel world) {
        return (SoulboundSnapshotData)world.m_142572_().m_129783_().m_8895_().m_164861_(SoulboundSnapshotData::create, SoulboundSnapshotData::new, DATA_NAME);
    }
}

