/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.data;

import iskallia.vault.client.ClientPartyData;
import iskallia.vault.init.ModNetwork;
import iskallia.vault.nbt.VListNBT;
import iskallia.vault.network.message.PartyMembersMessage;
import iskallia.vault.network.message.PartyStatusMessage;
import iskallia.vault.util.MiscUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class VaultPartyData
extends SavedData {
    private static final Random rand = new Random();
    protected static final String DATA_NAME = "the_vault_VaultParty";
    protected VListNBT<Party, CompoundTag> activeParties = VListNBT.of(Party::new);

    private static VaultPartyData create(CompoundTag tag) {
        VaultPartyData data = new VaultPartyData();
        data.load(tag);
        return data;
    }

    public void load(CompoundTag nbt) {
        this.activeParties.deserializeNBT(nbt.m_128437_("ActiveParties", 10));
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128365_("ActiveParties", (Tag)this.activeParties.serializeNBT());
        return nbt;
    }

    public static VaultPartyData get(ServerLevel world) {
        return VaultPartyData.get(world.m_142572_());
    }

    public static VaultPartyData get(MinecraftServer server) {
        return (VaultPartyData)server.m_129783_().m_8895_().m_164861_(VaultPartyData::create, VaultPartyData::new, DATA_NAME);
    }

    public static void broadcastPartyData(ServerLevel world) {
        VaultPartyData data = VaultPartyData.get(world);
        ModNetwork.CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)new PartyStatusMessage(data.activeParties.serializeNBT()));
    }

    public Optional<Party> getParty(UUID playerId) {
        return this.activeParties.stream().filter(party -> party.hasMember(playerId)).findFirst();
    }

    public boolean createParty(UUID playerId) {
        if (this.getParty(playerId).isPresent()) {
            return false;
        }
        Party newParty = new Party();
        newParty.addMember(playerId);
        this.activeParties.add(newParty);
        return true;
    }

    public boolean disbandParty(UUID playerId) {
        Optional<Party> party = this.getParty(playerId);
        if (!party.isPresent()) {
            return false;
        }
        this.activeParties.remove(party.get());
        return true;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer serverInstance = ServerLifecycleHooks.getCurrentServer();
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (serverInstance.m_129921_() % 20 == 0) {
            VaultPartyData vaultPartyData = VaultPartyData.get(serverInstance);
            vaultPartyData.activeParties.forEach(party -> {
                ListTag partyMembers = party.toClientMemberList();
                PartyMembersMessage pkt = new PartyMembersMessage(partyMembers);
                party.members.forEach(uuid -> {
                    ServerPlayer player = serverInstance.m_6846_().m_11259_(uuid);
                    if (player != null) {
                        ModNetwork.CHANNEL.sendTo((Object)pkt, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                    }
                });
            });
        }
    }

    public static class Party
    implements INBTSerializable<CompoundTag> {
        private UUID leader = null;
        private final VListNBT<UUID, StringTag> members = VListNBT.ofUUID();
        private final VListNBT<UUID, StringTag> invites = VListNBT.ofUUID();

        public List<UUID> getMembers() {
            return Collections.unmodifiableList(this.members);
        }

        @Nullable
        public UUID getLeader() {
            return this.leader;
        }

        public boolean addMember(UUID member) {
            if (this.members.isEmpty()) {
                this.leader = member;
            }
            return this.members.add(member);
        }

        public boolean invite(UUID member) {
            if (this.invites.contains(member)) {
                return false;
            }
            this.invites.add(member);
            return true;
        }

        public boolean remove(UUID member) {
            boolean removed = this.members.remove(member);
            if (removed && member.equals(this.leader)) {
                this.leader = (UUID)MiscUtils.getRandomEntry(this.members, rand);
            }
            return removed;
        }

        public boolean confirmInvite(UUID member) {
            if (this.invites.contains(member) && this.invites.remove(member)) {
                this.members.add(member);
                return true;
            }
            return false;
        }

        public boolean hasMember(UUID member) {
            return this.members.contains(member);
        }

        public ListTag toClientMemberList() {
            MinecraftServer serverInstance = ServerLifecycleHooks.getCurrentServer();
            ListTag partyMembers = new ListTag();
            for (UUID uuid : this.members) {
                ServerPlayer player = serverInstance.m_6846_().m_11259_(uuid);
                if (player == null) continue;
                ClientPartyData.PartyMember partyMember = new ClientPartyData.PartyMember((Player)player);
                partyMembers.add((Object)partyMember.serializeNBT());
            }
            return partyMembers;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            if (this.leader != null) {
                nbt.m_128362_("leader", this.leader);
            }
            nbt.m_128365_("Members", (Tag)this.members.serializeNBT());
            nbt.m_128365_("Invites", (Tag)this.invites.serializeNBT());
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.leader = null;
            if (nbt.m_128403_("leader")) {
                this.leader = nbt.m_128342_("leader");
            }
            this.members.deserializeNBT(nbt.m_128437_("Members", 8));
            this.invites.deserializeNBT(nbt.m_128437_("Invites", 8));
        }
    }
}

