/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.gen.structure.pool;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import iskallia.vault.init.ModStructures;
import iskallia.vault.world.gen.structure.pool.PalettedSinglePoolElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class PalettedListPoolElement
extends StructurePoolElement {
    public static final Codec<PalettedListPoolElement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)StructurePoolElement.f_210468_.listOf().fieldOf("elements").forGetter(piece -> piece.elements), PalettedListPoolElement.projection(), PalettedListPoolElement.processors()).apply((Applicative)instance, PalettedListPoolElement::new));
    private final List<StructurePoolElement> elements;
    protected final List<Holder<StructureProcessorList>> processors;

    public PalettedListPoolElement(List<StructurePoolElement> elements, StructureTemplatePool.Projection behaviour, List<Holder<StructureProcessorList>> processors) {
        super(behaviour);
        if (elements.isEmpty() && FMLEnvironment.production) {
            throw new IllegalArgumentException("Elements are empty");
        }
        this.elements = elements;
        this.processors = processors;
        this.setProjectionOnEachElement(behaviour);
    }

    public List<StructurePoolElement> getElements() {
        return this.elements;
    }

    protected static <E extends StructurePoolElement> RecordCodecBuilder<E, StructureTemplatePool.Projection> projection() {
        return StructureTemplatePool.Projection.f_210593_.fieldOf("projection").forGetter(StructurePoolElement::m_210539_);
    }

    protected static <E extends PalettedListPoolElement> RecordCodecBuilder<E, List<Holder<StructureProcessorList>>> processors() {
        return StructureProcessorType.f_74468_.listOf().fieldOf("processors").forGetter(piece -> piece.processors);
    }

    public Vec3i m_207466_(StructureManager p_210389_, Rotation p_210390_) {
        int i = 0;
        int j = 0;
        int k = 0;
        for (StructurePoolElement structurepoolelement : this.elements) {
            Vec3i vec3i = structurepoolelement.m_207466_(p_210389_, p_210390_);
            i = Math.max(i, vec3i.m_123341_());
            j = Math.max(j, vec3i.m_123342_());
            k = Math.max(k, vec3i.m_123343_());
        }
        return new Vec3i(i, j, k);
    }

    public List<StructureTemplate.StructureBlockInfo> m_207245_(StructureManager templateManager, BlockPos pos, Rotation rotation, Random random) {
        return this.elements.isEmpty() ? new ArrayList<StructureTemplate.StructureBlockInfo>() : this.elements.get(0).m_207245_(templateManager, pos, rotation, random);
    }

    public BoundingBox m_207470_(StructureManager templateManager, BlockPos pos, Rotation rotation) {
        return BoundingBox.m_162388_(this.elements.stream().map(piece -> piece.m_207470_(templateManager, pos, rotation)).toList()).orElse(BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)Vec3i.f_123288_));
    }

    public boolean m_207251_(StructureManager templateManager, WorldGenLevel world, StructureFeatureManager structureManager, ChunkGenerator chunkGen, BlockPos pos1, BlockPos pos2, Rotation rotation, BoundingBox box, Random random, boolean keepJigsaws) {
        return this.generate(templateManager, world, structureManager, chunkGen, pos1, pos2, rotation, box, random, keepJigsaws, 18);
    }

    public boolean generate(StructureManager templateManager, WorldGenLevel world, StructureFeatureManager structureManager, ChunkGenerator chunkGen, BlockPos pos1, BlockPos pos2, Rotation rotation, BoundingBox box, Random random, boolean keepJigsaws, int updateFlags) {
        Supplier<StructureProcessorList> extra = this.getRandomProcessor(world, pos1);
        for (StructurePoolElement piece : this.elements) {
            if (!(piece instanceof PalettedSinglePoolElement ? !((PalettedSinglePoolElement)piece).generate(extra, templateManager, world, structureManager, chunkGen, pos1, pos2, rotation, box, random, keepJigsaws, updateFlags) : !piece.m_207251_(templateManager, world, structureManager, chunkGen, pos1, pos2, rotation, box, random, keepJigsaws))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public Supplier<StructureProcessorList> getRandomProcessor(WorldGenLevel world, BlockPos pos) {
        if (this.processors.isEmpty()) {
            return null;
        }
        WorldgenRandom seedRand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        seedRand.m_190068_(world.m_7328_(), pos.m_123341_(), pos.m_123343_());
        return () -> (StructureProcessorList)this.processors.get(seedRand.nextInt(this.processors.size())).m_203334_();
    }

    public StructurePoolElementType<?> m_207234_() {
        return ModStructures.PoolElements.PALETTED_LIST_POOL_ELEMENT;
    }

    public StructurePoolElement m_207247_(StructureTemplatePool.Projection placementBehaviour) {
        super.m_207247_(placementBehaviour);
        this.setProjectionOnEachElement(placementBehaviour);
        return this;
    }

    public String toString() {
        return "PalettedList[" + this.elements.stream().map(Object::toString).collect(Collectors.joining(", ")) + "]";
    }

    private void setProjectionOnEachElement(StructureTemplatePool.Projection p_214864_1_) {
        this.elements.forEach(p_214863_1_ -> p_214863_1_.m_207247_(p_214864_1_));
    }
}

