/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.world.stats;

import iskallia.vault.util.data.WeightedList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class RaffleStat
implements INBTSerializable<CompoundTag> {
    private WeightedList<String> contributors = new WeightedList();
    private String winner = "";

    public RaffleStat() {
    }

    public RaffleStat(WeightedList<String> contributors, String winner) {
        this.contributors = contributors.copy();
        this.winner = winner;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        ListTag contributorsList = new ListTag();
        this.contributors.forEach(entry -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Value", (String)entry.value);
            tag.m_128405_("Weight", entry.weight);
            contributorsList.add((Object)tag);
        });
        nbt.m_128365_("Contributors", (Tag)contributorsList);
        if (this.winner != null) {
            nbt.m_128359_("Winner", this.winner);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.contributors.clear();
        ListTag contributorsList = nbt.m_128437_("Contributors", 9);
        contributorsList.stream().map(inbt -> (CompoundTag)inbt).forEach(tag -> this.contributors.add(tag.m_128461_("Value"), tag.m_128451_("Weight")));
        this.winner = nbt.m_128461_("Winner");
    }
}

