/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.block.inv;

import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.block.BlockEntityBotanyPot;
import net.darkhax.botanypots.data.recipes.crop.Crop;
import net.darkhax.botanypots.data.recipes.soil.Soil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class BotanyPotContainer
extends SimpleContainer
implements WorldlyContainer {
    public static final int SOIL_SLOT = 0;
    public static final int CROP_SLOT = 1;
    public static final int[] STORAGE_SLOT = IntStream.range(2, 14).toArray();
    public static final int[] EMPTY_SLOTS = new int[0];
    private final BlockEntityBotanyPot potEntity;
    @Nullable
    private Soil soil = null;
    @Nullable
    private Crop crop = null;
    private int requiredGrowthTime = -1;
    private ItemStack prevSoilStack;
    private ItemStack prevCropStack;

    public BotanyPotContainer(BlockEntityBotanyPot potEntity) {
        super(14);
        this.potEntity = potEntity;
    }

    public ItemStack getSoilStack() {
        return this.m_8020_(0);
    }

    public ItemStack getCropStack() {
        return this.m_8020_(1);
    }

    public int getRequiredGrowthTime() {
        return this.requiredGrowthTime;
    }

    public BlockEntityBotanyPot getPotEntity() {
        return this.potEntity;
    }

    public void update() {
        ItemStack cropStack;
        Level level = this.potEntity.m_58904_();
        BlockPos pos = this.potEntity.m_58899_();
        boolean hasChanged = false;
        ItemStack soilStack = this.getSoilStack();
        if (!soilStack.m_41619_() && this.soil == null) {
            this.soil = BotanyPotHelper.findSoil(level, pos, this.potEntity, soilStack);
            this.prevSoilStack = soilStack;
            boolean bl = hasChanged = this.soil != null;
        }
        if (!(cropStack = this.getCropStack()).m_41619_() && this.crop == null) {
            this.crop = BotanyPotHelper.findCrop(level, pos, this.potEntity, cropStack);
            this.prevCropStack = cropStack;
            hasChanged |= this.crop != null;
        }
        if (hasChanged) {
            this.m_6596_();
        }
    }

    public void m_6596_() {
        ItemStack cropStack;
        super.m_6596_();
        Level level = this.potEntity.m_58904_();
        BlockPos pos = this.potEntity.m_58899_();
        ItemStack soilStack = this.getSoilStack();
        if (this.prevSoilStack != soilStack) {
            this.soil = BotanyPotHelper.findSoil(level, pos, this.potEntity, soilStack);
            this.prevSoilStack = soilStack;
        }
        if (this.prevCropStack != (cropStack = this.getCropStack())) {
            this.crop = BotanyPotHelper.findCrop(level, pos, this.potEntity, cropStack);
            this.prevCropStack = cropStack;
        }
        this.requiredGrowthTime = BotanyPotHelper.getRequiredGrowthTicks(this.potEntity.m_58904_(), this.potEntity.m_58899_(), this.potEntity, this.crop, this.soil);
        int potLight = this.getPotEntity().getLightLevel();
        if (this.getPotEntity().m_58904_() != null && (Integer)this.getPotEntity().m_58900_().m_61143_((Property)BlockStateProperties.f_61422_) != potLight) {
            this.getPotEntity().m_58904_().m_7731_(this.potEntity.m_58899_(), (BlockState)this.getPotEntity().m_58900_().m_61124_((Property)BlockStateProperties.f_61422_, (Comparable)Integer.valueOf(potLight)), 3);
        }
        this.getPotEntity().markDirty();
    }

    @Nullable
    public Crop getCrop() {
        return this.crop;
    }

    @Nullable
    public Soil getSoil() {
        return this.soil;
    }

    public boolean m_7013_(int slotId, ItemStack toPlace) {
        Level level = this.potEntity.m_58904_();
        BlockPos pos = this.potEntity.m_58899_();
        if (slotId == 0 && this.m_8020_(slotId).m_41619_()) {
            return BotanyPotHelper.findSoil(level, pos, this.potEntity, toPlace) != null;
        }
        if (slotId == 1 && this.m_8020_(slotId).m_41619_()) {
            return BotanyPotHelper.findCrop(level, pos, this.potEntity, toPlace) != null;
        }
        return false;
    }

    public int[] m_7071_(Direction side) {
        return side == Direction.DOWN ? STORAGE_SLOT : EMPTY_SLOTS;
    }

    public boolean m_7155_(int slotId, ItemStack toInsert, Direction side) {
        return false;
    }

    public boolean m_7157_(int slotId, ItemStack toExtract, Direction side) {
        return side == Direction.DOWN && this.potEntity.isHopper() && slotId != 0 && slotId != 1;
    }

    public boolean m_6542_(Player player) {
        if (this.potEntity == null || this.potEntity.m_58901_()) {
            return false;
        }
        BlockPos pos = this.potEntity.m_58899_();
        return player.m_20275_((double)((float)pos.m_123341_() + 0.5f), (double)((float)pos.m_123342_() + 0.5f), (double)((float)pos.m_123343_() + 0.5f)) <= 24.0;
    }
}

