/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.cooking.fuel;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.vertex.PoseStack;
import java.text.NumberFormat;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.common.util.MathUtil;
import mezz.jei.config.Constants;
import mezz.jei.gui.textures.Textures;
import mezz.jei.plugins.vanilla.cooking.FurnaceVariantCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;

public class FurnaceFuelCategory
extends FurnaceVariantCategory<IJeiFuelingRecipe> {
    private final IDrawableStatic background;
    private final IDrawableStatic flameTransparentBackground;
    private final Component localizedName;
    private final LoadingCache<Integer, IDrawableAnimated> cachedFlames;
    private final ImmutableRect2i textArea;

    public FurnaceFuelCategory(final IGuiHelper guiHelper, Textures textures) {
        super(guiHelper);
        Minecraft minecraft = Minecraft.m_91087_();
        Font fontRenderer = minecraft.f_91062_;
        Component maxSmeltCountText = FurnaceFuelCategory.createSmeltCountText(2000000000);
        int maxStringWidth = fontRenderer.m_92895_(maxSmeltCountText.getString());
        int backgroundHeight = 34;
        int textPadding = 20;
        this.background = guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 0, 134, 18, backgroundHeight).addPadding(0, 0, 0, textPadding + maxStringWidth).build();
        this.textArea = new ImmutableRect2i(20, 0, textPadding + maxStringWidth, backgroundHeight);
        this.flameTransparentBackground = textures.getFlameIcon();
        this.localizedName = new TranslatableComponent("gui.jei.category.fuel");
        this.cachedFlames = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(){

            public IDrawableAnimated load(Integer burnTime) {
                return guiHelper.drawableBuilder(Constants.RECIPE_GUI_VANILLA, 82, 114, 14, 14).buildAnimated(burnTime, IDrawableAnimated.StartDirection.TOP, true);
            }
        });
    }

    @Override
    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    @Override
    public Class<? extends IJeiFuelingRecipe> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    @Override
    public RecipeType<IJeiFuelingRecipe> getRecipeType() {
        return RecipeTypes.FUELING;
    }

    @Override
    public Component getTitle() {
        return this.localizedName;
    }

    @Override
    public IDrawable getIcon() {
        return this.flameTransparentBackground;
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, IJeiFuelingRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addItemStacks(recipe.getInputs());
    }

    @Override
    public void draw(IJeiFuelingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack poseStack, double mouseX, double mouseY) {
        int burnTime = recipe.getBurnTime();
        IDrawableAnimated flame = (IDrawableAnimated)this.cachedFlames.getUnchecked((Object)burnTime);
        flame.draw(poseStack, 1, 0);
        Minecraft minecraft = Minecraft.m_91087_();
        Font font = minecraft.f_91062_;
        Component smeltCountText = FurnaceFuelCategory.createSmeltCountText(burnTime);
        ImmutableRect2i centerArea = MathUtil.centerTextArea(this.textArea, font, (FormattedText)smeltCountText);
        font.m_92889_(poseStack, smeltCountText, (float)centerArea.getX(), (float)centerArea.getY(), -8355712);
    }

    private static Component createSmeltCountText(int burnTime) {
        if (burnTime == 200) {
            return new TranslatableComponent("gui.jei.category.fuel.smeltCount.single");
        }
        NumberFormat numberInstance = NumberFormat.getNumberInstance();
        numberInstance.setMaximumFractionDigits(2);
        String smeltCount = numberInstance.format((float)burnTime / 200.0f);
        return new TranslatableComponent("gui.jei.category.fuel.smeltCount", new Object[]{smeltCount});
    }
}

