/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.blockentity.BlockEntityInterface;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;

public class Interface
extends BlockWithEntity
implements CubeDetector.IDetectionListener,
IBlockChestMaterial {
    public static final BooleanProperty ENABLED = ColossalChest.ENABLED;
    private final ChestMaterial material;

    public Interface(BlockBehaviour.Properties properties, ChestMaterial material) {
        super(properties, BlockEntityInterface::new);
        this.material = material;
        material.setBlockInterface(this);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(false)));
    }

    public String m_7705_() {
        String baseKey = super.m_7705_();
        return baseKey.substring(0, baseKey.lastIndexOf(95));
    }

    @Override
    public ChestMaterial getMaterial() {
        return this.material;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ENABLED});
    }

    public RenderShape m_7514_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)ENABLED) != false ? RenderShape.ENTITYBLOCK_ANIMATED : super.m_7514_(blockState);
    }

    public boolean m_7420_(BlockState blockState, BlockGetter blockReader, BlockPos blockPos) {
        return (Boolean)blockState.m_61143_((Property)ENABLED);
    }

    public boolean isValidSpawn(BlockState state, BlockGetter world, BlockPos pos, SpawnPlacements.Type type, EntityType<?> entityType) {
        return false;
    }

    public boolean shouldDisplayFluidOverlay(BlockState blockState, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
        ColossalChest.triggerDetector(this.material, (LevelAccessor)world, pos, true, placer instanceof Player ? (Player)placer : null);
    }

    public void m_6807_(BlockState blockStateNew, Level world, BlockPos blockPos, BlockState blockStateOld, boolean isMoving) {
        super.m_6807_(blockStateNew, world, blockPos, blockStateOld, isMoving);
        if (!world.captureBlockSnapshots && blockStateNew.m_60734_() != blockStateOld.m_60734_() && !((Boolean)blockStateNew.m_61143_((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (LevelAccessor)world, blockPos, true, null);
        }
    }

    public void m_6786_(LevelAccessor world, BlockPos blockPos, BlockState blockState) {
        if (((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, world, blockPos, false, null);
        }
        super.m_6786_(world, blockPos, blockState);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        if (((Boolean)world.m_8055_(pos).m_61143_((Property)ENABLED)).booleanValue()) {
            ColossalChest.triggerDetector(this.material, (LevelAccessor)world, pos, false, null);
        }
        world.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        this.m_7592_(world, pos, explosion);
    }

    public void onDetect(LevelReader world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
        Block block = world.m_8055_(location).m_60734_();
        if (block == this) {
            boolean change = (Boolean)world.m_8055_(location).m_61143_((Property)ENABLED) == false;
            ((LevelWriter)world).m_7731_(location, (BlockState)world.m_8055_(location).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(valid)), 2);
            if (change) {
                BlockPos tileLocation = ColossalChest.getCoreLocation(this.material, world, location);
                BlockEntityInterface tile = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)location, BlockEntityInterface.class).orElse(null);
                if (tile != null && tileLocation != null) {
                    tile.setCorePosition((Vec3i)tileLocation);
                    BlockEntityColossalChest core = BlockEntityHelpers.get((BlockGetter)world, (BlockPos)tileLocation, BlockEntityColossalChest.class).orElse(null);
                    if (core != null) {
                        core.addInterface((Vec3i)location);
                    }
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        if (((Boolean)blockState.m_61143_((Property)ENABLED)).booleanValue()) {
            BlockPos tileLocation = ColossalChest.getCoreLocation(this.material, (LevelReader)world, blockPos);
            if (tileLocation != null) {
                return world.m_8055_(tileLocation).m_60734_().m_6227_(blockState, world, tileLocation, player, hand, rayTraceResult);
            }
        } else {
            ColossalChest.addPlayerChatError(this.material, world, blockPos, player, hand);
            return InteractionResult.FAIL;
        }
        return super.m_6227_(blockState, world, blockPos, player, hand, rayTraceResult);
    }

    public boolean m_7898_(BlockState blockState, LevelReader world, BlockPos blockPos) {
        return super.m_7898_(blockState, world, blockPos) && ColossalChest.canPlace(world, blockPos);
    }

    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        if (this.material.isExplosionResistant()) {
            return 10000.0f;
        }
        return 0.0f;
    }
}

