/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.Calendar;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class RenderTileEntityChestBase<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final ModelPart doubleLeftLid;
    private final ModelPart doubleLeftBottom;
    private final ModelPart doubleLeftLock;
    private final ModelPart doubleRightLid;
    private final ModelPart doubleRightBottom;
    private final ModelPart doubleRightLock;
    private boolean xmasTextures;

    public RenderTileEntityChestBase(BlockEntityRendererProvider.Context context) {
        Calendar calendar = Calendar.getInstance();
        if (calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26) {
            this.xmasTextures = true;
        }
        ModelPart modelpart = context.m_173582_(ModelLayers.f_171275_);
        this.bottom = modelpart.m_171324_("bottom");
        this.lid = modelpart.m_171324_("lid");
        this.lock = modelpart.m_171324_("lock");
        ModelPart modelpart1 = context.m_173582_(ModelLayers.f_171133_);
        this.doubleLeftBottom = modelpart1.m_171324_("bottom");
        this.doubleLeftLid = modelpart1.m_171324_("lid");
        this.doubleLeftLock = modelpart1.m_171324_("lock");
        ModelPart modelpart2 = context.m_173582_(ModelLayers.f_171134_);
        this.doubleRightBottom = modelpart2.m_171324_("bottom");
        this.doubleRightLid = modelpart2.m_171324_("lid");
        this.doubleRightLock = modelpart2.m_171324_("lock");
    }

    protected abstract Direction getDirection(T var1);

    protected Material getMaterial(T tileEntity) {
        return Sheets.m_110767_(tileEntity, (ChestType)ChestType.SINGLE, (boolean)this.xmasTextures);
    }

    protected void handleRotation(T tile, PoseStack matrixStack) {
        float f = this.getDirection(tile).m_122435_();
        matrixStack.m_85845_(Vector3f.f_122225_.m_122240_(-f));
    }

    public void m_6922_(T tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.5, 0.5, 0.5);
        this.handleRotation(tileEntityIn, matrixStackIn);
        matrixStackIn.m_85837_(-0.5, -0.5, -0.5);
        float f1 = ((LidBlockEntity)tileEntityIn).m_6683_(partialTicks);
        f1 = 1.0f - f1;
        f1 = 1.0f - f1 * f1 * f1;
        Material material = this.getMaterial(tileEntityIn);
        VertexConsumer ivertexbuilder = material.m_119194_(bufferIn, RenderType::m_110452_);
        this.render(matrixStackIn, ivertexbuilder, this.lid, this.lock, this.bottom, f1, combinedLightIn, combinedOverlayIn);
        matrixStackIn.m_85849_();
    }

    private void render(PoseStack p_228871_1_, VertexConsumer p_228871_2_, ModelPart p_228871_3_, ModelPart p_228871_4_, ModelPart p_228871_5_, float p_228871_6_, int p_228871_7_, int p_228871_8_) {
        p_228871_4_.f_104203_ = p_228871_3_.f_104203_ = -(p_228871_6_ * 1.5707964f);
        p_228871_3_.m_104301_(p_228871_1_, p_228871_2_, p_228871_7_, p_228871_8_);
        p_228871_4_.m_104301_(p_228871_1_, p_228871_2_, p_228871_7_, p_228871_8_);
        p_228871_5_.m_104301_(p_228871_1_, p_228871_2_, p_228871_7_, p_228871_8_);
    }
}

