/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.cyclops.colossalchests.Advancements;
import org.cyclops.colossalchests.block.ChestMaterial;
import org.cyclops.colossalchests.block.ChestWall;
import org.cyclops.colossalchests.block.ColossalChest;
import org.cyclops.colossalchests.block.IBlockChestMaterial;
import org.cyclops.colossalchests.block.Interface;
import org.cyclops.colossalchests.blockentity.BlockEntityColossalChest;
import org.cyclops.colossalchests.blockentity.BlockEntityInterface;
import org.cyclops.cyclopscore.block.multi.DetectionResult;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.inventory.PlayerInventoryIterator;
import org.cyclops.cyclopscore.inventory.SimpleInventory;

public class ItemUpgradeTool
extends Item {
    private final boolean upgrade;

    public ItemUpgradeTool(Item.Properties properties, boolean upgrade) {
        super(properties);
        this.upgrade = upgrade;
    }

    public boolean isUpgrade() {
        return this.upgrade;
    }

    public InteractionResult onItemUseFirst(ItemStack itemStack, UseOnContext context) {
        BlockState blockState = context.m_43725_().m_8055_(context.m_8083_());
        if (blockState.m_60734_() instanceof IBlockChestMaterial && ((Boolean)BlockHelpers.getSafeBlockStateProperty((BlockState)blockState, (Property)ColossalChest.ENABLED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            BlockPos tileLocation = ColossalChest.getCoreLocation(((IBlockChestMaterial)blockState.m_60734_()).getMaterial(), (LevelReader)context.m_43725_(), context.m_8083_());
            BlockEntityColossalChest tile = BlockEntityHelpers.get((BlockGetter)context.m_43725_(), (BlockPos)tileLocation, BlockEntityColossalChest.class).orElse(null);
            ChestMaterial newType = this.transformType(itemStack, tile.getMaterial());
            if (newType == null) {
                if (context.m_43725_().m_5776_()) {
                    return InteractionResult.PASS;
                }
                ColossalChest.addPlayerChatError(context.m_43723_(), (Component)new TranslatableComponent("multiblock.colossalchests.error.upgradeLimit"));
                return InteractionResult.FAIL;
            }
            Component firstError = null;
            do {
                Component error;
                if ((error = this.attemptTransform(context.m_43725_(), context.m_8083_(), context.m_43723_(), tile, newType, tile.getMaterial(), context.m_43724_())) != null) {
                    if (firstError != null) continue;
                    firstError = error;
                    continue;
                }
                return context.m_43725_().m_5776_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
            } while ((newType = this.transformType(itemStack, newType)) != null);
            ColossalChest.addPlayerChatError(context.m_43723_(), firstError);
            return context.m_43725_().m_5776_() ? InteractionResult.PASS : InteractionResult.FAIL;
        }
        return context.m_43725_().m_5776_() ? InteractionResult.PASS : InteractionResult.SUCCESS;
    }

    protected Component attemptTransform(Level world, BlockPos pos, Player player, BlockEntityColossalChest tile, ChestMaterial newType, ChestMaterial currentType, InteractionHand hand) {
        Vec3i size = tile.getSize();
        ChestMaterial validMaterial = null;
        Wrapper requiredCoresCount = new Wrapper((Object)0);
        Wrapper requiredInterfacesCount = new Wrapper((Object)0);
        Wrapper requiredWallsCount = new Wrapper((Object)0);
        for (ChestMaterial material : ChestMaterial.VALUES) {
            DetectionResult result = material.getChestDetector().detect((LevelReader)world, pos, null, (location, blockState) -> {
                if (blockState.m_60734_() instanceof ColossalChest) {
                    requiredCoresCount.set((Object)((Integer)requiredCoresCount.get() + 1));
                } else if (blockState.m_60734_() instanceof Interface) {
                    requiredInterfacesCount.set((Object)((Integer)requiredInterfacesCount.get() + 1));
                } else if (blockState.m_60734_() instanceof ChestWall) {
                    requiredWallsCount.set((Object)((Integer)requiredWallsCount.get() + 1));
                }
                return null;
            }, false);
            if (result.getError() != null) continue;
            validMaterial = material;
            break;
        }
        ItemStack requiredCores = new ItemStack((ItemLike)newType.getBlockCore(), ((Integer)requiredCoresCount.get()).intValue());
        ItemStack requiredInterfaces = new ItemStack((ItemLike)newType.getBlockInterface(), ((Integer)requiredInterfacesCount.get()).intValue());
        ItemStack requiredWalls = new ItemStack((ItemLike)newType.getBlockWall(), ((Integer)requiredWallsCount.get()).intValue());
        if (validMaterial == null) {
            return new TranslatableComponent("multiblock.colossalchests.error.unexpected");
        }
        if (!(this.consumeItems(player, requiredCores, true) && this.consumeItems(player, requiredInterfaces, true) && this.consumeItems(player, requiredWalls, true))) {
            return new TranslatableComponent("multiblock.colossalchests.error.upgrade", new Object[]{requiredCores.m_41613_(), requiredInterfaces.m_41613_(), requiredWalls.m_41613_(), new TranslatableComponent(newType.getUnlocalizedName())});
        }
        this.consumeItems(player, requiredCores.m_41777_(), false);
        this.consumeItems(player, requiredInterfaces.m_41777_(), false);
        this.consumeItems(player, requiredWalls.m_41777_(), false);
        if (!world.f_46443_) {
            tile.setSize(Vec3i.f_123288_);
            SimpleInventory oldInventory = tile.getLastValidInventory();
            Direction oldRotation = tile.getRotation();
            Vec3 oldRenderOffset = tile.getRenderOffset();
            ArrayList oldInterfaceLocations = Lists.newArrayList(tile.getInterfaceLocations());
            Wrapper coreLocation = new Wrapper(null);
            ArrayList interfaceLocations = Lists.newArrayList();
            validMaterial.getChestDetector().detect((LevelReader)world, pos, null, (location, blockState) -> {
                BlockState blockStateNew = null;
                if (blockState.m_60734_() instanceof ColossalChest) {
                    coreLocation.set((Object)location);
                    blockStateNew = newType.getBlockCore().m_49966_();
                } else if (blockState.m_60734_() instanceof Interface) {
                    blockStateNew = newType.getBlockInterface().m_49966_();
                    interfaceLocations.add(location);
                } else if (blockState.m_60734_() instanceof ChestWall) {
                    blockStateNew = newType.getBlockWall().m_49966_();
                }
                world.m_7731_(location, (BlockState)blockStateNew.m_61124_((Property)ColossalChest.ENABLED, (Comparable)((Boolean)blockState.m_61143_((Property)ColossalChest.ENABLED))), 2);
                if (blockState.m_60734_() instanceof ColossalChest || blockState.m_60734_() instanceof Interface) {
                    tile.addInterface((Vec3i)location);
                }
                return null;
            }, false);
            BlockEntityColossalChest tileNew = (BlockEntityColossalChest)((Object)BlockEntityHelpers.get((BlockGetter)world, (BlockPos)((BlockPos)coreLocation.get()), BlockEntityColossalChest.class).orElseThrow(() -> new IllegalStateException("Could not find a colossal chest core location during upgrading.")));
            tileNew.setLastValidInventory(oldInventory);
            tileNew.setMaterial(newType);
            tileNew.setRotation(oldRotation);
            tileNew.setRenderOffset(oldRenderOffset);
            for (Vec3i oldInterfaceLocation : oldInterfaceLocations) {
                tileNew.addInterface(oldInterfaceLocation);
            }
            tileNew.setSize(size);
            for (BlockPos interfaceLocation : interfaceLocations) {
                BlockEntityInterface tileInterface = (BlockEntityInterface)((Object)BlockEntityHelpers.get((BlockGetter)world, (BlockPos)interfaceLocation, BlockEntityInterface.class).orElseThrow(() -> new IllegalStateException("Could not find a colossal chest interface location during upgrading.")));
                tileInterface.setCorePosition((Vec3i)coreLocation.get());
            }
            Advancements.CHEST_FORMED.test((ServerPlayer)player, newType, size.m_123341_() + 1);
        }
        ItemStack returnedCores = new ItemStack((ItemLike)currentType.getBlockCore(), requiredCores.m_41613_());
        ItemStack returnedInterfaces = new ItemStack((ItemLike)currentType.getBlockInterface(), requiredInterfaces.m_41613_());
        ItemStack returnedWalls = new ItemStack((ItemLike)currentType.getBlockWall(), requiredWalls.m_41613_());
        InventoryHelpers.tryReAddToStack((Player)player, (ItemStack)ItemStack.f_41583_, (ItemStack)returnedCores, (InteractionHand)hand);
        InventoryHelpers.tryReAddToStack((Player)player, (ItemStack)ItemStack.f_41583_, (ItemStack)returnedInterfaces, (InteractionHand)hand);
        InventoryHelpers.tryReAddToStack((Player)player, (ItemStack)ItemStack.f_41583_, (ItemStack)returnedWalls, (InteractionHand)hand);
        return null;
    }

    protected boolean consumeItems(Player player, ItemStack consumeStack, boolean simulate) {
        if (player.m_7500_()) {
            return true;
        }
        PlayerInventoryIterator it = new PlayerInventoryIterator(player);
        int validItems = 0;
        while (it.hasNext()) {
            ItemStack stack = it.next();
            if (stack.m_41619_() || !ItemStack.m_41746_((ItemStack)stack, (ItemStack)consumeStack)) continue;
            int previousValidItems = validItems;
            validItems += stack.m_41613_();
            validItems = Math.min(consumeStack.m_41613_(), validItems);
            if (simulate) continue;
            stack.m_41774_(validItems - previousValidItems);
            it.replace(stack.m_41613_() == 0 ? ItemStack.f_41583_ : stack);
        }
        return validItems == consumeStack.m_41613_();
    }

    protected ChestMaterial transformType(ItemStack itemStack, ChestMaterial type) {
        if (this.upgrade && type.ordinal() < ChestMaterial.VALUES.size() - 1) {
            return ChestMaterial.VALUES.get(type.ordinal() + 1);
        }
        if (!this.upgrade && type.ordinal() > 0) {
            return ChestMaterial.VALUES.get(type.ordinal() - 1);
        }
        return null;
    }
}

