/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.compat;

import java.util.function.Consumer;
import net.blay09.mods.balm.api.fluid.FluidTank;
import net.blay09.mods.cookingforblockheads.CookingForBlockheadsConfig;
import net.blay09.mods.cookingforblockheads.tile.CowJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.FridgeBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.MilkJarBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.OvenBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.SinkBlockEntity;
import net.blay09.mods.cookingforblockheads.tile.ToasterBlockEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CookingForBlockheadsWailaUtils {
    public static final ResourceLocation MILK_JAR_UID = new ResourceLocation("cookingforblockheads", "milk_jar");
    public static final ResourceLocation TOASTER_UID = new ResourceLocation("cookingforblockheads", "toaster");
    public static final ResourceLocation OVEN_UID = new ResourceLocation("cookingforblockheads", "oven");
    public static final ResourceLocation FRIDGE_UID = new ResourceLocation("cookingforblockheads", "fridge");
    public static final ResourceLocation SINK_UID = new ResourceLocation("cookingforblockheads", "sink");

    public static void appendMilkJarTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        CowJarBlockEntity cowJar;
        if (blockEntity instanceof CowJarBlockEntity && (cowJar = (CowJarBlockEntity)blockEntity).m_7770_() != null) {
            tooltipConsumer.accept(cowJar.m_7770_());
        }
        if (blockEntity instanceof MilkJarBlockEntity) {
            MilkJarBlockEntity milkJar = (MilkJarBlockEntity)blockEntity;
            FluidTank fluidTank = milkJar.getFluidTank();
            tooltipConsumer.accept((Component)new TranslatableComponent("waila.cookingforblockheads:milk_stored", new Object[]{fluidTank.getAmount(), fluidTank.getCapacity()}));
        }
    }

    public static void appendToasterTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        ToasterBlockEntity toaster;
        if (blockEntity instanceof ToasterBlockEntity && (toaster = (ToasterBlockEntity)blockEntity).isActive()) {
            tooltipConsumer.accept((Component)new TranslatableComponent("waila.cookingforblockheads:toast_progress", new Object[]{(int)(toaster.getToastProgress() * 100.0f)}));
        }
    }

    public static void appendOvenTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        OvenBlockEntity oven;
        if (blockEntity instanceof OvenBlockEntity && (oven = (OvenBlockEntity)blockEntity).hasPowerUpgrade()) {
            tooltipConsumer.accept((Component)new TranslatableComponent("waila.cookingforblockheads:heating_unit"));
        }
    }

    public static void appendFridgeTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        if (blockEntity instanceof FridgeBlockEntity) {
            FridgeBlockEntity fridge = (FridgeBlockEntity)blockEntity;
            if (fridge.hasIceUpgrade()) {
                tooltipConsumer.accept((Component)new TranslatableComponent("waila.cookingforblockheads:ice_unit"));
            }
            if (fridge.hasPreservationUpgrade()) {
                tooltipConsumer.accept((Component)new TranslatableComponent("waila.cookingforblockheads:preservation_chamber"));
            }
        }
    }

    public static void appendSinkTooltip(BlockEntity blockEntity, Player player, Consumer<Component> tooltipConsumer) {
        if (blockEntity instanceof SinkBlockEntity) {
            SinkBlockEntity sink = (SinkBlockEntity)blockEntity;
            if (CookingForBlockheadsConfig.getActive().sinkRequiresWater) {
                FluidTank fluidTank = sink.getFluidTank();
                tooltipConsumer.accept((Component)new TranslatableComponent("waila.cookingforblockheads:water_stored", new Object[]{fluidTank.getAmount(), fluidTank.getCapacity()}));
            }
        }
    }

    private CookingForBlockheadsWailaUtils() {
    }

    @FunctionalInterface
    public static interface TooltipAppender {
        public void appendTooltip(BlockEntity var1, Player var2, Consumer<Component> var3);
    }
}

