/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.BalmEnvironment;
import net.blay09.mods.waystones.api.IMutableWaystone;
import net.blay09.mods.waystones.api.IWaystone;
import net.blay09.mods.waystones.api.WaystoneActivatedEvent;
import net.blay09.mods.waystones.block.WaystoneBlock;
import net.blay09.mods.waystones.block.WaystoneBlockBase;
import net.blay09.mods.waystones.block.entity.WarpPlateBlockEntity;
import net.blay09.mods.waystones.config.DimensionalWarp;
import net.blay09.mods.waystones.config.InventoryButtonMode;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.core.IPlayerWaystoneData;
import net.blay09.mods.waystones.core.InMemoryPlayerWaystoneData;
import net.blay09.mods.waystones.core.PersistentPlayerWaystoneData;
import net.blay09.mods.waystones.core.WarpMode;
import net.blay09.mods.waystones.core.WaystoneEditPermissions;
import net.blay09.mods.waystones.core.WaystoneManager;
import net.blay09.mods.waystones.core.WaystoneSyncManager;
import net.blay09.mods.waystones.core.WaystoneTeleportContext;
import net.blay09.mods.waystones.core.WaystoneTypes;
import net.blay09.mods.waystones.item.ModItems;
import net.blay09.mods.waystones.network.message.TeleportEffectMessage;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerationMode;
import net.blay09.mods.waystones.worldgen.namegen.NameGenerator;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class PlayerWaystoneManager {
    private static final Logger logger = LogManager.getLogger();
    private static final IPlayerWaystoneData persistentPlayerWaystoneData = new PersistentPlayerWaystoneData();
    private static final IPlayerWaystoneData inMemoryPlayerWaystoneData = new InMemoryPlayerWaystoneData();

    public static boolean mayBreakWaystone(Player player, BlockGetter world, BlockPos pos) {
        if (WaystonesConfig.getActive().restrictToCreative() && !player.m_150110_().f_35937_) {
            return false;
        }
        return WaystoneManager.get(player.m_20194_()).getWaystoneAt(world, pos).map(waystone -> {
            if (!player.m_150110_().f_35937_) {
                if (waystone.wasGenerated() && WaystonesConfig.getActive().generatedWaystonesUnbreakable()) {
                    return false;
                }
                boolean isGlobal = waystone.isGlobal();
                boolean mayBreakGlobalWaystones = !WaystonesConfig.getActive().globalWaystoneRequiresCreative();
                return !isGlobal || mayBreakGlobalWaystones;
            }
            return true;
        }).orElse(true);
    }

    public static boolean mayPlaceWaystone(@Nullable Player player) {
        return !WaystonesConfig.getActive().restrictToCreative() || player != null && player.m_150110_().f_35937_;
    }

    public static WaystoneEditPermissions mayEditWaystone(Player player, Level world, IWaystone waystone) {
        if (WaystonesConfig.getActive().restrictToCreative() && !player.m_150110_().f_35937_) {
            return WaystoneEditPermissions.NOT_CREATIVE;
        }
        if (WaystonesConfig.getActive().restrictRenameToOwner() && !waystone.isOwner(player)) {
            return WaystoneEditPermissions.NOT_THE_OWNER;
        }
        if (waystone.isGlobal() && !player.m_150110_().f_35937_ && WaystonesConfig.getActive().globalWaystoneRequiresCreative()) {
            return WaystoneEditPermissions.GET_CREATIVE;
        }
        return WaystoneEditPermissions.ALLOW;
    }

    public static boolean isWaystoneActivated(Player player, IWaystone waystone) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).isWaystoneActivated(player, waystone);
    }

    public static void activateWaystone(Player player, IWaystone waystone) {
        if (!waystone.hasName() && waystone instanceof IMutableWaystone && waystone.wasGenerated()) {
            NameGenerationMode nameGenerationMode = WaystonesConfig.getActive().nameGenerationMode();
            String name = NameGenerator.get(player.m_20194_()).getName(waystone, player.f_19853_.f_46441_, nameGenerationMode);
            ((IMutableWaystone)((Object)waystone)).setName(name);
        }
        if (!waystone.hasOwner() && waystone instanceof IMutableWaystone) {
            ((IMutableWaystone)((Object)waystone)).setOwnerUid(player.m_142081_());
        }
        if (player.m_20194_() != null) {
            WaystoneManager.get(player.m_20194_()).m_77762_();
        }
        if (!PlayerWaystoneManager.isWaystoneActivated(player, waystone) && waystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE)) {
            PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).activateWaystone(player, waystone);
            Balm.getEvents().fireEvent((Object)new WaystoneActivatedEvent(player, waystone));
        }
    }

    public static int getExperienceLevelCost(Entity player, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        WaystoneTeleportContext context = new WaystoneTeleportContext();
        context.setLeashedEntities(PlayerWaystoneManager.findLeashedAnimals(player));
        context.setFromWaystone(fromWaystone);
        return PlayerWaystoneManager.getExperienceLevelCost(player, waystone, warpMode, context);
    }

    public static int getExperienceLevelCost(Entity entity, IWaystone waystone, WarpMode warpMode, WaystoneTeleportContext context) {
        double xpLevelCost;
        if (!(entity instanceof Player)) {
            return 0;
        }
        Player player = (Player)entity;
        if (context.getFromWaystone() != null && waystone.getWaystoneUid().equals(context.getFromWaystone().getWaystoneUid())) {
            return 0;
        }
        boolean enableXPCost = !player.m_150110_().f_35937_;
        int xpForLeashed = WaystonesConfig.getActive().xpCostPerLeashed() * context.getLeashedEntities().size();
        double xpCostMultiplier = warpMode.getXpCostMultiplier();
        if (waystone.isGlobal()) {
            xpCostMultiplier *= WaystonesConfig.getActive().globalWaystoneXpCostMultiplier();
        }
        BlockPos pos = waystone.getPos();
        double dist = Math.sqrt(player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()));
        double minimumXpCost = WaystonesConfig.getActive().minimumXpCost();
        double maximumXpCost = WaystonesConfig.getActive().maximumXpCost();
        if (waystone.getDimension() != player.f_19853_.m_46472_()) {
            int dimensionalWarpXpCost = WaystonesConfig.getActive().dimensionalWarpXpCost();
            xpLevelCost = Mth.m_14008_((double)dimensionalWarpXpCost, (double)minimumXpCost, (double)dimensionalWarpXpCost);
        } else if (WaystonesConfig.getActive().blocksPerXPLevel() > 0) {
            xpLevelCost = Mth.m_14008_((double)(dist / (double)WaystonesConfig.getActive().blocksPerXPLevel()), (double)minimumXpCost, (double)maximumXpCost);
            if (WaystonesConfig.getActive().inverseXpCost()) {
                xpLevelCost = maximumXpCost - xpLevelCost;
            }
        } else {
            xpLevelCost = minimumXpCost;
        }
        return enableXPCost ? (int)Math.round((xpLevelCost + (double)xpForLeashed) * xpCostMultiplier) : 0;
    }

    @Nullable
    public static IWaystone getInventoryButtonWaystone(Player player) {
        InventoryButtonMode inventoryButtonMode = WaystonesConfig.getActive().getInventoryButtonMode();
        if (inventoryButtonMode.isReturnToNearest()) {
            return PlayerWaystoneManager.getNearestWaystone(player);
        }
        if (inventoryButtonMode.hasNamedTarget()) {
            return WaystoneManager.get(player.m_20194_()).findWaystoneByName(inventoryButtonMode.getNamedTarget()).orElse(null);
        }
        return null;
    }

    public static boolean canUseInventoryButton(Player player) {
        IWaystone waystone = PlayerWaystoneManager.getInventoryButtonWaystone(player);
        int xpLevelCost = waystone != null ? PlayerWaystoneManager.getExperienceLevelCost((Entity)player, waystone, WarpMode.INVENTORY_BUTTON, (IWaystone)null) : 0;
        return PlayerWaystoneManager.getInventoryButtonCooldownLeft(player) <= 0L && (xpLevelCost <= 0 || player.f_36078_ >= xpLevelCost);
    }

    public static boolean canUseWarpStone(Player player, ItemStack heldItem) {
        return PlayerWaystoneManager.getWarpStoneCooldownLeft(player) <= 0L;
    }

    public static double getCooldownMultiplier(IWaystone waystone) {
        return waystone.isGlobal() ? WaystonesConfig.getActive().globalWaystoneCooldownMultiplier() : 1.0;
    }

    private static void informPlayer(Entity entity, String translationKey) {
        if (entity instanceof Player) {
            TranslatableComponent chatComponent = new TranslatableComponent(translationKey);
            chatComponent.m_130940_(ChatFormatting.RED);
            ((Player)entity).m_5661_((Component)chatComponent, false);
        }
    }

    public static boolean tryTeleportToWaystone(Entity entity, IWaystone waystone, WarpMode warpMode, @Nullable IWaystone fromWaystone) {
        Player player;
        boolean isCreativeMode;
        BlockState state;
        MinecraftServer server;
        boolean isDimensionalWarp;
        if (!waystone.isValid()) {
            logger.info("Rejected teleport to invalid waystone");
            return false;
        }
        ItemStack warpItem = PlayerWaystoneManager.findWarpItem(entity, warpMode);
        if (!PlayerWaystoneManager.canUseWarpMode(entity, warpMode, warpItem, fromWaystone)) {
            logger.info("Rejected teleport using warp mode {}", (Object)warpMode);
            return false;
        }
        if (!warpMode.getAllowTeleportPredicate().test(entity, waystone)) {
            logger.info("Rejected teleport due to predicate");
            return false;
        }
        boolean bl = isDimensionalWarp = waystone.getDimension() != entity.f_19853_.m_46472_();
        if (isDimensionalWarp && !PlayerWaystoneManager.canDimensionalWarpBetween(entity, waystone)) {
            logger.info("Rejected dimensional teleport");
            PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_dimension_warp");
            return false;
        }
        List<Mob> leashed = PlayerWaystoneManager.findLeashedAnimals(entity);
        if (!leashed.isEmpty()) {
            if (!WaystonesConfig.getActive().transportLeashed()) {
                logger.info("Rejected teleport with leashed entities");
                PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_transport_leashed");
                return false;
            }
            List forbidden = WaystonesConfig.getActive().leashedDenyList().stream().map(ResourceLocation::new).collect(Collectors.toList());
            if (leashed.stream().anyMatch(e -> forbidden.contains(Registry.f_122826_.m_7981_((Object)e.m_6095_())))) {
                logger.info("Rejected teleport with denied leashed entity");
                PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_transport_this_leashed");
                return false;
            }
            if (isDimensionalWarp && !WaystonesConfig.getActive().transportLeashedDimensional()) {
                logger.info("Rejected teleport with dimensionally denied leashed entity");
                PlayerWaystoneManager.informPlayer(entity, "chat.waystones.cannot_transport_leashed_dimensional");
                return false;
            }
        }
        if ((server = entity.m_20194_()) == null) {
            logger.info("Rejected teleport due to missing server");
            return false;
        }
        ServerLevel targetWorld = Objects.requireNonNull(server).m_129880_(waystone.getDimension());
        BlockPos pos = waystone.getPos();
        BlockState blockState = state = targetWorld != null ? targetWorld.m_8055_(pos) : null;
        if (targetWorld == null || !(state.m_60734_() instanceof WaystoneBlockBase)) {
            logger.info("Rejected teleport due to missing waystone");
            PlayerWaystoneManager.informPlayer(entity, "chat.waystones.waystone_missing");
            return false;
        }
        Direction direction = (Direction)state.m_61143_((Property)WaystoneBlock.FACING);
        ArrayList directionCandidates = Lists.newArrayList((Object[])new Direction[]{direction, Direction.EAST, Direction.WEST, Direction.SOUTH, Direction.NORTH});
        for (Direction candidate : directionCandidates) {
            BlockPos offsetPos = pos.m_142300_(candidate);
            BlockPos offsetPosUp = offsetPos.m_7494_();
            if (targetWorld.m_8055_(offsetPos).m_60828_((BlockGetter)targetWorld, offsetPos) || targetWorld.m_8055_(offsetPosUp).m_60828_((BlockGetter)targetWorld, offsetPosUp)) continue;
            direction = candidate;
            break;
        }
        WaystoneTeleportContext context = new WaystoneTeleportContext();
        context.setLeashedEntities(leashed);
        context.setDirection(direction);
        context.setTargetWorld(targetWorld);
        context.setFromWaystone(fromWaystone);
        int xpLevelCost = PlayerWaystoneManager.getExperienceLevelCost(entity, waystone, warpMode, context);
        if (entity instanceof Player && ((Player)entity).f_36078_ < xpLevelCost) {
            logger.info("Rejected teleport due to missing xp");
            return false;
        }
        boolean bl2 = isCreativeMode = entity instanceof Player && ((Player)entity).m_150110_().f_35937_;
        if (warpMode.consumesItem() && !isCreativeMode) {
            warpItem.m_41774_(1);
        }
        if (entity instanceof Player) {
            player = (Player)entity;
            if (warpMode == WarpMode.INVENTORY_BUTTON) {
                int cooldown = (int)((double)WaystonesConfig.getActive().inventoryButtonCooldown() * PlayerWaystoneManager.getCooldownMultiplier(waystone));
                PlayerWaystoneManager.getPlayerWaystoneData(entity.f_19853_).setInventoryButtonCooldownUntil(player, player.f_19853_.m_46467_() + (long)cooldown * 20L);
                WaystoneSyncManager.sendWaystoneCooldowns(player);
            } else if (warpMode == WarpMode.WARP_STONE) {
                int cooldown = (int)((double)WaystonesConfig.getActive().warpStoneCooldown() * PlayerWaystoneManager.getCooldownMultiplier(waystone));
                PlayerWaystoneManager.getPlayerWaystoneData(entity.f_19853_).setWarpStoneCooldownUntil(player, player.f_19853_.m_46467_() + (long)cooldown * 20L);
                WaystoneSyncManager.sendWaystoneCooldowns(player);
            }
            if (xpLevelCost > 0) {
                player.m_6749_(-xpLevelCost);
            }
        }
        PlayerWaystoneManager.teleportToWaystone(entity, waystone, context);
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
            player.f_8906_.m_141995_((Packet)new ClientboundSetExperiencePacket(player.f_36080_, player.f_36079_, player.f_36078_));
        }
        return true;
    }

    private static boolean canDimensionalWarpBetween(Entity player, IWaystone waystone) {
        ResourceLocation fromDimension = player.f_19853_.m_46472_().m_135782_();
        ResourceLocation toDimension = waystone.getDimension().m_135782_();
        List<String> dimensionAllowList = WaystonesConfig.getActive().dimensionalWarpAllowList();
        List<String> dimensionDenyList = WaystonesConfig.getActive().dimensionalWarpDenyList();
        if (!(dimensionAllowList.isEmpty() || dimensionAllowList.contains(toDimension.toString()) && dimensionAllowList.contains(fromDimension.toString()))) {
            return false;
        }
        if (!dimensionDenyList.isEmpty() && (dimensionDenyList.contains(toDimension.toString()) || dimensionDenyList.contains(fromDimension.toString()))) {
            return false;
        }
        DimensionalWarp dimensionalWarpMode = WaystonesConfig.getActive().dimensionalWarp();
        return dimensionalWarpMode == DimensionalWarp.ALLOW || dimensionalWarpMode == DimensionalWarp.GLOBAL_ONLY && waystone.isGlobal();
    }

    private static ItemStack findWarpItem(Entity entity, WarpMode warpMode) {
        switch (warpMode) {
            case WARP_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.warpScroll);
            }
            case WARP_STONE: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.warpStone);
            }
            case RETURN_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.returnScroll);
            }
            case BOUND_SCROLL: {
                return PlayerWaystoneManager.findWarpItem(entity, ModItems.boundScroll);
            }
        }
        return ItemStack.f_41583_;
    }

    private static ItemStack findWarpItem(Entity entity, Item warpItem) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.m_21205_().m_41720_() == warpItem) {
                return livingEntity.m_21205_();
            }
            if (livingEntity.m_21206_().m_41720_() == warpItem) {
                return livingEntity.m_21206_();
            }
        }
        return ItemStack.f_41583_;
    }

    private static List<Mob> findLeashedAnimals(Entity player) {
        return player.f_19853_.m_6443_(Mob.class, new AABB(player.m_142538_()).m_82400_(10.0), e -> player.equals((Object)e.m_21524_()));
    }

    private static void teleportToWaystone(Entity entity, IWaystone waystone, WaystoneTeleportContext context) {
        BlockEntity targetTileEntity;
        ServerLevel sourceWorld = (ServerLevel)entity.f_19853_;
        BlockPos sourcePos = entity.m_142538_();
        BlockPos pos = waystone.getPos();
        Direction direction = context.getDirection();
        ServerLevel targetWorld = context.getTargetWorld();
        BlockPos targetPos = waystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE) ? pos : pos.m_142300_(direction);
        Vec3 targetPos3d = new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
        Entity mount = entity.m_20202_();
        if (mount != null) {
            entity.m_8127_();
            mount = PlayerWaystoneManager.teleportEntity(mount, targetWorld, targetPos3d, direction);
        }
        if ((targetTileEntity = context.getTargetWorld().m_7702_(waystone.getPos())) instanceof WarpPlateBlockEntity) {
            ((WarpPlateBlockEntity)targetTileEntity).markEntityForCooldown(entity);
            if (mount != null) {
                ((WarpPlateBlockEntity)targetTileEntity).markEntityForCooldown(mount);
            }
            context.getLeashedEntities().forEach(((WarpPlateBlockEntity)targetTileEntity)::markEntityForCooldown);
        }
        Entity updatedEntity = PlayerWaystoneManager.teleportEntity(entity, targetWorld, targetPos3d, direction);
        if (mount != null) {
            updatedEntity.m_20329_(mount);
        }
        sourceWorld.m_5594_(null, sourcePos, SoundEvents.f_12287_, SoundSource.PLAYERS, 0.1f, 1.0f);
        targetWorld.m_5594_(null, targetPos, SoundEvents.f_12287_, SoundSource.PLAYERS, 0.1f, 1.0f);
        Balm.getNetworking().sendToTracking(sourceWorld, sourcePos, (Object)new TeleportEffectMessage(sourcePos));
        Balm.getNetworking().sendToTracking(targetWorld, targetPos, (Object)new TeleportEffectMessage(targetPos));
        context.getLeashedEntities().forEach(mob -> {
            Entity updatedMobEntity = PlayerWaystoneManager.teleportEntity((Entity)mob, targetWorld, targetPos3d, direction);
            if (updatedMobEntity instanceof Mob) {
                Mob updatedMob = (Mob)updatedMobEntity;
                updatedMob.m_21463_(updatedEntity, true);
            }
        });
    }

    private static Entity teleportEntity(Entity entity, ServerLevel targetWorld, Vec3 targetPos3d, Direction direction) {
        float yaw = direction.m_122435_();
        double x = targetPos3d.f_82479_;
        double y = targetPos3d.f_82480_;
        double z = targetPos3d.f_82481_;
        if (entity instanceof ServerPlayer) {
            ChunkPos chunkPos = new ChunkPos(new BlockPos(x, y, z));
            targetWorld.m_7726_().m_8387_(TicketType.f_9448_, chunkPos, 1, (Object)entity.m_142049_());
            entity.m_8127_();
            if (((ServerPlayer)entity).m_5803_()) {
                ((ServerPlayer)entity).m_6145_(true, true);
            }
            if (targetWorld == entity.f_19853_) {
                ((ServerPlayer)entity).f_8906_.m_9780_(x, y, z, yaw, entity.m_146909_(), Collections.emptySet());
            } else {
                ((ServerPlayer)entity).m_8999_(targetWorld, x, y, z, yaw, entity.m_146909_());
            }
            entity.m_5616_(yaw);
        } else {
            float pitch = Mth.m_14036_((float)entity.m_146909_(), (float)-90.0f, (float)90.0f);
            if (targetWorld == entity.f_19853_) {
                entity.m_7678_(x, y, z, yaw, pitch);
                entity.m_5616_(yaw);
            } else {
                entity.m_19877_();
                Entity oldEntity = entity;
                entity = entity.m_6095_().m_20615_((Level)targetWorld);
                if (entity == null) {
                    return oldEntity;
                }
                entity.m_20361_(oldEntity);
                entity.m_7678_(x, y, z, yaw, pitch);
                entity.m_5616_(yaw);
                oldEntity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                targetWorld.m_143334_(entity);
            }
        }
        if (!(entity instanceof LivingEntity) || !((LivingEntity)entity).m_21255_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            entity.m_6853_(true);
        }
        if (entity instanceof PathfinderMob) {
            ((PathfinderMob)entity).m_21573_().m_26573_();
        }
        return entity;
    }

    public static void deactivateWaystone(Player player, IWaystone waystone) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).deactivateWaystone(player, waystone);
    }

    private static boolean canUseWarpMode(Entity entity, WarpMode warpMode, ItemStack heldItem, @Nullable IWaystone fromWaystone) {
        switch (warpMode) {
            case INVENTORY_BUTTON: {
                return entity instanceof Player && PlayerWaystoneManager.canUseInventoryButton((Player)entity);
            }
            case WARP_SCROLL: {
                return !heldItem.m_41619_() && heldItem.m_41720_() == ModItems.warpScroll;
            }
            case BOUND_SCROLL: {
                return !heldItem.m_41619_() && heldItem.m_41720_() == ModItems.boundScroll;
            }
            case RETURN_SCROLL: {
                return !heldItem.m_41619_() && heldItem.m_41720_() == ModItems.returnScroll;
            }
            case WARP_STONE: {
                return !heldItem.m_41619_() && heldItem.m_41720_() == ModItems.warpStone && entity instanceof Player && PlayerWaystoneManager.canUseWarpStone((Player)entity, heldItem);
            }
            case WAYSTONE_TO_WAYSTONE: {
                return WaystonesConfig.getActive().allowWaystoneToWaystoneTeleport() && fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WAYSTONE);
            }
            case SHARESTONE_TO_SHARESTONE: {
                return fromWaystone != null && fromWaystone.isValid() && WaystoneTypes.isSharestone(fromWaystone.getWaystoneType());
            }
            case WARP_PLATE: {
                return fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.WARP_PLATE);
            }
            case PORTSTONE_TO_WAYSTONE: {
                return fromWaystone != null && fromWaystone.isValid() && fromWaystone.getWaystoneType().equals((Object)WaystoneTypes.PORTSTONE);
            }
        }
        return false;
    }

    public static long getWarpStoneCooldownUntil(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).getWarpStoneCooldownUntil(player);
    }

    public static long getWarpStoneCooldownLeft(Player player) {
        long cooldownUntil = PlayerWaystoneManager.getWarpStoneCooldownUntil(player);
        return Math.max(0L, cooldownUntil - player.f_19853_.m_46467_());
    }

    public static void setWarpStoneCooldownUntil(Player player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).setWarpStoneCooldownUntil(player, timeStamp);
    }

    public static long getInventoryButtonCooldownUntil(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).getInventoryButtonCooldownUntil(player);
    }

    public static long getInventoryButtonCooldownLeft(Player player) {
        long cooldownUntil = PlayerWaystoneManager.getInventoryButtonCooldownUntil(player);
        return Math.max(0L, cooldownUntil - player.f_19853_.m_46467_());
    }

    public static void setInventoryButtonCooldownUntil(Player player, long timeStamp) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).setInventoryButtonCooldownUntil(player, timeStamp);
    }

    @Nullable
    public static IWaystone getNearestWaystone(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).getWaystones(player).stream().filter(it -> it.getDimension() == player.f_19853_.m_46472_()).min((first, second) -> {
            double firstDist = first.getPos().m_203198_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            double secondDist = second.getPos().m_203198_(player.m_20185_(), player.m_20186_(), player.m_20189_());
            return (int)Math.round(firstDist) - (int)Math.round(secondDist);
        }).orElse(null);
    }

    public static List<IWaystone> getWaystones(Player player) {
        return PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).getWaystones(player);
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(@Nullable Level world) {
        return world == null || world.f_46443_ ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static IPlayerWaystoneData getPlayerWaystoneData(BalmEnvironment side) {
        return side.isClient() ? inMemoryPlayerWaystoneData : persistentPlayerWaystoneData;
    }

    public static boolean mayTeleportToWaystone(Player player, IWaystone waystone) {
        return true;
    }

    public static void swapWaystoneSorting(Player player, int index, int otherIndex) {
        PlayerWaystoneManager.getPlayerWaystoneData(player.f_19853_).swapWaystoneSorting(player, index, otherIndex);
    }

    public static boolean mayEditGlobalWaystones(Player player) {
        return player.m_150110_().f_35937_ || !WaystonesConfig.getActive().globalWaystoneRequiresCreative();
    }

    public static void activeWaystoneForEveryone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            if (PlayerWaystoneManager.isWaystoneActivated((Player)player, waystone)) continue;
            PlayerWaystoneManager.activateWaystone((Player)player, waystone);
        }
    }

    public static void removeKnownWaystone(@Nullable MinecraftServer server, IWaystone waystone) {
        if (server == null) {
            return;
        }
        List players = server.m_6846_().m_11314_();
        for (ServerPlayer player : players) {
            PlayerWaystoneManager.deactivateWaystone((Player)player, waystone);
            WaystoneSyncManager.sendActivatedWaystones((Player)player);
        }
    }
}

