/*
 * Decompiled with CFR 0.152.
 */
package com.girafi.waddles.entity;

import com.girafi.waddles.init.PenguinRegistry;
import com.girafi.waddles.init.WaddlesSounds;
import com.girafi.waddles.utils.ConfigurationHandler;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;

public class AdeliePenguinEntity
extends Animal {
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42526_, Items.f_42527_});
    public short rotationFlipper;
    private boolean moveFlipper = false;

    public AdeliePenguinEntity(EntityType<? extends AdeliePenguinEntity> adelie, Level level) {
        super(adelie, level);
        this.f_19793_ = 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EntityAIExtinguishFire());
        this.f_21345_.m_25352_(2, (Goal)new PanicGoal((PathfinderMob)this, 1.5));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new TemptGoal((PathfinderMob)this, 1.0, TEMPTATION_ITEMS, false));
        this.f_21345_.m_25352_(6, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.16);
    }

    public float m_5610_(@Nonnull BlockPos pos, @Nonnull LevelReader levelReader) {
        Block blockDown = levelReader.m_8055_(pos.m_7495_()).m_60734_();
        if (blockDown.getRegistryName() != null && ((List)ConfigurationHandler.GENERAL.spawnBlocks.get()).contains(blockDown.getRegistryName().toString())) {
            return 10.0f;
        }
        return super.m_5610_(pos, levelReader);
    }

    protected SoundEvent m_7515_() {
        return this.m_6162_() ? (SoundEvent)WaddlesSounds.ADELIE_BABY_AMBIENT.get() : (SoundEvent)WaddlesSounds.ADELIE_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource source) {
        return (SoundEvent)WaddlesSounds.ADELIE_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)WaddlesSounds.ADELIE_DEATH.get();
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_ && this.m_20185_() != this.f_19856_ && this.moveFlipper) {
            this.rotationFlipper = (short)(this.rotationFlipper + 1);
        }
    }

    protected int m_6552_(@Nonnull Player player) {
        if (((Boolean)ConfigurationHandler.GENERAL.dropExp.get()).booleanValue()) {
            return super.m_6552_(player);
        }
        return 0;
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6898_(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && TEMPTATION_ITEMS.test(stack);
    }

    @Nonnull
    public ResourceLocation m_7582_() {
        return (Boolean)ConfigurationHandler.GENERAL.dropFish.get() != false ? super.m_7582_() : BuiltInLootTables.f_78712_;
    }

    public AgeableMob m_142606_(@Nonnull ServerLevel serverLevel, @Nonnull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)PenguinRegistry.ADELIE_PENGUIN.get()).m_20615_(this.f_19853_);
    }

    public static boolean canPenguinSpawn(EntityType<? extends AdeliePenguinEntity> animal, LevelAccessor levelAccessor, MobSpawnType spawnType, BlockPos pos, Random random) {
        return AdeliePenguinEntity.m_27577_(animal, (LevelAccessor)levelAccessor, (MobSpawnType)spawnType, (BlockPos)pos, (Random)random);
    }

    protected float m_6431_(@Nonnull Pose pose, @Nonnull EntityDimensions entityDimensions) {
        return this.m_6162_() ? 0.5f : 0.9f;
    }

    private class EntityAIExtinguishFire
    extends PanicGoal {
        EntityAIExtinguishFire() {
            super((PathfinderMob)AdeliePenguinEntity.this, 2.0);
        }

        public boolean m_8036_() {
            return (AdeliePenguinEntity.this.m_6162_() || AdeliePenguinEntity.this.m_6060_()) && super.m_8036_();
        }
    }
}

