/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.pigment;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.providers.IPigmentProvider;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public final class PigmentStack
extends ChemicalStack<Pigment> {
    public static final PigmentStack EMPTY = new PigmentStack(MekanismAPI.EMPTY_PIGMENT, 0L);

    public PigmentStack(IPigmentProvider pigmentProvider, long amount) {
        super((Pigment)pigmentProvider.getChemical(), amount);
    }

    public PigmentStack(PigmentStack stack, long amount) {
        this((IPigmentProvider)stack.getType(), amount);
    }

    @Override
    protected IRegistryDelegate<Pigment> getDelegate(Pigment pigment) {
        if (MekanismAPI.pigmentRegistry().getKey((IForgeRegistryEntry)pigment) == null) {
            MekanismAPI.logger.fatal("Failed attempt to create a PigmentStack for an unregistered Pigment {} (type {})", (Object)pigment.getRegistryName(), (Object)pigment.getClass().getName());
            throw new IllegalArgumentException("Cannot create a PigmentStack from an unregistered Pigment");
        }
        return pigment.delegate;
    }

    @Override
    protected Pigment getEmptyChemical() {
        return MekanismAPI.EMPTY_PIGMENT;
    }

    public static PigmentStack readFromNBT(@Nullable CompoundTag nbtTags) {
        if (nbtTags == null || nbtTags.m_128456_()) {
            return EMPTY;
        }
        Pigment type = Pigment.readFromNBT(nbtTags);
        if (type.isEmptyType()) {
            return EMPTY;
        }
        long amount = nbtTags.m_128454_("amount");
        if (amount <= 0L) {
            return EMPTY;
        }
        return new PigmentStack(type, amount);
    }

    public static PigmentStack readFromPacket(FriendlyByteBuf buf) {
        Pigment pigment = (Pigment)buf.readRegistryId();
        long amount = buf.m_130258_();
        if (pigment.isEmptyType()) {
            return EMPTY;
        }
        return new PigmentStack(pigment, amount);
    }

    public PigmentStack copy() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        return new PigmentStack(this, this.getAmount());
    }
}

