/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.datagen.recipe.builder;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.SerializerHelper;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.datagen.recipe.MekanismRecipeBuilder;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ItemStackChemicalToItemStackRecipeBuilder<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends ChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipeBuilder<ItemStackChemicalToItemStackRecipeBuilder<CHEMICAL, STACK, INGREDIENT>> {
    private final ItemStackIngredient itemInput;
    private final INGREDIENT chemicalInput;
    private final ItemStack output;

    protected ItemStackChemicalToItemStackRecipeBuilder(ResourceLocation serializerName, ItemStackIngredient itemInput, INGREDIENT chemicalInput, ItemStack output) {
        super(serializerName);
        this.itemInput = itemInput;
        this.chemicalInput = chemicalInput;
        this.output = output;
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> compressing(ItemStackIngredient itemInput, ChemicalStackIngredient.GasStackIngredient gasInput, ItemStack output) {
        if (output.m_41619_()) {
            throw new IllegalArgumentException("This compressing recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("compressing"), itemInput, gasInput, output);
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> purifying(ItemStackIngredient itemInput, ChemicalStackIngredient.GasStackIngredient gasInput, ItemStack output) {
        if (output.m_41619_()) {
            throw new IllegalArgumentException("This purifying recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("purifying"), itemInput, gasInput, output);
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient> injecting(ItemStackIngredient itemInput, ChemicalStackIngredient.GasStackIngredient gasInput, ItemStack output) {
        if (output.m_41619_()) {
            throw new IllegalArgumentException("This injecting recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Gas, GasStack, ChemicalStackIngredient.GasStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("injecting"), itemInput, gasInput, output);
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient> metallurgicInfusing(ItemStackIngredient itemInput, ChemicalStackIngredient.InfusionStackIngredient infusionInput, ItemStack output) {
        if (output.m_41619_()) {
            throw new IllegalArgumentException("This metallurgic infusing recipe requires a non empty output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<InfuseType, InfusionStack, ChemicalStackIngredient.InfusionStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("metallurgic_infusing"), itemInput, infusionInput, output);
    }

    public static ItemStackChemicalToItemStackRecipeBuilder<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient> painting(ItemStackIngredient itemInput, ChemicalStackIngredient.PigmentStackIngredient pigmentInput, ItemStack output) {
        if (output.m_41619_()) {
            throw new IllegalArgumentException("This painting recipe requires a non empty item output.");
        }
        return new ItemStackChemicalToItemStackRecipeBuilder<Pigment, PigmentStack, ChemicalStackIngredient.PigmentStackIngredient>(ItemStackChemicalToItemStackRecipeBuilder.mekSerializer("painting"), itemInput, pigmentInput, output);
    }

    @Override
    protected ItemStackChemicalToItemStackRecipeResult getResult(ResourceLocation id) {
        return new ItemStackChemicalToItemStackRecipeResult(id);
    }

    public void build(Consumer<FinishedRecipe> consumer) {
        this.build(consumer, this.output.m_41720_().getRegistryName());
    }

    public class ItemStackChemicalToItemStackRecipeResult
    extends MekanismRecipeBuilder.RecipeResult {
        protected ItemStackChemicalToItemStackRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            json.add("itemInput", ItemStackChemicalToItemStackRecipeBuilder.this.itemInput.serialize());
            json.add("chemicalInput", ItemStackChemicalToItemStackRecipeBuilder.this.chemicalInput.serialize());
            json.add("output", SerializerHelper.serializeItemStack(ItemStackChemicalToItemStackRecipeBuilder.this.output));
        }
    }
}

