/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear;

import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.gear.ICustomModule;
import mekanism.api.gear.IModule;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

@ParametersAreNonnullByDefault
public abstract class EnchantmentBasedModule<MODULE extends EnchantmentBasedModule<MODULE>>
implements ICustomModule<MODULE> {
    @Nonnull
    public abstract Enchantment getEnchantment();

    @Override
    public void onAdded(IModule<MODULE> module, boolean first) {
        if (module.isEnabled()) {
            if (first) {
                module.getContainer().m_41663_(this.getEnchantment(), 1);
            } else {
                Map enchantments = EnchantmentHelper.m_44831_((ItemStack)module.getContainer());
                enchantments.put(this.getEnchantment(), module.getInstalledCount());
                EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)module.getContainer());
            }
        }
    }

    @Override
    public void onRemoved(IModule<MODULE> module, boolean last) {
        if (module.isEnabled()) {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)module.getContainer());
            if (last) {
                enchantments.remove(this.getEnchantment());
            } else {
                enchantments.put(this.getEnchantment(), module.getInstalledCount());
            }
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)module.getContainer());
        }
    }

    @Override
    public void onEnabledStateChange(IModule<MODULE> module) {
        if (module.isEnabled()) {
            module.getContainer().m_41663_(this.getEnchantment(), module.getInstalledCount());
        } else {
            Map enchantments = EnchantmentHelper.m_44831_((ItemStack)module.getContainer());
            enchantments.remove(this.getEnchantment());
            EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)module.getContainer());
        }
    }
}

