/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gear.config;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.gear.config.ModuleConfigData;
import mekanism.api.math.MathUtils;
import net.minecraft.nbt.CompoundTag;

@ParametersAreNonnullByDefault
public final class ModuleEnumData<TYPE extends Enum<TYPE>>
implements ModuleConfigData<TYPE> {
    private final List<TYPE> enumConstants;
    private TYPE value;

    public ModuleEnumData(Class<TYPE> enumClass, TYPE def) {
        Enum[] constants = (Enum[])Objects.requireNonNull(enumClass, "Enum Class cannot be null.").getEnumConstants();
        this.enumConstants = List.of(constants);
        this.value = (Enum)Objects.requireNonNull(def, "Default value cannot be null.");
    }

    public ModuleEnumData(Class<TYPE> enumClass, int selectableCount, TYPE def) {
        Object[] constants = (Enum[])Objects.requireNonNull(enumClass, "Enum Class cannot be null.").getEnumConstants();
        if (selectableCount <= 0) {
            throw new IllegalArgumentException("Invalid selectableCount, there must be at least one element that is selectable.");
        }
        Objects.requireNonNull(def, "Default value cannot be null.");
        if (constants.length < selectableCount) {
            throw new IllegalArgumentException("Selectable count is larger than the number of elements in " + enumClass.getSimpleName());
        }
        if (constants.length == selectableCount) {
            this.enumConstants = ImmutableList.builder().add(constants).build();
            this.value = def;
        } else {
            if (((Enum)def).ordinal() >= selectableCount) {
                throw new IllegalArgumentException("Invalid default, it is out of range of the selectable values.");
            }
            this.enumConstants = ImmutableList.builder().addAll(List.of(constants).subList(0, selectableCount)).build();
            this.value = def;
        }
    }

    @Nonnull
    public List<TYPE> getEnums() {
        return this.enumConstants;
    }

    @Override
    @Nonnull
    public TYPE get() {
        return this.value;
    }

    @Override
    public void set(TYPE val) {
        Objects.requireNonNull(val, "Value cannot be null.");
        if (((Enum)val).ordinal() >= this.enumConstants.size()) {
            throw new IllegalArgumentException("Invalid value, it is out of range of the selectable values.");
        }
        this.value = val;
    }

    @Override
    public void read(String name, CompoundTag tag) {
        Objects.requireNonNull(tag, "Tag cannot be null.");
        Objects.requireNonNull(name, "Name cannot be null.");
        this.value = (Enum)MathUtils.getByIndexMod(this.enumConstants, tag.m_128451_(name));
    }

    @Override
    public void write(String name, CompoundTag tag) {
        Objects.requireNonNull(tag, "Tag cannot be null.");
        Objects.requireNonNull(name, "Name cannot be null.");
        tag.m_128405_(name, ((Enum)this.value).ordinal());
    }
}

