/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.IDisableableEnum;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.item.interfaces.IRadialSelectorEnum;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class GuiRadialSelector<TYPE extends Enum<TYPE>>
extends Screen {
    private static final float DRAWS = 300.0f;
    private static final float INNER = 40.0f;
    private static final float OUTER = 100.0f;
    private static final float SELECT_RADIUS = 10.0f;
    private final Class<TYPE> enumClass;
    private final TYPE[] types;
    private final Supplier<TYPE> curSupplier;
    private final Consumer<TYPE> changeHandler;
    private final boolean isDisableable;
    private TYPE selection = null;

    public GuiRadialSelector(Class<TYPE> enumClass, Supplier<TYPE> curSupplier, Consumer<TYPE> changeHandler) {
        super((Component)MekanismLang.RADIAL_SCREEN.translate(new Object[0]));
        this.enumClass = enumClass;
        this.curSupplier = curSupplier;
        this.changeHandler = changeHandler;
        this.isDisableable = IDisableableEnum.class.isAssignableFrom(enumClass);
        this.types = (Enum[])enumClass.getEnumConstants();
    }

    public void m_6305_(@Nonnull PoseStack matrix, int mouseX, int mouseY, float partialTick) {
        float centerX = (float)Minecraft.m_91087_().m_91268_().m_85445_() / 2.0f;
        float centerY = (float)Minecraft.m_91087_().m_91268_().m_85446_() / 2.0f;
        matrix.m_85836_();
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        matrix.m_85837_((double)centerX, (double)centerY, 0.0);
        RenderSystem.m_69472_();
        int activeModes = this.isDisableable ? (int)Arrays.stream(this.types).filter(type -> ((IDisableableEnum)((Object)type)).isEnabled()).count() : this.types.length;
        RenderSystem.m_157429_((float)0.3f, (float)0.3f, (float)0.3f, (float)0.5f);
        this.drawTorus(matrix, 0.0f, 360.0f);
        Enum cur = (Enum)this.curSupplier.get();
        if (cur != null) {
            int section;
            if (((IRadialSelectorEnum)((Object)cur)).getColor() == null) {
                RenderSystem.m_157429_((float)0.4f, (float)0.4f, (float)0.4f, (float)0.7f);
            } else {
                MekanismRenderer.color(((IRadialSelectorEnum)((Object)cur)).getColor(), 0.3f);
            }
            if (this.isDisableable) {
                section = 0;
                for (TYPE type2 : this.types) {
                    if (!((IDisableableEnum)type2).isEnabled()) continue;
                    if (type2 != cur) {
                        ++section;
                        continue;
                    }
                    break;
                }
            } else {
                section = cur.ordinal();
            }
            this.drawTorus(matrix, -90.0f + 360.0f * (-0.5f + (float)section) / (float)activeModes, 360.0f / (float)activeModes);
            double xDiff = (float)mouseX - centerX;
            double yDiff = (float)mouseY - centerY;
            if (Math.sqrt(xDiff * xDiff + yDiff * yDiff) >= 10.0) {
                float selectionAngle;
                float angle = (float)Math.toDegrees(Math.atan2(yDiff, xDiff));
                RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)0.3f);
                this.drawTorus(matrix, 360.0f * (-0.5f / (float)activeModes) + angle, 360.0f / (float)activeModes);
                for (selectionAngle = angle + 90.0f + 360.0f * (0.5f / (float)activeModes); selectionAngle < 0.0f; selectionAngle += 360.0f) {
                }
                int selectionDrawnPos = (int)(selectionAngle * ((float)activeModes / 360.0f));
                if (this.isDisableable) {
                    int count = 0;
                    for (TYPE type3 : this.types) {
                        if (!((IDisableableEnum)type3).isEnabled()) continue;
                        if (count == selectionDrawnPos) {
                            this.selection = type3;
                            break;
                        }
                        ++count;
                    }
                } else {
                    this.selection = this.types[selectionDrawnPos];
                }
                RenderSystem.m_157429_((float)0.6f, (float)0.6f, (float)0.6f, (float)0.7f);
                this.drawTorus(matrix, -90.0f + 360.0f * (-0.5f + (float)selectionDrawnPos) / (float)activeModes, 360.0f / (float)activeModes);
            } else {
                this.selection = null;
            }
        }
        MekanismRenderer.resetColor();
        RenderSystem.m_69493_();
        int position = 0;
        for (TYPE type2 : this.types) {
            if (this.isDisableable && !((IDisableableEnum)type2).isEnabled()) continue;
            double angle = Math.toRadians(270.0f + 360.0f * ((float)position / (float)activeModes));
            float x = (float)Math.cos(angle) * 140.0f / 2.0f;
            float y = (float)Math.sin(angle) * 140.0f / 2.0f;
            RenderSystem.m_157456_((int)0, (ResourceLocation)((IRadialSelectorEnum)type2).getIcon());
            GuiRadialSelector.m_93160_((PoseStack)matrix, (int)Math.round(x - 12.0f), (int)Math.round(y - 20.0f), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)18, (int)18, (int)18, (int)18);
            matrix.m_85836_();
            int width = this.f_96547_.m_92852_((FormattedText)((IRadialSelectorEnum)type2).getShortText());
            matrix.m_85837_((double)x, (double)y, 0.0);
            matrix.m_85841_(0.6f, 0.6f, 0.6f);
            this.f_96547_.m_92889_(matrix, ((IRadialSelectorEnum)type2).getShortText(), (float)(-width) / 2.0f, 8.0f, -855638017);
            matrix.m_85849_();
            ++position;
        }
        MekanismRenderer.resetColor();
        matrix.m_85849_();
    }

    public void m_7861_() {
        this.updateSelection();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return true;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.updateSelection();
        return true;
    }

    public boolean m_7043_() {
        return false;
    }

    private void drawTorus(PoseStack matrix, float startAngle, float sizeAngle) {
        RenderSystem.m_157427_(GameRenderer::m_172808_);
        BufferBuilder vertexBuffer = Tesselator.m_85913_().m_85915_();
        Matrix4f matrix4f = matrix.m_85850_().m_85861_();
        vertexBuffer.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85814_);
        float draws = 300.0f * (sizeAngle / 360.0f);
        int i = 0;
        while ((float)i <= draws) {
            float angle = (float)Math.toRadians(startAngle + (float)i / 300.0f * 360.0f);
            vertexBuffer.m_85982_(matrix4f, (float)(100.0 * Math.cos(angle)), (float)(100.0 * Math.sin(angle)), 0.0f).m_5752_();
            vertexBuffer.m_85982_(matrix4f, (float)(40.0 * Math.cos(angle)), (float)(40.0 * Math.sin(angle)), 0.0f).m_5752_();
            ++i;
        }
        vertexBuffer.m_85721_();
        BufferUploader.m_85761_((BufferBuilder)vertexBuffer);
    }

    public void updateSelection() {
        if (this.selection != null) {
            this.changeHandler.accept(this.selection);
        }
    }

    public Class<TYPE> getEnumClass() {
        return this.enumClass;
    }
}

