/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.recipes.MetallurgicInfuserRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiEmptyBar;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.world.item.ItemStack;

public class MetallurgicInfuserRecipeCategory
extends BaseRecipeCategory<MetallurgicInfuserRecipe> {
    private final GuiSlot input;
    private final GuiSlot extra = this.addSlot(SlotType.EXTRA, 17, 35);
    private final GuiSlot output;
    private final GuiBar<?> infusionBar;

    public MetallurgicInfuserRecipeCategory(IGuiHelper helper, MekanismJEIRecipeType<MetallurgicInfuserRecipe> recipeType) {
        super(helper, recipeType, MekanismBlocks.METALLURGIC_INFUSER, 5, 16, 166, 54);
        this.input = this.addSlot(SlotType.INPUT, 51, 43);
        this.output = this.addSlot(SlotType.OUTPUT, 109, 43);
        this.addSlot(SlotType.POWER, 143, 35).with(SlotOverlay.POWER);
        this.addElement(new GuiVerticalPowerBar((IGuiWrapper)this, FULL_BAR, 164, 15));
        this.addSimpleProgress(ProgressType.RIGHT, 72, 47);
        this.infusionBar = this.addElement(new GuiEmptyBar(this, 7, 15, 4, 52));
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, MetallurgicInfuserRecipe recipe, @Nonnull IFocusGroup focusGroup) {
        this.initItem(builder, RecipeIngredientRole.INPUT, this.input, recipe.getItemInput().getRepresentations());
        List<@NonNull TYPE> infusionStacks = ((ChemicalStackIngredient.InfusionStackIngredient)recipe.getChemicalInput()).getRepresentations();
        this.initChemical(builder, MekanismJEI.TYPE_INFUSION, RecipeIngredientRole.INPUT, this.infusionBar, infusionStacks);
        this.initItem(builder, RecipeIngredientRole.OUTPUT, this.output, recipe.getOutputDefinition());
        ArrayList<ItemStack> infuseItemProviders = new ArrayList<ItemStack>();
        for (InfusionStack infusionStack : infusionStacks) {
            infuseItemProviders.addAll(MekanismJEI.INFUSION_STACK_HELPER.getStacksFor((InfuseType)infusionStack.getType(), true));
        }
        this.initItem(builder, RecipeIngredientRole.CATALYST, this.extra, infuseItemProviders);
    }
}

