/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.stream.Stream;

public class ModelToVoxelShapeUtil {
    public static void main(String[] args) {
        ModelToVoxelShapeUtil.printoutModelFile("/Users/aidancbrady/Documents/Mekanism/src/main/resources/assets/mekanism/models/block/digital_miner.json");
    }

    private static void printoutModelFile(String path) {
        StringBuilder builder = new StringBuilder();
        try (Stream<String> stream = Files.lines(Paths.get(path, new String[0]), StandardCharsets.UTF_8);){
            stream.forEach(s -> builder.append((String)s).append('\n'));
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return;
        }
        JsonObject obj = JsonParser.parseString((String)builder.toString()).getAsJsonObject();
        if (obj.has("elements")) {
            ModelToVoxelShapeUtil.printoutObject(obj);
        } else if (obj.has("layers")) {
            obj.getAsJsonObject("layers").entrySet().forEach(e -> ModelToVoxelShapeUtil.printoutObject(((JsonElement)e.getValue()).getAsJsonObject()));
        } else {
            System.err.println("Unable to parse model file.");
        }
    }

    private static void printoutObject(JsonObject obj) {
        DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.US);
        DecimalFormat df = new DecimalFormat("#.####", otherSymbols);
        JsonArray array = obj.getAsJsonArray("elements");
        int elements = array.size();
        for (int i = 0; i < elements; ++i) {
            JsonObject element = array.get(i).getAsJsonObject();
            JsonElement nameObj = element.get("name");
            String name = nameObj == null ? "" : " // " + nameObj.getAsString();
            String from = ModelToVoxelShapeUtil.convertCorner(df, element.getAsJsonArray("from"));
            String to = ModelToVoxelShapeUtil.convertCorner(df, element.getAsJsonArray("to"));
            System.out.println("box(" + from + ", " + to + ")" + (i < elements - 1 ? "," : "") + name);
        }
    }

    private static String convertCorner(DecimalFormat df, JsonArray corner) {
        return df.format(corner.get(0).getAsDouble()) + ", " + df.format(corner.get(1).getAsDouble()) + ", " + df.format(corner.get(2).getAsDouble());
    }
}

