/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.states;

import java.util.Optional;
import javax.annotation.Nonnull;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.IFluidLogType;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public interface IStateFluidLoggable
extends BucketPickup,
LiquidBlockContainer {
    default public boolean isValidFluid(@Nonnull Fluid fluid) {
        return this.getFluidLoggedProperty().m_6908_().stream().anyMatch(possibleValue -> ((IFluidLogType)((Object)possibleValue)).getFluid() == fluid);
    }

    @Nonnull
    default public EnumProperty<? extends IFluidLogType> getFluidLoggedProperty() {
        return BlockStateHelper.FLUID_LOGGED;
    }

    @Nonnull
    default public FluidState getFluid(@Nonnull BlockState state) {
        IFluidLogType fluidLogged = (IFluidLogType)((Object)state.m_61143_(this.getFluidLoggedProperty()));
        if (!fluidLogged.isEmpty()) {
            Fluid fluid = fluidLogged.getFluid();
            if (fluid instanceof FlowingFluid) {
                return ((FlowingFluid)fluid).m_76068_(false);
            }
            return fluid.m_76145_();
        }
        return Fluids.f_76191_.m_76145_();
    }

    default public void updateFluids(@Nonnull BlockState state, @Nonnull LevelAccessor world, @Nonnull BlockPos currentPos) {
        IFluidLogType fluidLogged = (IFluidLogType)((Object)state.m_61143_(this.getFluidLoggedProperty()));
        if (!fluidLogged.isEmpty()) {
            Fluid fluid = fluidLogged.getFluid();
            world.m_186469_(currentPos, fluid, fluid.m_6718_((LevelReader)world));
        }
    }

    default public boolean m_6044_(@Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Fluid fluid) {
        return ((IFluidLogType)((Object)((Enum)((Object)state.m_61143_(this.getFluidLoggedProperty()))))).isEmpty() && this.isValidFluid(fluid);
    }

    default public BlockState setState(BlockState state, Fluid fluid) {
        return IStateFluidLoggable.setState(state, fluid, this.getFluidLoggedProperty());
    }

    private static <T extends Enum<T> & IFluidLogType> BlockState setState(BlockState state, Fluid fluid, EnumProperty<T> property) {
        for (Enum possibleValue : property.m_6908_()) {
            if (((IFluidLogType)((Object)possibleValue)).getFluid() != fluid) continue;
            return (BlockState)state.m_61124_(property, (Comparable)((Object)possibleValue));
        }
        return state;
    }

    default public boolean m_7361_(@Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull FluidState fluidState) {
        Fluid fluid = fluidState.m_76152_();
        if (this.m_6044_((BlockGetter)world, pos, state, fluid)) {
            if (!world.m_5776_()) {
                world.m_7731_(pos, this.setState(state, fluid), 3);
                world.m_186469_(pos, fluid, fluid.m_6718_((LevelReader)world));
            }
            return true;
        }
        return false;
    }

    @Nonnull
    default public ItemStack m_142598_(@Nonnull LevelAccessor world, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        Fluid fluid;
        ItemStack bucket;
        IFluidLogType fluidLogged = (IFluidLogType)((Object)state.m_61143_(this.getFluidLoggedProperty()));
        if (!fluidLogged.isEmpty() && !(bucket = (fluid = fluidLogged.getFluid()).getAttributes().getBucket(new FluidStack(fluid, 1000))).m_41619_()) {
            world.m_7731_(pos, this.setState(state, Fluids.f_76191_), 3);
            return bucket;
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    default public Optional<SoundEvent> m_142298_() {
        return Optional.empty();
    }

    @Nonnull
    default public Optional<SoundEvent> getPickupSound(BlockState state) {
        return this.getFluid(state).m_76152_().m_142520_();
    }
}

