/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.miner;

import javax.annotation.Nonnull;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.tags.MekanismTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class MinerItemStackFilter
extends MinerFilter<MinerItemStackFilter>
implements IItemStackFilter<MinerItemStackFilter> {
    private ItemStack itemType = ItemStack.f_41583_;

    public MinerItemStackFilter(ItemStack item) {
        this.itemType = item;
    }

    public MinerItemStackFilter() {
    }

    public MinerItemStackFilter(MinerItemStackFilter filter) {
        super(filter);
        this.itemType = filter.itemType.m_41777_();
    }

    @Override
    public boolean canFilter(BlockState state) {
        ItemStack itemStack = new ItemStack((ItemLike)state.m_60734_());
        if (itemStack.m_41619_()) {
            return false;
        }
        return this.itemType.m_41656_(itemStack);
    }

    @Override
    public boolean hasBlacklistedElement() {
        BlockItem blockItem;
        Item item;
        return !this.itemType.m_41619_() && (item = this.itemType.m_41720_()) instanceof BlockItem && MekanismTags.Blocks.MINER_BLACKLIST_LOOKUP.contains((blockItem = (BlockItem)item).m_40614_());
    }

    @Override
    public CompoundTag write(CompoundTag nbtTags) {
        super.write(nbtTags);
        this.itemType.m_41739_(nbtTags);
        return nbtTags;
    }

    @Override
    public void read(CompoundTag nbtTags) {
        super.read(nbtTags);
        this.itemType = ItemStack.m_41712_((CompoundTag)nbtTags);
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        super.write(buffer);
        buffer.m_130055_(this.itemType);
    }

    @Override
    public void read(FriendlyByteBuf dataStream) {
        super.read(dataStream);
        this.itemType = dataStream.m_130267_();
    }

    @Override
    public int hashCode() {
        int code = super.hashCode();
        code = 31 * code + this.itemType.hashCode();
        return code;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) return false;
        if (!(o instanceof MinerItemStackFilter)) return false;
        MinerItemStackFilter filter = (MinerItemStackFilter)o;
        if (!filter.itemType.m_41656_(this.itemType)) return false;
        return true;
    }

    @Override
    public MinerItemStackFilter clone() {
        return new MinerItemStackFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.MINER_ITEMSTACK_FILTER;
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@Nonnull ItemStack stack) {
        this.itemType = stack;
    }
}

