/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.annotation.ElementType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.common.Mekanism;
import mekanism.common.integration.computer.BoundComputerMethod;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.SyntheticComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.lib.MekAnnotationScanner;
import mekanism.common.tile.interfaces.IComparatorSupport;
import mekanism.common.tile.interfaces.ITileDirectional;
import mekanism.common.tile.interfaces.ITileRedstone;
import mekanism.common.tile.prefab.TileEntityMultiblock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.forgespi.locating.IModFile;
import org.objectweb.asm.Type;

public class ComputerMethodMapper
extends MekAnnotationScanner.BaseAnnotationScanner {
    public static final ComputerMethodMapper INSTANCE = new ComputerMethodMapper();
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();
    private final Map<Class<?>, Map<String, List<MethodHandleInfo>>> namedMethodHandleCache = new Object2ObjectOpenHashMap();

    private ComputerMethodMapper() {
    }

    @Override
    protected boolean isEnabled() {
        return Mekanism.hooks.computerCompatEnabled();
    }

    @Override
    protected Map<ElementType, Type[]> getSupportedTypes() {
        EnumMap<ElementType, Type[]> supportedTypes = new EnumMap<ElementType, Type[]>(ElementType.class);
        Type wrappingType = Type.getType(WrappingComputerMethod.class);
        supportedTypes.put(ElementType.FIELD, new Type[]{Type.getType(SyntheticComputerMethod.class), wrappingType});
        supportedTypes.put(ElementType.METHOD, new Type[]{Type.getType(ComputerMethod.class), wrappingType});
        return supportedTypes;
    }

    private static JsonObject collectParamNames(Set<IModFileInfo> modFileData) {
        ArrayList<JsonObject> rootNodes = new ArrayList<JsonObject>();
        for (IModFileInfo info : modFileData) {
            IModFile modFile = info.getFile();
            for (IModInfo mod : info.getMods()) {
                Path resource = modFile.findResource(new String[]{"data", mod.getModId(), "parameter_names", "computer.json"});
                if (!Files.exists(resource, new LinkOption[0])) continue;
                try {
                    BufferedReader reader = Files.newBufferedReader(resource);
                    try {
                        rootNodes.add(GsonHelper.m_13859_((Reader)reader));
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (IOException e) {
                    Mekanism.logger.warn("Failed to read computer parameter name file for mod '{} ({})', some methods may be missing clean names.", (Object)mod.getDisplayName(), (Object)mod.getModId());
                }
            }
        }
        if (rootNodes.isEmpty()) {
            return new JsonObject();
        }
        JsonObject root = (JsonObject)rootNodes.get(0);
        int nodes = rootNodes.size();
        for (int i = 1; i < nodes; ++i) {
            for (Map.Entry entry : ((JsonObject)rootNodes.get(i)).entrySet()) {
                root.add((String)entry.getKey(), (JsonElement)entry.getValue());
            }
        }
        return root;
    }

    @Override
    protected void collectScanData(Map<String, Class<?>> classNameCache, Map<Class<?>, List<ModFileScanData.AnnotationData>> knownClasses, Set<IModFileInfo> modFileData) {
        JsonObject allParamNames = ComputerMethodMapper.collectParamNames(modFileData);
        Type wrappingType = Type.getType(WrappingComputerMethod.class);
        Object2ObjectOpenHashMap cachedWrappers = new Object2ObjectOpenHashMap();
        Object2ObjectOpenHashMap rawMethodDetails = new Object2ObjectOpenHashMap();
        for (Map.Entry<Class<?>, List<ModFileScanData.AnnotationData>> entry : knownClasses.entrySet()) {
            Class<?> annotatedClass = entry.getKey();
            JsonObject classParamNames = allParamNames.getAsJsonObject(annotatedClass.getName());
            ArrayList<MethodDetails> methodDetails = new ArrayList<MethodDetails>();
            rawMethodDetails.put(annotatedClass, methodDetails);
            for (ModFileScanData.AnnotationData data : entry.getValue()) {
                MethodHandle methodHandle;
                if (ComputerMethodMapper.getAnnotationValue(data, "requiredMods", Collections.emptyList()).stream().anyMatch(s -> !ModList.get().isLoaded(s))) continue;
                if (data.targetType() == ElementType.FIELD) {
                    String fieldName = data.memberName();
                    Field field = ComputerMethodMapper.getField(annotatedClass, fieldName);
                    if (field == null) continue;
                    if (data.annotationType().equals((Object)wrappingType)) {
                        try {
                            MethodHandle methodHandle2 = LOOKUP.unreflectGetter(field);
                            ComputerMethodMapper.wrapMethodHandle(classNameCache, methodHandle2, data, methodDetails, cachedWrappers, annotatedClass, classParamNames, methodHandle2.type().descriptorString(), fieldName);
                        }
                        catch (IllegalAccessException e) {
                            Mekanism.logger.error("Failed to create getter for field '{}' in class '{}'.", (Object)fieldName, (Object)annotatedClass.getSimpleName());
                        }
                        continue;
                    }
                    String getterName = ComputerMethodMapper.getAnnotationValue(data, "getter", "");
                    String setterName = ComputerMethodMapper.getAnnotationValue(data, "setter", "");
                    if (getterName.isEmpty() && setterName.isEmpty()) {
                        Mekanism.logger.error("Field: '{}' in class '{}' is annotated to generate a computer method but does not specify a getter or setter.", (Object)fieldName, (Object)annotatedClass.getSimpleName());
                        continue;
                    }
                    MethodRestriction restriction = ComputerMethodMapper.getAnnotationValue(data, "restriction", MethodRestriction.NONE);
                    ComputerMethodMapper.createSyntheticMethod(methodDetails, annotatedClass, field, fieldName, getterName, true, restriction, ComputerMethodMapper.getAnnotationValue(data, "threadSafeGetter", false));
                    ComputerMethodMapper.createSyntheticMethod(methodDetails, annotatedClass, field, fieldName, setterName, false, restriction, ComputerMethodMapper.getAnnotationValue(data, "threadSafeSetter", false));
                    continue;
                }
                String methodSignature = data.memberName();
                int descriptorStart = methodSignature.indexOf(40);
                if (descriptorStart == -1) {
                    Mekanism.logger.error("Method '{}' in class '{}' does not have a method descriptor.", (Object)methodSignature, (Object)annotatedClass.getSimpleName());
                    continue;
                }
                String methodDescriptor = methodSignature.substring(descriptorStart);
                String methodName2 = methodSignature.substring(0, descriptorStart);
                Method method = ComputerMethodMapper.getMethod(annotatedClass, methodName2, methodDescriptor);
                if (method == null) continue;
                try {
                    methodHandle = LOOKUP.unreflect(method);
                }
                catch (IllegalAccessException e) {
                    Mekanism.logger.error("Failed to retrieve method handle for method '{}' in class '{}'.", (Object)methodName2, (Object)annotatedClass.getSimpleName());
                    continue;
                }
                if (data.annotationType().equals((Object)wrappingType)) {
                    ComputerMethodMapper.wrapMethodHandle(classNameCache, methodHandle, data, methodDetails, cachedWrappers, annotatedClass, classParamNames, methodDescriptor, methodName2);
                    continue;
                }
                String methodNameOverride = ComputerMethodMapper.getAnnotationValue(data, "nameOverride", methodName2, name -> {
                    if (name.isEmpty()) {
                        Mekanism.logger.warn("Specified name override for method '{}' in class '{}' is explicitly set to empty and will not be used.", (Object)methodName2, (Object)annotatedClass.getSimpleName());
                    } else {
                        if (ComputerMethodMapper.validMethodName(name)) {
                            return true;
                        }
                        Mekanism.logger.error("Specified name override '{}' for method '{}' in class '{}' is not a valid method name and will not be used.", name, (Object)methodName2, (Object)annotatedClass.getSimpleName());
                    }
                    return false;
                });
                methodDetails.add(new MethodDetails(methodNameOverride, methodHandle, MekanismUtils.getParameterNames(classParamNames, methodName2, methodDescriptor), ComputerMethodMapper.getAnnotationValue(data, "restriction", MethodRestriction.NONE), ComputerMethodMapper.getAnnotationValue(data, "threadSafe", false)));
            }
        }
        List methodDetails = ComputerMethodMapper.combineWithParents(rawMethodDetails);
        for (MekAnnotationScanner.BaseAnnotationScanner.ClassBasedInfo details : methodDetails) {
            LinkedHashMap<String, List> cache = new LinkedHashMap<String, List>();
            details.infoList().sort(Comparator.comparing(info -> info.methodName));
            for (MethodDetails handle : details.infoList()) {
                cache.computeIfAbsent(handle.methodName, methodName -> new ArrayList(1)).add(new MethodHandleInfo(handle.method, handle.paramNames, handle.restriction, handle.threadSafe));
            }
            this.namedMethodHandleCache.put(details.clazz(), cache);
        }
    }

    private static void createSyntheticMethod(List<MethodDetails> methodDetails, Class<?> annotatedClass, Field field, String fieldName, String methodName, boolean isGetter, MethodRestriction restriction, boolean threadSafe) {
        if (!methodName.isEmpty()) {
            if (ComputerMethodMapper.validMethodName(methodName)) {
                try {
                    List<String> paramNames;
                    MethodHandle methodHandle;
                    if (isGetter) {
                        methodHandle = LOOKUP.unreflectGetter(field);
                        paramNames = Collections.emptyList();
                    } else {
                        methodHandle = LOOKUP.unreflectSetter(field);
                        paramNames = Collections.singletonList(fieldName);
                    }
                    methodDetails.add(new MethodDetails(methodName, methodHandle, paramNames, restriction, threadSafe));
                }
                catch (IllegalAccessException e) {
                    Mekanism.logger.error("Failed to create {} for field '{}' in class '{}'.", (Object)(isGetter ? "getter" : "setter"), (Object)fieldName, (Object)annotatedClass.getSimpleName());
                }
            } else {
                Mekanism.logger.error("Specified {} name '{}' for field '{}' in class '{}' is not a valid method name.", (Object)(isGetter ? "getter" : "setter"), (Object)methodName, (Object)fieldName, (Object)annotatedClass.getSimpleName());
            }
        }
    }

    private static void wrapMethodHandle(Map<String, Class<?>> classNameCache, MethodHandle methodHandle, ModFileScanData.AnnotationData data, List<MethodDetails> methodDetails, Map<Class<?>, List<WrappingMethodHelper>> cachedWrappers, Class<?> annotatedClass, @Nullable JsonObject classParamNames, String methodSignature, String identifier) {
        Class<?> wrapperClass = ComputerMethodMapper.getAnnotationValue(classNameCache, data, "wrapper");
        if (wrapperClass != null) {
            List methodNames = ComputerMethodMapper.getAnnotationValue(data, "methodNames", Collections.emptyList());
            int methodNameCount = methodNames.size();
            if (methodNameCount == 0) {
                Mekanism.logger.warn("No method names on wrapper for {} in class '{}', so the WrappingComputerMethod annotation should probably be removed.", (Object)identifier, (Object)annotatedClass.getSimpleName());
            } else {
                List wrapperHandles = cachedWrappers.computeIfAbsent(wrapperClass, clazz -> {
                    ArrayList<WrappingMethodHelper> helpers = new ArrayList<WrappingMethodHelper>();
                    try {
                        Method[] methods = clazz.getDeclaredMethods();
                        Arrays.sort(methods, (a, b) -> {
                            WrappingComputerMethod.WrappingComputerMethodIndex aIndex = a.getAnnotation(WrappingComputerMethod.WrappingComputerMethodIndex.class);
                            WrappingComputerMethod.WrappingComputerMethodIndex bIndex = b.getAnnotation(WrappingComputerMethod.WrappingComputerMethodIndex.class);
                            return Integer.compare(aIndex == null ? 0 : aIndex.value(), bIndex == null ? 0 : bIndex.value());
                        });
                        boolean hasFaultyOrder = false;
                        for (Method method : methods) {
                            WrappingComputerMethod.WrappingComputerMethodIndex index = method.getAnnotation(WrappingComputerMethod.WrappingComputerMethodIndex.class);
                            if (index == null) {
                                if (!helpers.isEmpty()) {
                                    hasFaultyOrder = true;
                                }
                            } else if (index.value() < helpers.size()) {
                                hasFaultyOrder = true;
                            }
                            helpers.add(new WrappingMethodHelper(PUBLIC_LOOKUP.unreflect(method)));
                        }
                        if (hasFaultyOrder) {
                            Mekanism.logger.error("Faulty method index annotations in class '{}'", (Object)clazz.getSimpleName());
                        }
                    }
                    catch (IllegalAccessException e) {
                        Mekanism.logger.error("Failed to retrieve method handle for methods in class '{}'.", (Object)clazz.getSimpleName());
                    }
                    return helpers;
                });
                if (wrapperHandles.size() != methodNameCount) {
                    Mekanism.logger.warn("Mismatch in count of method names ({}) for generated methods and methods to generate ({}).", (Object)methodNameCount, (Object)wrapperHandles.size());
                } else {
                    MethodRestriction restriction = ComputerMethodMapper.getAnnotationValue(data, "restriction", MethodRestriction.NONE);
                    boolean threadSafe = ComputerMethodMapper.getAnnotationValue(data, "threadSafe", false);
                    List<String> paramNames = MekanismUtils.getParameterNames(classParamNames, identifier, methodSignature);
                    for (int index = 0; index < methodNameCount; ++index) {
                        MethodHandle newHandle = MethodHandles.filterReturnValue(methodHandle, ((WrappingMethodHelper)wrapperHandles.get(index)).asType((Class<?>)methodHandle.type().returnType()));
                        methodDetails.add(new MethodDetails((String)methodNames.get(index), newHandle, paramNames, restriction, threadSafe));
                    }
                }
            }
        }
    }

    public void getAndBindToHandler(@Nonnull Object handler, Map<String, BoundComputerMethod> boundMethods) {
        this.getAndBindToHandler(handler.getClass(), handler, boundMethods);
    }

    public void getAndBindToHandler(Class<?> handlerClass, @Nullable Object handler, Map<String, BoundComputerMethod> boundMethods) {
        Map namedMethods = this.namedMethodHandleCache.computeIfAbsent(handlerClass, clazz -> ComputerMethodMapper.getData(this.namedMethodHandleCache, clazz, Collections.emptyMap()));
        boolean hasMethods = !boundMethods.isEmpty();
        for (Map.Entry entry : namedMethods.entrySet()) {
            BoundComputerMethod boundMethod;
            String methodName = (String)entry.getKey();
            List methods = (List)entry.getValue();
            BoundComputerMethod boundComputerMethod = boundMethod = hasMethods ? boundMethods.get(methodName) : null;
            if (boundMethod == null) {
                ArrayList<BoundComputerMethod.ThreadAwareMethodHandle> boundMethodHandles = new ArrayList<BoundComputerMethod.ThreadAwareMethodHandle>(methods.size());
                for (MethodHandleInfo method : methods) {
                    if (!method.restriction.test(handler)) continue;
                    boundMethodHandles.add(method.bindTo(handler));
                }
                if (boundMethodHandles.isEmpty()) continue;
                boundMethods.put(methodName, new BoundComputerMethod(methodName, boundMethodHandles));
                continue;
            }
            for (MethodHandleInfo method : methods) {
                if (!method.restriction.test(handler)) continue;
                boundMethod.addMethodImplementation(method.bindTo(handler));
            }
        }
    }

    private static boolean validMethodName(String name) {
        return name.matches("^([a-zA-Z_$][a-zA-Z\\d_$]*)$");
    }

    public static enum MethodRestriction implements Predicate<Object>
    {
        NONE(handler -> true),
        DIRECTIONAL(handler -> {
            ITileDirectional directional;
            return handler instanceof ITileDirectional && (directional = (ITileDirectional)handler).isDirectional();
        }),
        ENERGY(handler -> {
            IMekanismStrictEnergyHandler energyHandler;
            return handler instanceof IMekanismStrictEnergyHandler && (energyHandler = (IMekanismStrictEnergyHandler)handler).canHandleEnergy();
        }),
        MULTIBLOCK(handler -> {
            TileEntityMultiblock multiblock;
            return handler instanceof TileEntityMultiblock && (multiblock = (TileEntityMultiblock)handler).exposesMultiblockToComputer();
        }),
        REDSTONE_CONTROL(handler -> {
            ITileRedstone redstone;
            return handler instanceof ITileRedstone && (redstone = (ITileRedstone)handler).supportsRedstone();
        }),
        COMPARATOR(handler -> {
            IComparatorSupport comparatorSupport;
            return handler instanceof IComparatorSupport && (comparatorSupport = (IComparatorSupport)handler).supportsComparator();
        });

        private final Predicate<Object> validator;

        private MethodRestriction(Predicate<Object> validator) {
            this.validator = validator;
        }

        @Override
        public boolean test(@Nullable Object handler) {
            return this.validator.test(handler);
        }
    }

    private record MethodDetails(String methodName, MethodHandle method, List<String> paramNames, MethodRestriction restriction, boolean threadSafe) {
    }

    private record MethodHandleInfo(MethodHandle methodHandle, List<String> paramNames, MethodRestriction restriction, boolean threadSafe) {
        public BoundComputerMethod.ThreadAwareMethodHandle bindTo(@Nullable Object handler) {
            return new BoundComputerMethod.ThreadAwareMethodHandle(handler == null ? this.methodHandle : this.methodHandle.bindTo(handler), this.paramNames, this.threadSafe);
        }
    }

    private static class WrappingMethodHelper {
        private final Map<Class<?>, MethodHandle> mappedHandles = new Object2ObjectOpenHashMap();
        private final MethodHandle methodHandle;

        private WrappingMethodHelper(MethodHandle methodHandle) {
            this.methodHandle = methodHandle;
        }

        public MethodHandle asType(Class<?> type) {
            if (type == this.methodHandle.type().parameterType(0)) {
                return this.methodHandle;
            }
            return this.mappedHandles.computeIfAbsent(type, clazz -> MethodHandles.explicitCastArguments(this.methodHandle, this.methodHandle.type().changeParameterType(0, (Class<?>)clazz)));
        }
    }
}

