/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.math;

import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.lib.math.Quaternion;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Pos3D
extends Vec3 {
    public Pos3D() {
        this(0.0, 0.0, 0.0);
    }

    public Pos3D(Vec3 vec) {
        super(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public Pos3D(Coord4D coord) {
        super((double)coord.getX(), (double)coord.getY(), (double)coord.getZ());
    }

    public Pos3D(double x, double y, double z) {
        super(x, y, z);
    }

    public Pos3D(Entity entity) {
        this(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
    }

    public static Pos3D create(BlockEntity tile) {
        return Pos3D.create((Vec3i)tile.m_58899_());
    }

    public static Pos3D create(Vec3i vec) {
        return new Pos3D(Vec3.m_82528_((Vec3i)vec));
    }

    public static Pos3D read(CompoundTag tag) {
        return new Pos3D(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
    }

    public static Pos3D translateMatrix(double[] matrix, Pos3D translation) {
        double x = translation.f_82479_ * matrix[0] + translation.f_82480_ * matrix[1] + translation.f_82481_ * matrix[2] + matrix[3];
        double y = translation.f_82479_ * matrix[4] + translation.f_82480_ * matrix[5] + translation.f_82481_ * matrix[6] + matrix[7];
        double z = translation.f_82479_ * matrix[8] + translation.f_82480_ * matrix[9] + translation.f_82481_ * matrix[10] + matrix[11];
        return new Pos3D(x, y, z);
    }

    public static double[] getRotationMatrix(float angle, Pos3D axis) {
        return axis.getRotationMatrix(angle);
    }

    public static double anglePreNorm(Pos3D pos1, Pos3D pos2) {
        return Math.acos(pos1.m_82526_(pos2));
    }

    public static AABB getAABB(Vec3 pos1, Vec3 pos2) {
        return new AABB(pos1.f_82479_, pos1.f_82480_, pos1.f_82481_, pos2.f_82479_, pos2.f_82480_, pos2.f_82481_);
    }

    public CompoundTag write(CompoundTag nbtTags) {
        nbtTags.m_128347_("x", this.f_82479_);
        nbtTags.m_128347_("y", this.f_82480_);
        nbtTags.m_128347_("z", this.f_82481_);
        return nbtTags;
    }

    public Pos3D diff(Vec3 vec) {
        return new Pos3D(this.f_82479_ - vec.f_82479_, this.f_82480_ - vec.f_82480_, this.f_82481_ - vec.f_82481_);
    }

    public Coord4D getCoord(ResourceKey<Level> dimension) {
        return new Coord4D((int)this.f_82479_, (int)this.f_82480_, (int)this.f_82481_, dimension);
    }

    public Pos3D centre() {
        return this.translate(0.5, 0.5, 0.5);
    }

    public Pos3D translate(double x, double y, double z) {
        return new Pos3D(this.f_82479_ + x, this.f_82480_ + y, this.f_82481_ + z);
    }

    public Pos3D translate(Vec3 pos) {
        return this.translate(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public Pos3D translate(Vec3 ... positions) {
        double x = this.f_82479_;
        double y = this.f_82480_;
        double z = this.f_82481_;
        for (Vec3 position : positions) {
            x += position.f_82479_;
            y += position.f_82480_;
            z += position.f_82481_;
        }
        return new Pos3D(x, y, z);
    }

    public Pos3D translate(Direction direction, double amount) {
        return this.translate((double)direction.m_122436_().m_123341_() * amount, (double)direction.m_122436_().m_123342_() * amount, (double)direction.m_122436_().m_123343_() * amount);
    }

    public Pos3D translateExcludingSide(Direction direction, double amount) {
        double xPos = this.f_82479_;
        double yPos = this.f_82480_;
        double zPos = this.f_82481_;
        if (direction.m_122434_() != Direction.Axis.X) {
            xPos += amount;
        }
        if (direction.m_122434_() != Direction.Axis.Y) {
            yPos += amount;
        }
        if (direction.m_122434_() != Direction.Axis.Z) {
            zPos += amount;
        }
        return new Pos3D(xPos, yPos, zPos);
    }

    public Pos3D adjustPosition(Direction direction, Entity entity) {
        if (direction.m_122434_() == Direction.Axis.X) {
            return new Pos3D(entity.m_20185_(), this.f_82480_, this.f_82481_);
        }
        if (direction.m_122434_() == Direction.Axis.Y) {
            return new Pos3D(this.f_82479_, entity.m_20186_(), this.f_82481_);
        }
        return new Pos3D(this.f_82479_, this.f_82480_, entity.m_20189_());
    }

    public double distance(Vec3 pos) {
        double subX = this.f_82479_ - pos.f_82479_;
        double subY = this.f_82480_ - pos.f_82480_;
        double subZ = this.f_82481_ - pos.f_82481_;
        return Math.sqrt(subX * subX + subY * subY + subZ * subZ);
    }

    @Nonnull
    public Pos3D yRot(float yaw) {
        double yawRadians = Math.toRadians(yaw);
        double xPos = this.f_82479_;
        double zPos = this.f_82481_;
        if (yaw != 0.0f) {
            double cos = Math.cos(yawRadians);
            double sin = Math.sin(yawRadians);
            xPos = this.f_82479_ * cos - this.f_82481_ * sin;
            zPos = this.f_82481_ * cos + this.f_82479_ * sin;
        }
        return new Pos3D(xPos, this.f_82480_, zPos);
    }

    @Nonnull
    public Pos3D xRot(float pitch) {
        double pitchRadians = Math.toRadians(pitch);
        double yPos = this.f_82480_;
        double zPos = this.f_82481_;
        if (pitch != 0.0f) {
            double cos = Math.cos(pitchRadians);
            double sin = Math.sin(pitchRadians);
            yPos = this.f_82480_ * cos - this.f_82481_ * sin;
            zPos = this.f_82481_ * cos + this.f_82480_ * sin;
        }
        return new Pos3D(this.f_82479_, yPos, zPos);
    }

    public Pos3D rotate(float yaw, float pitch) {
        return this.rotate(yaw, pitch, 0.0f);
    }

    public Pos3D rotate(float yaw, float pitch, float roll) {
        double yawRadians = Math.toRadians(yaw);
        double pitchRadians = Math.toRadians(pitch);
        double rollRadians = Math.toRadians(roll);
        double xPos = this.f_82479_ * Math.cos(yawRadians) * Math.cos(pitchRadians) + this.f_82481_ * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) - Math.sin(yawRadians) * Math.cos(rollRadians)) + this.f_82480_ * (Math.cos(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) + Math.sin(yawRadians) * Math.sin(rollRadians));
        double zPos = this.f_82479_ * Math.sin(yawRadians) * Math.cos(pitchRadians) + this.f_82481_ * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.sin(rollRadians) + Math.cos(yawRadians) * Math.cos(rollRadians)) + this.f_82480_ * (Math.sin(yawRadians) * Math.sin(pitchRadians) * Math.cos(rollRadians) - Math.cos(yawRadians) * Math.sin(rollRadians));
        double yPos = -this.f_82479_ * Math.sin(pitchRadians) + this.f_82481_ * Math.cos(pitchRadians) * Math.sin(rollRadians) + this.f_82480_ * Math.cos(pitchRadians) * Math.cos(rollRadians);
        return new Pos3D(xPos, yPos, zPos);
    }

    @Nonnull
    public Pos3D multiply(Vec3 pos) {
        return this.multiply(pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    @Nonnull
    public Pos3D multiply(double x, double y, double z) {
        return new Pos3D(this.f_82479_ * x, this.f_82480_ * y, this.f_82481_ * z);
    }

    @Nonnull
    public Pos3D scale(double scale) {
        return this.multiply(scale, scale, scale);
    }

    public Pos3D rotate(float angle, Pos3D axis) {
        return Pos3D.translateMatrix(Pos3D.getRotationMatrix(angle, axis), this);
    }

    public Pos3D transform(Quaternion quaternion) {
        Quaternion q = quaternion.copy();
        q.multiply(new Quaternion(this.f_82479_, this.f_82480_, this.f_82481_, 0.0));
        q.multiply(quaternion.copy().conjugate());
        return new Pos3D(q.getX(), q.getY(), q.getZ());
    }

    public double[] getRotationMatrix(float angle) {
        double[] matrix = new double[16];
        Pos3D axis = this.normalize();
        double x = axis.f_82479_;
        double y = axis.f_82480_;
        double z = axis.f_82481_;
        double angleAsRadian = Math.toRadians(angle);
        float cos = (float)Math.cos(angleAsRadian);
        float ocos = 1.0f - cos;
        float sin = (float)Math.sin(angleAsRadian);
        matrix[0] = x * x * (double)ocos + (double)cos;
        matrix[1] = y * x * (double)ocos + z * (double)sin;
        matrix[2] = x * z * (double)ocos - y * (double)sin;
        matrix[4] = x * y * (double)ocos - z * (double)sin;
        matrix[5] = y * y * (double)ocos + (double)cos;
        matrix[6] = y * z * (double)ocos + x * (double)sin;
        matrix[8] = x * z * (double)ocos + y * (double)sin;
        matrix[9] = y * z * (double)ocos - x * (double)sin;
        matrix[10] = z * z * (double)ocos + (double)cos;
        matrix[15] = 1.0;
        return matrix;
    }

    public double anglePreNorm(Pos3D pos2) {
        return Math.acos(this.m_82526_(pos2));
    }

    @Nonnull
    public Pos3D normalize() {
        return new Pos3D(super.m_82541_());
    }

    public Pos3D xCrossProduct() {
        return new Pos3D(0.0, this.f_82481_, -this.f_82480_);
    }

    public Pos3D zCrossProduct() {
        return new Pos3D(-this.f_82480_, this.f_82479_, 0.0);
    }

    public Pos3D getPerpendicular() {
        return this.f_82481_ == 0.0 ? this.zCrossProduct() : this.xCrossProduct();
    }

    public Pos3D floor() {
        return new Pos3D(Math.floor(this.f_82479_), Math.floor(this.f_82480_), Math.floor(this.f_82481_));
    }

    public Pos3D clone() {
        return new Pos3D(this.f_82479_, this.f_82480_, this.f_82481_);
    }

    @Nonnull
    public String toString() {
        return "[Pos3D: " + this.f_82479_ + ", " + this.f_82480_ + ", " + this.f_82481_ + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof Vec3)) return false;
        Vec3 other = (Vec3)obj;
        if (other.f_82479_ != this.f_82479_) return false;
        if (other.f_82480_ != this.f_82480_) return false;
        if (other.f_82481_ != this.f_82481_) return false;
        return true;
    }

    public int hashCode() {
        int code = 1;
        code = 31 * code + Double.hashCode(this.f_82479_);
        code = 31 * code + Double.hashCode(this.f_82480_);
        code = 31 * code + Double.hashCode(this.f_82481_);
        return code;
    }
}

