/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import mekanism.common.Mekanism;
import mekanism.common.integration.curios.CuriosIntegration;
import mekanism.common.item.interfaces.IModeItem;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class PacketModeChangeCurios
implements IMekanismPacket {
    private final boolean displayChangeMessage;
    private final String slotType;
    private final int slot;
    private final int shift;

    public PacketModeChangeCurios(String slotType, int slot, boolean holdingShift) {
        this(slotType, slot, holdingShift ? -1 : 1, true);
    }

    public PacketModeChangeCurios(String slotType, int slot, int shift) {
        this(slotType, slot, shift, false);
    }

    private PacketModeChangeCurios(String slotType, int slot, int shift, boolean displayChangeMessage) {
        this.slot = slot;
        this.shift = shift;
        this.slotType = slotType;
        this.displayChangeMessage = displayChangeMessage;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        Item item;
        ItemStack stack;
        ServerPlayer player = context.getSender();
        if (player != null && Mekanism.hooks.CuriosLoaded && !(stack = CuriosIntegration.getCurioStack((LivingEntity)player, this.slotType, this.slot)).m_41619_() && (item = stack.m_41720_()) instanceof IModeItem) {
            IModeItem modeItem = (IModeItem)item;
            modeItem.changeMode((Player)player, stack, this.shift, this.displayChangeMessage);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.slotType);
        buffer.m_130130_(this.slot);
        buffer.m_130130_(this.shift);
        buffer.writeBoolean(this.displayChangeMessage);
    }

    public static PacketModeChangeCurios decode(FriendlyByteBuf buffer) {
        return new PacketModeChangeCurios(BasePacketHandler.readString(buffer), buffer.m_130242_(), buffer.m_130242_(), buffer.readBoolean());
    }
}

