/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import mekanism.api.SerializerHelper;
import mekanism.api.recipes.NucleosynthesizingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.ingredients.ItemStackIngredient;
import mekanism.api.recipes.ingredients.creator.IngredientCreatorAccess;
import mekanism.common.Mekanism;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class NucleosynthesizingRecipeSerializer<RECIPE extends NucleosynthesizingRecipe>
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<RECIPE> {
    private final IFactory<RECIPE> factory;

    public NucleosynthesizingRecipeSerializer(IFactory<RECIPE> factory) {
        this.factory = factory;
    }

    @Nonnull
    public RECIPE fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
        JsonArray itemInput = GsonHelper.m_13885_((JsonObject)json, (String)"itemInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"itemInput") : GsonHelper.m_13930_((JsonObject)json, (String)"itemInput");
        ItemStackIngredient itemIngredient = (ItemStackIngredient)IngredientCreatorAccess.item().deserialize((JsonElement)itemInput);
        JsonArray gasInput = GsonHelper.m_13885_((JsonObject)json, (String)"gasInput") ? GsonHelper.m_13933_((JsonObject)json, (String)"gasInput") : GsonHelper.m_13930_((JsonObject)json, (String)"gasInput");
        ChemicalStackIngredient.GasStackIngredient gasIngredient = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().deserialize((JsonElement)gasInput);
        JsonElement ticks = json.get("duration");
        if (!GsonHelper.m_13872_((JsonElement)ticks)) {
            throw new JsonSyntaxException("Expected duration to be a number greater than zero.");
        }
        int duration = ticks.getAsJsonPrimitive().getAsInt();
        if (duration <= 0) {
            throw new JsonSyntaxException("Expected duration to be a number greater than zero.");
        }
        ItemStack itemOutput = SerializerHelper.getItemStack(json, "output");
        if (itemOutput.m_41619_()) {
            throw new JsonSyntaxException("Nucleosynthesizing item output must not be empty.");
        }
        return this.factory.create(recipeId, itemIngredient, gasIngredient, itemOutput, duration);
    }

    public RECIPE fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
        try {
            ItemStackIngredient inputSolid = (ItemStackIngredient)IngredientCreatorAccess.item().read(buffer);
            ChemicalStackIngredient.GasStackIngredient inputGas = (ChemicalStackIngredient.GasStackIngredient)IngredientCreatorAccess.gas().read(buffer);
            ItemStack outputItem = buffer.m_130267_();
            int duration = buffer.m_130242_();
            return this.factory.create(recipeId, inputSolid, inputGas, outputItem, duration);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error reading nucleosynthesizing recipe from packet.", (Throwable)e);
            throw e;
        }
    }

    public void toNetwork(@Nonnull FriendlyByteBuf buffer, @Nonnull RECIPE recipe) {
        try {
            ((NucleosynthesizingRecipe)recipe).write(buffer);
        }
        catch (Exception e) {
            Mekanism.logger.error("Error writing nucleosynthesizing recipe to packet.", (Throwable)e);
            throw e;
        }
    }

    @FunctionalInterface
    public static interface IFactory<RECIPE extends NucleosynthesizingRecipe> {
        public RECIPE create(ResourceLocation var1, ItemStackIngredient var2, ChemicalStackIngredient.GasStackIngredient var3, ItemStack var4, int var5);
    }
}

