/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import mekanism.api.AutomationType;
import mekanism.api.IContentsListener;
import mekanism.api.MekanismAPI;
import mekanism.api.annotations.NonNull;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.security.SecurityMode;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.tile.base.TileEntityMekanism;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileEntityPersonalStorage
extends TileEntityMekanism {
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            TileEntityPersonalStorage.this.onOpen(level, pos, state);
        }

        protected void m_142289_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
            TileEntityPersonalStorage.this.onClose(level, pos, state);
        }

        protected void m_142148_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, int oldCount, int openCount) {
            level.m_7696_(pos, state.m_60734_(), 1, openCount);
        }

        protected boolean m_142718_(@Nonnull Player player) {
            MekanismTileContainer container;
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            return abstractContainerMenu instanceof MekanismTileContainer && (container = (MekanismTileContainer)abstractContainerMenu).getTileEntity() == TileEntityPersonalStorage.this;
        }
    };

    protected TileEntityPersonalStorage(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory(IContentsListener listener) {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        BiPredicate<@NonNull ItemStack, @NonNull AutomationType> canInteract = (stack, automationType) -> automationType == AutomationType.MANUAL || MekanismAPI.getSecurityUtils().getEffectiveSecurityMode(this, this.isRemote()) == SecurityMode.PUBLIC;
        for (int slotY = 0; slotY < 6; ++slotY) {
            for (int slotX = 0; slotX < 9; ++slotX) {
                builder.addSlot(BasicInventorySlot.at(canInteract, canInteract, listener, 8 + slotX * 18, 18 + slotY * 18));
            }
        }
        return builder.build();
    }

    @Override
    public void open(Player player) {
        super.open(player);
        if (!this.m_58901_() && !player.m_5833_() && this.f_58857_ != null) {
            this.openersCounter.m_155452_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    @Override
    public void close(Player player) {
        super.close(player);
        if (!this.m_58901_() && !player.m_5833_() && this.f_58857_ != null) {
            this.openersCounter.m_155468_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.m_58901_() && this.f_58857_ != null) {
            this.openersCounter.m_155476_(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    protected abstract void onOpen(@Nonnull Level var1, @Nonnull BlockPos var2, @Nonnull BlockState var3);

    protected abstract void onClose(@Nonnull Level var1, @Nonnull BlockPos var2, @Nonnull BlockState var3);

    protected abstract ResourceLocation getStat();

    @Override
    public InteractionResult openGui(Player player) {
        InteractionResult result = super.openGui(player);
        if (result.m_19077_() && !this.isRemote()) {
            player.m_36246_(Stats.f_12988_.m_12902_((Object)this.getStat()));
            PiglinAi.m_34873_((Player)player, (boolean)true);
        }
        return result;
    }
}

