/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.energy.IEnergyContainer;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.tier.BaseTier;
import mekanism.common.block.states.BlockStateHelper;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.capabilities.energy.DynamicStrictEnergyHandler;
import mekanism.common.capabilities.resolver.ICapabilityResolver;
import mekanism.common.capabilities.resolver.manager.EnergyHandlerManager;
import mekanism.common.content.network.EnergyNetwork;
import mekanism.common.content.network.transmitter.UniversalCable;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.energy.EnergyCompatUtils;
import mekanism.common.lib.transmitter.ConnectionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityUniversalCable
extends TileEntityTransmitter
implements IComputerTile {
    private final EnergyHandlerManager energyHandlerManager = new EnergyHandlerManager(direction -> {
        UniversalCable cable = this.getTransmitter();
        if (direction != null && cable.getConnectionTypeRaw(direction) == ConnectionType.NONE) {
            return Collections.emptyList();
        }
        return cable.getEnergyContainers(direction);
    }, new DynamicStrictEnergyHandler(this::getEnergyContainers, this.getExtractPredicate(), this.getInsertPredicate(), null));

    public TileEntityUniversalCable(IBlockProvider blockProvider, BlockPos pos, BlockState state) {
        super(blockProvider, pos, state);
        this.addCapabilityResolver(this.energyHandlerManager);
        ComputerCapabilityHelper.addComputerCapabilities(this, x$0 -> this.addCapabilityResolver((ICapabilityResolver)x$0));
    }

    protected UniversalCable createTransmitter(IBlockProvider blockProvider) {
        return new UniversalCable(blockProvider, this);
    }

    public UniversalCable getTransmitter() {
        return (UniversalCable)super.getTransmitter();
    }

    @Override
    protected void onUpdateServer() {
        this.getTransmitter().pullFromAcceptors();
        super.onUpdateServer();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.UNIVERSAL_CABLE;
    }

    @Override
    @Nonnull
    protected BlockState upgradeResult(@Nonnull BlockState current, @Nonnull BaseTier tier) {
        return switch (tier) {
            case BaseTier.BASIC -> BlockStateHelper.copyStateData(current, MekanismBlocks.BASIC_UNIVERSAL_CABLE);
            case BaseTier.ADVANCED -> BlockStateHelper.copyStateData(current, MekanismBlocks.ADVANCED_UNIVERSAL_CABLE);
            case BaseTier.ELITE -> BlockStateHelper.copyStateData(current, MekanismBlocks.ELITE_UNIVERSAL_CABLE);
            case BaseTier.ULTIMATE -> BlockStateHelper.copyStateData(current, MekanismBlocks.ULTIMATE_UNIVERSAL_CABLE);
            default -> current;
        };
    }

    @Override
    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag updateTag = super.m_5995_();
        if (this.getTransmitter().hasTransmitterNetwork()) {
            EnergyNetwork network = (EnergyNetwork)this.getTransmitter().getTransmitterNetwork();
            updateTag.m_128359_("energy", network.energyContainer.getEnergy().toString());
            updateTag.m_128350_("scale", network.currentScale);
        }
        return updateTag;
    }

    private List<IEnergyContainer> getEnergyContainers(@Nullable Direction side) {
        return this.energyHandlerManager.getContainers(side);
    }

    @Override
    public void sideChanged(@Nonnull Direction side, @Nonnull ConnectionType old, @Nonnull ConnectionType type) {
        super.sideChanged(side, old, type);
        if (type == ConnectionType.NONE) {
            this.invalidateCapabilities(EnergyCompatUtils.getEnabledEnergyCapabilities(), side);
            WorldUtils.notifyNeighborOfChange(this.f_58857_, side, this.f_58858_);
        } else if (old == ConnectionType.NONE) {
            WorldUtils.notifyNeighborOfChange(this.f_58857_, side, this.f_58858_);
        }
    }

    @Override
    public String getComputerName() {
        return this.getTransmitter().getTier().getBaseTier().getLowerName() + "UniversalCable";
    }

    @ComputerMethod
    private FloatingLong getBuffer() {
        return this.getTransmitter().getBufferWithFallback();
    }

    @ComputerMethod
    private FloatingLong getCapacity() {
        UniversalCable cable = this.getTransmitter();
        return cable.hasTransmitterNetwork() ? ((EnergyNetwork)cable.getTransmitterNetwork()).getCapacityAsFloatingLong() : cable.getCapacityAsFloatingLong();
    }

    @ComputerMethod
    private FloatingLong getNeeded() {
        return this.getCapacity().subtract(this.getBuffer());
    }

    @ComputerMethod
    private double getFilledPercentage() {
        return this.getBuffer().divideToLevel(this.getCapacity());
    }
}

