/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.events;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.references.Translation;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class UpdateNotificationEvent {
    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity().equals((Object)Minecraft.m_91087_().f_91074_)) {
            Optional container = ModList.get().getModContainerByObject((Object)InventoryHUD.getInstance());
            if (container.isEmpty()) {
                return;
            }
            VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)((ModContainer)container.get()).getModInfo());
            if (result.status().equals((Object)VersionChecker.Status.OUTDATED) && this.shouldNotify(result.target())) {
                TextComponent text = new TextComponent(ChatFormatting.GRAY + "[" + ChatFormatting.GREEN + "InventoryHUD+" + ChatFormatting.GRAY + "] " + ChatFormatting.WHITE + Translation.UPDATE.getString());
                TextComponent link = new TextComponent("[" + ChatFormatting.YELLOW + Translation.UPDATE_CLICK.getString() + ChatFormatting.WHITE + "]");
                ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, result.url());
                link.m_6270_(link.m_7383_().m_131142_(clickEvent));
                text.m_7220_((Component)link);
                ((LocalPlayer)event.getEntity()).m_5661_((Component)text, false);
                InventoryHUD.getClientConfig().lastNotifiedVersion.set((Object)result.target().toString());
                InventoryHUD.saveConfig();
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    private boolean shouldNotify(ComparableVersion version) {
        if (version == null) {
            return false;
        }
        ComparableVersion lastNotified = new ComparableVersion((String)InventoryHUD.getClientConfig().lastNotifiedVersion.get());
        return version.compareTo(lastNotified) > 0 || (Boolean)InventoryHUD.getClientConfig().keepNotifying.get() != false;
    }
}

