/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.config.ArmorConfigScreen;
import dlovin.inventoryhud.gui.config.CuriosConfigScreen;
import dlovin.inventoryhud.gui.config.InventoryConfigScreen;
import dlovin.inventoryhud.gui.config.PotionConfigScreen;
import dlovin.inventoryhud.gui.widgets.ConfigWidget;
import dlovin.inventoryhud.references.Translation;
import dlovin.inventoryhud.utils.Color4F;
import dlovin.inventoryhud.utils.CuriosSaveUtils;
import dlovin.inventoryhud.utils.CuriosSlot;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class InGameConfigScreen
extends Screen {
    private final ResourceLocation INV_BG = new ResourceLocation("inventoryhud", "textures/gui/inv_config_bg.png");
    private final ResourceLocation CONF_BG = new ResourceLocation("inventoryhud", "textures/gui/conf_bg.png");
    private ConfigWidget ICW;
    private ConfigWidget PCW;
    private ConfigWidget ACW;
    private List<ConfigWidget> listForRender;
    private Button backButton;
    private final int menu;
    private final boolean inGame;

    public InGameConfigScreen(int menu, boolean inGame) {
        super((Component)new TranslatableComponent("InventoryHUD Config Screen"));
        this.inGame = inGame;
        this.menu = menu;
    }

    protected void m_7856_() {
        int textPos;
        int ySize;
        int xSize;
        int pw;
        float potScale;
        this.listForRender = new ArrayList<ConfigWidget>();
        float invScale = (Boolean)InventoryHUD.getClientConfig().invMini.get() != false ? 0.75f : 1.0f;
        int invWidth = (Boolean)InventoryHUD.getClientConfig().invVert.get() != false ? 52 : 160;
        int invHeight = (Boolean)InventoryHUD.getClientConfig().invVert.get() != false ? 160 : 52;
        int x = this.getPosX((int)((float)invWidth * invScale), (Integer)InventoryHUD.getClientConfig().xPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().invHalign.get()));
        int y = this.getPosY((int)((float)invHeight * invScale), (Integer)InventoryHUD.getClientConfig().yPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().invValign.get()));
        this.backButton = new Button(this.f_96543_ - 60, 10, 50, 20, (Component)new TextComponent("Back"), btn -> this.m_7379_());
        this.ICW = new ConfigWidget(x, y, invWidth, invHeight, invScale, Translation.INVGUI, InventoryHUD.isActive);
        this.listForRender.add(this.ICW);
        if (!((Boolean)InventoryHUD.getClientConfig().invVert.get()).booleanValue()) {
            this.ICW.initTextureValues(0, 0, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        } else {
            this.ICW.initTextureValues(150, 54, new Color4F(0.5f, 1.0f, 0.5f, 1.0f), this.INV_BG);
        }
        this.ICW.addListener(w -> this.onInvChanged());
        this.ICW.addPosListener(w -> this.onInvPosChanged());
        float f = ((Boolean)InventoryHUD.getClientConfig().potMini.get()).booleanValue() ? (((Boolean)InventoryHUD.getClientConfig().potHor.get()).booleanValue() ? 1.0f : 0.75f) : (potScale = 1.0f);
        int n = ((Boolean)InventoryHUD.getClientConfig().potHor.get()).booleanValue() ? (((Boolean)InventoryHUD.getClientConfig().potMini.get()).booleanValue() ? 18 : 36) : (pw = 60);
        int ph = ((Boolean)InventoryHUD.getClientConfig().potHor.get()).booleanValue() ? (((Boolean)InventoryHUD.getClientConfig().potMini.get()).booleanValue() ? 22 : 38) : 24;
        x = this.getPosX((int)((float)pw * potScale), (Integer)InventoryHUD.getClientConfig().xPotionPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().potHalign.get()));
        y = this.getPosY((int)((float)ph * potScale), (Integer)InventoryHUD.getClientConfig().yPotionPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().potValign.get()));
        this.PCW = new ConfigWidget(x, y, pw, ph, potScale, Translation.POTGUI, InventoryHUD.potionHUD);
        this.listForRender.add(this.PCW);
        this.PCW.initTextureValues(0, 54, new Color4F(1.0f, 0.5f, 0.5f, 1.0f), this.INV_BG);
        this.PCW.addListener(w -> this.onPotionChanged());
        this.PCW.addPosListener(w -> this.onPotionPosChanged());
        float armScale = (float)((Integer)InventoryHUD.getClientConfig().armScale.get()).intValue() / 100.0f;
        if (((Boolean)InventoryHUD.getClientConfig().moveAll.get()).booleanValue()) {
            x = this.getPosX((int)(90.0f * armScale), (Integer)InventoryHUD.getClientConfig().xArmPos.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().armHalign.get()));
            y = this.getPosY((int)(70.0f * armScale), (Integer)InventoryHUD.getClientConfig().yArmPos.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().armValign.get()));
            this.ACW = new ConfigWidget(x, y, 90, 70, armScale, Translation.ARMGUI, InventoryHUD.armorHUD);
            this.listForRender.add(this.ACW);
            this.ACW.initTextureValues(60, 54, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG);
            this.ACW.addListener(w -> this.onArmorChanged());
            this.ACW.addPosListener(w -> this.onArmorPosChanged());
        } else {
            xSize = (int)(16.0f * armScale);
            ySize = (int)(16.0f * armScale);
            textPos = 80;
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().helmPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().helmHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().helmPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().helmVal.get()));
            ConfigWidget tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClientConfig().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_helmet.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 0));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().chestPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().chestHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().chestPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().chestVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClientConfig().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_chestplate.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 1));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().legPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().legHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().legPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().legVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClientConfig().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_leggings.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 2));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().bootPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().bootHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().bootPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().bootVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClientConfig().showArmor.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_boots.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 3));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().mainPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().mainHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().mainPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().mainVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClientConfig().showMain.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_main_hand_slot.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 5));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().offPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().offHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().offPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().offVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClientConfig().showOff.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_shield.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 4));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().arrPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().arrHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().arrPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().arrVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClientConfig().showArrows.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_arrows.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 7));
            x = this.getPosX(xSize, (Integer)InventoryHUD.getClientConfig().invPosX.get(), (WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().invHal.get()));
            y = this.getPosY(ySize, (Integer)InventoryHUD.getClientConfig().invPosY.get(), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().invVal.get()));
            tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), (Boolean)InventoryHUD.getClientConfig().showInv.get(), false);
            this.listForRender.add(tmp);
            tmp.initTextureValues(textPos, 124, new Color4F(0.5f, 0.5f, 1.0f, 1.0f), this.INV_BG, new ResourceLocation("inventoryhud", "textures/item/empty_inventory.png"));
            tmp.addPosListener(w -> this.onItemPosChanged(w, 6));
        }
        if (InventoryHUD.isCuriosMod && this.inGame && InventoryHUD.getInstance().getInventoryGui().hasCuriosSlots()) {
            xSize = (int)(16.0f * armScale);
            ySize = (int)(16.0f * armScale);
            textPos = 80;
            for (Map.Entry<String, CuriosSlot> entry : InventoryHUD.getInstance().getInventoryGui().getCuriosSlots().entrySet()) {
                if (!entry.getValue().enabled) continue;
                x = this.getPosX(xSize, entry.getValue().x, entry.getValue().aligns.HorAlign);
                y = this.getPosY(ySize, entry.getValue().y, entry.getValue().aligns.VertAlign);
                ConfigWidget tmp = new ConfigWidget(x, y, 16, 16, armScale, false, (Component)new TextComponent(""), true, false);
                this.listForRender.add(tmp);
                ResourceLocation res = entry.getValue().icon;
                tmp.initTextureValues(textPos, 124, new Color4F(1.0f, 0.5f, 0.0f, 1.0f), this.INV_BG, res);
                tmp.addPosListener(w -> this.onCuriosItemPosChanged(w, (CuriosSlot)entry.getValue()));
            }
        }
        this.m_142416_((GuiEventListener)this.backButton);
        this.listForRender.forEach(x$0 -> {
            ConfigWidget cfr_ignored_0 = (ConfigWidget)this.m_142416_((GuiEventListener)x$0);
        });
    }

    private int getPosX(int width, int posX, WidgetAligns.HAlign hal) {
        int result;
        switch (hal) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LEFT: {
                int n = posX;
                break;
            }
            case RIGHT: {
                int n = this.f_96543_ - posX;
                break;
            }
            case MIDDLE: {
                int n = result = this.f_96543_ / 2 - width / 2 - posX;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.f_96543_ - width) {
            result = this.f_96543_ - width;
        }
        return result;
    }

    private int getPosY(int height, int posY, WidgetAligns.VAlign hal) {
        int result;
        switch (hal) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TOP: {
                int n = posY;
                break;
            }
            case BOTTOM: {
                int n = this.f_96544_ - posY;
                break;
            }
            case CENTER: {
                int n = result = this.f_96544_ / 2 - height / 2 - posY;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > this.f_96544_ - height) {
            result = this.f_96544_ - height;
        }
        return result;
    }

    public void m_6305_(@NotNull PoseStack mat, int mouseX, int mouseY, float partialTick) {
        this.m_7333_(mat);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.CONF_BG);
        RenderSystem.m_69478_();
        InGameConfigScreen.m_93133_((PoseStack)mat, (int)0, (int)(this.f_96544_ / 3 - 1), (float)this.f_96543_, (float)3.0f, (int)this.f_96543_, (int)3, (int)3, (int)3);
        InGameConfigScreen.m_93133_((PoseStack)mat, (int)0, (int)(this.f_96544_ / 3 * 2 - 1), (float)this.f_96543_, (float)3.0f, (int)this.f_96543_, (int)3, (int)3, (int)3);
        InGameConfigScreen.m_93133_((PoseStack)mat, (int)(this.f_96543_ / 3 - 1), (int)0, (float)3.0f, (float)this.f_96544_, (int)3, (int)this.f_96544_, (int)3, (int)3);
        InGameConfigScreen.m_93133_((PoseStack)mat, (int)(this.f_96543_ / 3 * 2 - 1), (int)0, (float)3.0f, (float)this.f_96544_, (int)3, (int)this.f_96544_, (int)3, (int)3);
        RenderSystem.m_69461_();
        for (ConfigWidget w : this.listForRender) {
            w.m_6305_(mat, mouseX, mouseY, partialTick);
        }
        this.backButton.m_6305_(mat, mouseX, mouseY, partialTick);
    }

    private void onInvChanged() {
        InventoryHUD.isActive = this.ICW.getShow();
        InventoryHUD.getClientConfig().byDefault.set((Object)this.ICW.getShow());
        InventoryHUD.saveConfig();
    }

    private void onInvPosChanged() {
        if (this.ICW.f_93620_ + this.ICW.m_5711_() / 2 <= this.f_96541_.f_91080_.f_96543_ / 3) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryGui.invX = this.ICW.f_93620_;
        } else if (this.ICW.f_93620_ + this.ICW.m_5711_() / 2 >= this.f_96541_.f_91080_.f_96543_ / 3 * 2) {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryGui.invX = this.f_96541_.f_91080_.f_96543_ - this.ICW.f_93620_;
        } else {
            InventoryGui.InvAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryGui.invX = this.ICW.f_93620_ + this.ICW.m_5711_() / 2 <= this.f_96541_.f_91080_.f_96543_ / 2 - 10 ? this.f_96541_.f_91080_.f_96543_ / 2 - this.ICW.m_5711_() / 2 - this.ICW.f_93620_ : (this.ICW.f_93620_ + this.ICW.m_5711_() / 2 >= this.f_96541_.f_91080_.f_96543_ / 2 + 10 ? this.f_96541_.f_91080_.f_96543_ / 2 - this.ICW.m_5711_() / 2 - this.ICW.f_93620_ : 0);
        }
        if (this.ICW.f_93621_ + this.ICW.m_93694_() / 2 <= this.f_96541_.f_91080_.f_96544_ / 3) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryGui.invY = this.ICW.f_93621_;
        } else if (this.ICW.f_93621_ + this.ICW.m_93694_() / 2 >= this.f_96541_.f_91080_.f_96544_ / 3 * 2) {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryGui.invY = this.f_96541_.f_91080_.f_96544_ - this.ICW.f_93621_;
        } else {
            InventoryGui.InvAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryGui.invY = this.ICW.f_93621_ + this.ICW.m_93694_() / 2 <= this.f_96541_.f_91080_.f_96544_ / 2 - 10 ? this.f_96541_.f_91080_.f_96544_ / 2 - this.ICW.m_93694_() / 2 - this.ICW.f_93621_ : (this.ICW.f_93621_ + this.ICW.m_93694_() / 2 >= this.f_96541_.f_91080_.f_96544_ / 2 + 10 ? this.f_96541_.f_91080_.f_96544_ / 2 - this.ICW.m_93694_() / 2 - this.ICW.f_93621_ : 0);
        }
    }

    private void onPotionChanged() {
        InventoryHUD.potionHUD = this.PCW.getShow();
        InventoryHUD.getClientConfig().Potions.set((Object)this.PCW.getShow());
        InventoryHUD.saveConfig();
    }

    private void onPotionPosChanged() {
        if (this.PCW.f_93620_ + this.PCW.m_5711_() / 2 <= this.f_96541_.f_91080_.f_96543_ / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = this.PCW.f_93620_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else if (this.PCW.f_93620_ + this.PCW.m_5711_() / 2 >= this.f_96541_.f_91080_.f_96543_ / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = this.f_96541_.f_91080_.f_96543_ - this.PCW.f_93620_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            if (this.PCW.f_93620_ + this.PCW.m_5711_() / 2 <= this.f_96541_.f_91080_.f_96543_ / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = this.f_96541_.f_91080_.f_96543_ / 2 - this.PCW.m_5711_() / 2 - this.PCW.f_93620_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else if (this.PCW.f_93620_ + this.PCW.m_5711_() / 2 >= this.f_96541_.f_91080_.f_96543_ / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = this.f_96541_.f_91080_.f_96543_ / 2 - this.PCW.m_5711_() / 2 - this.PCW.f_93620_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
            }
        }
        if (this.PCW.f_93621_ + this.PCW.m_93694_() / 2 <= this.f_96541_.f_91080_.f_96544_ / 3) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = this.PCW.f_93621_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
        } else if (this.PCW.f_93621_ + this.PCW.m_93694_() / 2 >= this.f_96541_.f_91080_.f_96544_ / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = this.f_96541_.f_91080_.f_96544_ - this.PCW.f_93621_;
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
        } else {
            InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign = WidgetAligns.VAlign.CENTER;
            if (this.PCW.f_93621_ + this.PCW.m_93694_() / 2 <= this.f_96541_.f_91080_.f_96544_ / 2 - 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = this.f_96541_.f_91080_.f_96544_ / 2 - this.PCW.m_93694_() / 2 - this.PCW.f_93621_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            } else if (this.PCW.f_93621_ + this.PCW.m_93694_() / 2 >= this.f_96541_.f_91080_.f_96544_ / 2 + 10) {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = this.f_96541_.f_91080_.f_96544_ / 2 - this.PCW.m_93694_() / 2 - this.PCW.f_93621_;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(false);
            } else {
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY = 0;
                InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosYChanged(true);
            }
        }
    }

    private void onArmorChanged() {
        InventoryHUD.armorHUD = this.ACW.getShow();
        InventoryHUD.getClientConfig().ArmorDamage.set((Object)this.ACW.getShow());
        InventoryHUD.saveConfig();
    }

    private void onArmorPosChanged() {
        int ay;
        int ax;
        WidgetAligns armal = new WidgetAligns(WidgetAligns.HAlign.LEFT, WidgetAligns.VAlign.BOTTOM);
        if (this.ACW.f_93620_ + this.ACW.m_5711_() / 2 <= this.f_96541_.f_91080_.f_96543_ / 3) {
            armal.HorAlign = WidgetAligns.HAlign.LEFT;
            ax = this.ACW.f_93620_;
        } else if (this.ACW.f_93620_ + this.ACW.m_5711_() / 2 >= this.f_96541_.f_91080_.f_96543_ / 3 * 2) {
            armal.HorAlign = WidgetAligns.HAlign.RIGHT;
            ax = this.f_96541_.f_91080_.f_96543_ - this.ACW.f_93620_;
        } else {
            armal.HorAlign = WidgetAligns.HAlign.MIDDLE;
            ax = this.ACW.f_93620_ + this.ACW.m_5711_() / 2 <= this.f_96541_.f_91080_.f_96543_ / 2 - 10 ? this.f_96541_.f_91080_.f_96543_ / 2 - this.ACW.m_5711_() / 2 - this.ACW.f_93620_ : (this.ACW.f_93620_ + this.ACW.m_5711_() / 2 >= this.f_96541_.f_91080_.f_96543_ / 2 + 10 ? this.f_96541_.f_91080_.f_96543_ / 2 - this.ACW.m_5711_() / 2 - this.ACW.f_93620_ : 0);
        }
        if (this.ACW.f_93621_ + this.ACW.m_93694_() / 2 <= this.f_96541_.f_91080_.f_96544_ / 2 - 10) {
            armal.VertAlign = WidgetAligns.VAlign.TOP;
            ay = this.ACW.f_93621_;
        } else if (this.ACW.f_93621_ + this.ACW.m_93694_() / 2 >= this.f_96541_.f_91080_.f_96544_ / 2 + 10) {
            armal.VertAlign = WidgetAligns.VAlign.BOTTOM;
            ay = this.f_96541_.f_91080_.f_96544_ - this.ACW.f_93621_;
        } else {
            armal.VertAlign = WidgetAligns.VAlign.CENTER;
            ay = this.ACW.f_93621_ + this.ACW.m_93694_() / 2 <= this.f_96541_.f_91080_.f_96544_ / 2 - 10 ? this.f_96541_.f_91080_.f_96544_ / 2 - this.ACW.m_93694_() / 2 - this.ACW.f_93621_ : (this.ACW.f_93621_ + this.ACW.m_93694_() / 2 >= this.f_96541_.f_91080_.f_96544_ / 2 + 10 ? this.f_96541_.f_91080_.f_96544_ / 2 - this.ACW.m_93694_() / 2 - this.ACW.f_93621_ : 0);
        }
        InventoryHUD.getInstance().getInventoryGui().changeArmorPos(armal, ax, ay);
    }

    private void onCuriosItemPosChanged(ConfigWidget w, CuriosSlot slot) {
        if (w.f_93620_ + w.m_5711_() / 2 <= this.f_96541_.f_91080_.f_96543_ / 3) {
            slot.aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            slot.x = w.f_93620_;
        } else if (w.f_93620_ + w.m_5711_() / 2 >= this.f_96541_.f_91080_.f_96543_ / 3 * 2) {
            slot.aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            slot.x = this.f_96541_.f_91080_.f_96543_ - w.f_93620_;
        } else {
            slot.aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            slot.x = this.f_96541_.f_91080_.f_96543_ / 2 - w.m_5711_() / 2 - w.f_93620_;
        }
        if (w.f_93621_ + w.m_93694_() / 2 <= this.f_96541_.f_91080_.f_96544_ / 2 - 10) {
            slot.aligns.VertAlign = WidgetAligns.VAlign.TOP;
            slot.y = w.f_93621_;
        } else if (w.f_93621_ + w.m_93694_() / 2 >= this.f_96541_.f_91080_.f_96544_ / 2 + 10) {
            slot.aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            slot.y = this.f_96541_.f_91080_.f_96544_ - w.f_93621_;
        } else {
            slot.aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            slot.y = this.f_96541_.f_91080_.f_96544_ / 2 - w.m_93694_() / 2 - w.f_93621_;
        }
    }

    private void onItemPosChanged(ConfigWidget w, int i) {
        if (w.f_93620_ + w.m_5711_() / 2 <= this.f_96541_.f_91080_.f_96543_ / 3) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.LEFT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = w.f_93620_;
        } else if (w.f_93620_ + w.m_5711_() / 2 >= this.f_96541_.f_91080_.f_96543_ / 3 * 2) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.RIGHT;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = this.f_96541_.f_91080_.f_96543_ - w.f_93620_;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.HorAlign = WidgetAligns.HAlign.MIDDLE;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].x = this.f_96541_.f_91080_.f_96543_ / 2 - w.m_5711_() / 2 - w.f_93620_;
        }
        if (w.f_93621_ + w.m_93694_() / 2 <= this.f_96541_.f_91080_.f_96544_ / 2 - 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.TOP;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = w.f_93621_;
        } else if (w.f_93621_ + w.m_93694_() / 2 >= this.f_96541_.f_91080_.f_96544_ / 2 + 10) {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.BOTTOM;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = this.f_96541_.f_91080_.f_96544_ - w.f_93621_;
        } else {
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].aligns.VertAlign = WidgetAligns.VAlign.CENTER;
            InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[i].y = this.f_96541_.f_91080_.f_96544_ / 2 - w.m_93694_() / 2 - w.f_93621_;
        }
    }

    private void saveConfig() {
        InventoryHUD.getClientConfig().xPos.set((Object)InventoryGui.invX);
        InventoryHUD.getClientConfig().yPos.set((Object)InventoryGui.invY);
        InventoryHUD.getClientConfig().invHalign.set((Object)InventoryGui.InvAligns.HorAlign);
        InventoryHUD.getClientConfig().invValign.set((Object)InventoryGui.InvAligns.VertAlign);
        InventoryHUD.getClientConfig().xPotionPos.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.potX);
        InventoryHUD.getClientConfig().yPotionPos.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.potY);
        InventoryHUD.getClientConfig().potHalign.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.HorAlign);
        InventoryHUD.getClientConfig().potValign.set((Object)InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotAligns.VertAlign);
        InventoryHUD.getClientConfig().xArmPos.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.armX);
        InventoryHUD.getClientConfig().yArmPos.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.armY);
        InventoryHUD.getClientConfig().armHalign.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.HorAlign);
        InventoryHUD.getClientConfig().armValign.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.ArmAligns.VertAlign);
        InventoryHUD.getClientConfig().helmPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].x);
        InventoryHUD.getClientConfig().chestPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].x);
        InventoryHUD.getClientConfig().legPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].x);
        InventoryHUD.getClientConfig().bootPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].x);
        InventoryHUD.getClientConfig().offPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].x);
        InventoryHUD.getClientConfig().mainPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].x);
        InventoryHUD.getClientConfig().invPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].x);
        InventoryHUD.getClientConfig().arrPosX.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].x);
        InventoryHUD.getClientConfig().helmPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].y);
        InventoryHUD.getClientConfig().chestPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].y);
        InventoryHUD.getClientConfig().legPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].y);
        InventoryHUD.getClientConfig().bootPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].y);
        InventoryHUD.getClientConfig().offPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].y);
        InventoryHUD.getClientConfig().mainPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].y);
        InventoryHUD.getClientConfig().invPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].y);
        InventoryHUD.getClientConfig().arrPosY.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].y);
        InventoryHUD.getClientConfig().helmHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.HorAlign);
        InventoryHUD.getClientConfig().chestHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.HorAlign);
        InventoryHUD.getClientConfig().legHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.HorAlign);
        InventoryHUD.getClientConfig().bootHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.HorAlign);
        InventoryHUD.getClientConfig().offHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.HorAlign);
        InventoryHUD.getClientConfig().mainHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.HorAlign);
        InventoryHUD.getClientConfig().invHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.HorAlign);
        InventoryHUD.getClientConfig().arrHal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.HorAlign);
        InventoryHUD.getClientConfig().helmVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[0].aligns.VertAlign);
        InventoryHUD.getClientConfig().chestVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[1].aligns.VertAlign);
        InventoryHUD.getClientConfig().legVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[2].aligns.VertAlign);
        InventoryHUD.getClientConfig().bootVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[3].aligns.VertAlign);
        InventoryHUD.getClientConfig().offVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[4].aligns.VertAlign);
        InventoryHUD.getClientConfig().mainVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[5].aligns.VertAlign);
        InventoryHUD.getClientConfig().invVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[6].aligns.VertAlign);
        InventoryHUD.getClientConfig().arrVal.set((Object)InventoryHUD.getInstance().getInventoryGui().armorRenderer.items[7].aligns.VertAlign);
        InventoryHUD.saveConfig();
        if (InventoryHUD.isCuriosMod) {
            CuriosSaveUtils.save();
        }
    }

    public void m_7379_() {
        this.saveConfig();
        switch (this.menu) {
            case -1: {
                this.f_96541_.m_91152_(null);
                break;
            }
            case 0: {
                this.f_96541_.m_91152_((Screen)new InventoryConfigScreen(this.inGame));
                break;
            }
            case 1: {
                this.f_96541_.m_91152_((Screen)new ArmorConfigScreen(this.inGame));
                break;
            }
            case 2: {
                this.f_96541_.m_91152_((Screen)new PotionConfigScreen(this.inGame));
                break;
            }
            case 3: {
                this.f_96541_.m_91152_((Screen)new CuriosConfigScreen(this.inGame));
            }
        }
    }
}

