/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import dlovin.inventoryhud.gui.renderers.BlockArmorRenderer;
import dlovin.inventoryhud.gui.renderers.CuriosRenderer;
import dlovin.inventoryhud.gui.renderers.EachArmorRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HotBarArmorRenderer;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalPotionRenderer;
import dlovin.inventoryhud.utils.CuriosSlot;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InventoryGui
extends Gui {
    private final ItemRenderer itemRenderer;
    private final Font fontRenderer;
    private final Minecraft minecraft = Minecraft.m_91087_();
    public static int invX;
    public static int invY;
    public static WidgetAligns InvAligns;
    public static float invAlpha;
    public static boolean invMini;
    public static boolean invVert;
    public static boolean animated;
    public static boolean hideBackground;
    public static boolean withDebug;
    private static final ResourceLocation INVBG;
    public ArmorRenderer armorRenderer;
    public PotionRenderer potionRenderer;
    public CuriosRenderer curiosRenderer;

    public InventoryGui() {
        super(Minecraft.m_91087_());
        this.itemRenderer = this.minecraft.m_91291_();
        this.fontRenderer = this.minecraft.f_91062_;
        WidgetAligns ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().armValign.get()));
        int armX = (Integer)InventoryHUD.getClientConfig().xArmPos.get();
        int armY = (Integer)InventoryHUD.getClientConfig().yArmPos.get();
        this.armorRenderer = (Boolean)InventoryHUD.getClientConfig().moveAll.get() == false ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        if (InventoryHUD.isCuriosMod) {
            this.curiosRenderer = new CuriosRenderer(this.minecraft);
        }
        this.setupArmorRenderer();
        this.potionRenderer = (Boolean)InventoryHUD.getClientConfig().potHor.get() != false ? ((Boolean)InventoryHUD.getClientConfig().potMini.get() != false ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft)) : ((Boolean)InventoryHUD.getClientConfig().potMini.get() != false ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft));
        this.setupPotionRenderer();
        InventoryHUD.isActive = (Boolean)InventoryHUD.getClientConfig().byDefault.get();
        InventoryHUD.armorHUD = (Boolean)InventoryHUD.getClientConfig().ArmorDamage.get();
        InventoryHUD.potionHUD = (Boolean)InventoryHUD.getClientConfig().Potions.get();
        invX = (Integer)InventoryHUD.getClientConfig().xPos.get();
        invY = (Integer)InventoryHUD.getClientConfig().yPos.get();
        InvAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().invHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().invValign.get()));
        invMini = (Boolean)InventoryHUD.getClientConfig().invMini.get();
        invVert = (Boolean)InventoryHUD.getClientConfig().invVert.get();
        animated = (Boolean)InventoryHUD.getClientConfig().animatedInv.get();
        hideBackground = (Boolean)InventoryHUD.getClientConfig().hideBackground.get();
        invAlpha = (float)((Integer)InventoryHUD.getClientConfig().invAlpha.get()).intValue() / 100.0f;
        withDebug = (Boolean)InventoryHUD.getClientConfig().invWithDebug.get();
        InventoryHUD.getInstance().setInvGui(this);
    }

    private void setupPotionRenderer() {
        this.potionRenderer.potX = (Integer)InventoryHUD.getClientConfig().xPotionPos.get();
        this.potionRenderer.potY = (Integer)InventoryHUD.getClientConfig().yPotionPos.get();
        this.potionRenderer.PotAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().potHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().potValign.get()));
        this.potionRenderer.potMini = (Boolean)InventoryHUD.getClientConfig().potMini.get();
        this.potionRenderer.potGap = (Integer)InventoryHUD.getClientConfig().potGap.get();
        this.potionRenderer.barDuration = (Integer)InventoryHUD.getClientConfig().barDuration.get() * 20;
        this.potionRenderer.PotPosChanged();
        switch (this.potionRenderer.PotAligns.VertAlign) {
            case TOP: {
                this.potionRenderer.potVert = 1;
                break;
            }
            case CENTER: {
                if (this.potionRenderer.potY - 12 < this.minecraft.m_91268_().m_85446_() / 2) {
                    this.potionRenderer.potVert = -1;
                    break;
                }
                this.potionRenderer.potVert = 1;
                break;
            }
            case BOTTOM: {
                this.potionRenderer.potVert = -1;
            }
        }
        this.potionRenderer.potAlpha = (float)((Integer)InventoryHUD.getClientConfig().potAlpha.get()).intValue() / 100.0f;
        this.potionRenderer.showHidden = (Boolean)InventoryHUD.getClientConfig().showHiddenEffects.get();
        this.potionRenderer.withDebug = (Boolean)InventoryHUD.getClientConfig().potWithDebug.get();
        this.potionRenderer.potionLevels = (Boolean)InventoryHUD.getClientConfig().potionLevels.get();
    }

    private void setupArmorRenderer() {
        this.armorRenderer.armX = (Integer)InventoryHUD.getClientConfig().xArmPos.get();
        this.armorRenderer.armY = (Integer)InventoryHUD.getClientConfig().yArmPos.get();
        this.armorRenderer.ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().armValign.get()));
        this.armorRenderer.armAbove = (Integer)InventoryHUD.getClientConfig().armAbove.get();
        this.armorRenderer.armScale = (float)((Integer)InventoryHUD.getClientConfig().armScale.get()).intValue() * 0.01f;
        this.armorRenderer.showArmor = (Boolean)InventoryHUD.getClientConfig().showArmor.get();
        this.armorRenderer.showMain = (Boolean)InventoryHUD.getClientConfig().showMain.get();
        this.armorRenderer.showOff = (Boolean)InventoryHUD.getClientConfig().showOff.get();
        this.armorRenderer.showArrows = (Boolean)InventoryHUD.getClientConfig().showArrows.get();
        this.armorRenderer.showInv = (Boolean)InventoryHUD.getClientConfig().showInv.get();
        this.armorRenderer.showEmpty = (Boolean)InventoryHUD.getClientConfig().showEmpty.get();
        this.armorRenderer.showCount = (Boolean)InventoryHUD.getClientConfig().showCount.get();
        this.armorRenderer.armView = (InvConfig.ArmorView)((Object)InventoryHUD.getClientConfig().armView.get());
        this.armorRenderer.armBars = (Boolean)InventoryHUD.getClientConfig().armBars.get();
        this.armorRenderer.showArrowsWithoutWeapon = (Boolean)InventoryHUD.getClientConfig().showArrowsWithoutWeapon.get();
        this.armorRenderer.withDebug = (Boolean)InventoryHUD.getClientConfig().armWithDebug.get();
        if (InventoryHUD.isCuriosMod) {
            this.curiosRenderer.armAbove = this.armorRenderer.armAbove;
            this.curiosRenderer.armScale = this.armorRenderer.armScale;
            this.curiosRenderer.showEmpty = this.armorRenderer.showEmpty;
            this.curiosRenderer.armView = this.armorRenderer.armView;
            this.curiosRenderer.armBars = this.armorRenderer.armBars;
            this.curiosRenderer.showCount = this.armorRenderer.showCount;
        }
        this.armorRenderer.items[0] = new EachItem((Integer)InventoryHUD.getClientConfig().helmPosX.get(), (Integer)InventoryHUD.getClientConfig().helmPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().helmHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().helmVal.get())));
        this.armorRenderer.items[1] = new EachItem((Integer)InventoryHUD.getClientConfig().chestPosX.get(), (Integer)InventoryHUD.getClientConfig().chestPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().chestHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().chestVal.get())));
        this.armorRenderer.items[2] = new EachItem((Integer)InventoryHUD.getClientConfig().legPosX.get(), (Integer)InventoryHUD.getClientConfig().legPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().legHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().legVal.get())));
        this.armorRenderer.items[3] = new EachItem((Integer)InventoryHUD.getClientConfig().bootPosX.get(), (Integer)InventoryHUD.getClientConfig().bootPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().bootHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().bootVal.get())));
        this.armorRenderer.items[4] = new EachItem((Integer)InventoryHUD.getClientConfig().offPosX.get(), (Integer)InventoryHUD.getClientConfig().offPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().offHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().offVal.get())));
        this.armorRenderer.items[5] = new EachItem((Integer)InventoryHUD.getClientConfig().mainPosX.get(), (Integer)InventoryHUD.getClientConfig().mainPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().mainHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().mainVal.get())));
        this.armorRenderer.items[6] = new EachItem((Integer)InventoryHUD.getClientConfig().invPosX.get(), (Integer)InventoryHUD.getClientConfig().invPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().invHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().invVal.get())));
        this.armorRenderer.items[7] = new EachItem((Integer)InventoryHUD.getClientConfig().arrPosX.get(), (Integer)InventoryHUD.getClientConfig().arrPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().arrHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().arrVal.get())));
        this.changeArmorOffset();
    }

    @SubscribeEvent
    public void onPreLayer(RenderGameOverlayEvent.PreLayer event) {
        if (event.getOverlay().equals(ForgeIngameGui.POTION_ICONS_ELEMENT) && InventoryHUD.potionHUD) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPreRenderGui(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        PoseStack mat = event.getMatrixStack();
        int width = this.minecraft.m_91268_().m_85445_();
        int height = this.minecraft.m_91268_().m_85446_();
        mat.m_85836_();
        if (InventoryHUD.armorHUD && (!this.minecraft.f_91066_.f_92063_ || this.armorRenderer.withDebug)) {
            this.armorRenderer.render(mat, width, height);
            if (InventoryHUD.isCuriosMod && this.hasCuriosSlots()) {
                this.curiosRenderer.render(mat, width, height);
            }
        }
        if (InventoryHUD.potionHUD && (!this.minecraft.f_91066_.f_92063_ || this.potionRenderer.withDebug)) {
            this.potionRenderer.render(mat, width, height);
        }
        if (InventoryHUD.isActive && !(this.minecraft.f_91080_ instanceof ContainerScreen) && (!this.minecraft.f_91066_.f_92063_ || withDebug)) {
            this.RenderInventory(mat, width, height, event.getPartialTicks());
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mat.m_85849_();
    }

    private void RenderInventory(PoseStack mat, int width, int height, float partialTicks) {
        int iMax = invVert ? 3 : 9;
        int jMax = invVert ? 9 : 3;
        float scale = invMini ? 0.75f : 1.0f;
        int px = this.getX(width, (int)((float)(iMax * 18 - 2) * scale), invX, InventoryGui.InvAligns.HorAlign);
        int py = this.getY(height, (int)((float)(jMax * 18 - 2) * scale), invY, InventoryGui.InvAligns.VertAlign);
        ArrayList<Runnable> items = new ArrayList<Runnable>();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                ItemStack item = (ItemStack)this.minecraft.f_91074_.m_150109_().f_35974_.get(index);
                PoseStack matr = RenderSystem.m_157191_();
                if (item.m_41720_().equals(Items.f_41852_)) continue;
                int finalI = i;
                int finalJ = j;
                items.add(() -> {
                    float f = (float)item.m_41612_() - partialTicks;
                    matr.m_85836_();
                    matr.m_85837_((double)px, (double)py, -201.0);
                    matr.m_85841_(scale, scale, 1.0f);
                    if (animated && f > 0.0f) {
                        matr.m_85836_();
                        float f1 = 1.0f + f / 5.0f;
                        matr.m_85837_((double)(finalI * 18 + 12), (double)(finalJ * 18 + 12), 0.0);
                        matr.m_85841_((f1 + 1.0f) / 2.0f, (f1 + 1.0f) / 2.0f, 1.0f);
                        matr.m_85837_((double)(-(finalI * 18 + 12)), (double)(-(finalJ * 18 + 12)), 0.0);
                    }
                    RenderSystem.m_157182_();
                    this.itemRenderer.m_115203_(item, finalI * 18, finalJ * 18);
                    if (animated && f > 0.0f) {
                        matr.m_85849_();
                    }
                    this.itemRenderer.m_115174_(this.fontRenderer, item, finalI * 18, finalJ * 18, null);
                    matr.m_85849_();
                    RenderSystem.m_157182_();
                });
            }
        }
        if (items.size() > 0 || !hideBackground) {
            mat.m_85836_();
            mat.m_85837_((double)px, (double)py, -255.0);
            mat.m_85841_(scale, scale, scale);
            if (invAlpha > 0.0f) {
                RenderSystem.m_69478_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)invAlpha);
                RenderSystem.m_157456_((int)0, (ResourceLocation)INVBG);
                InventoryGui.m_93160_((PoseStack)mat, (int)-8, (int)-8, (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (float)0.0f, (float)(jMax == 3 ? 0.0f : 68.0f), (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (int)256, (int)256);
                RenderSystem.m_69461_();
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            items.forEach(Runnable::run);
            mat.m_85849_();
        }
    }

    private int getX(int width, int itemWidth, int x, WidgetAligns.HAlign hal) {
        int result;
        switch (hal) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LEFT: {
                int n = x;
                break;
            }
            case MIDDLE: {
                int n = width / 2 - itemWidth / 2 - x;
                break;
            }
            case RIGHT: {
                int n = result = width - x;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > width - itemWidth) {
            result = width - itemWidth;
        }
        return result;
    }

    private int getY(int height, int itemHeight, int y, WidgetAligns.VAlign val) {
        int result;
        switch (val) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TOP: {
                int n = y;
                break;
            }
            case CENTER: {
                int n = height / 2 - itemHeight / 2 - y;
                break;
            }
            case BOTTOM: {
                int n = result = height - y;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > height - itemHeight) {
            result = height - itemHeight;
        }
        return result;
    }

    public void changeArmorPos(WidgetAligns armal, int ax, int ay) {
        if (armal.HorAlign == WidgetAligns.HAlign.MIDDLE && armal.VertAlign == WidgetAligns.VAlign.BOTTOM && (float)ay <= 70.0f * this.armorRenderer.armScale + 5.0f && Math.abs(ax) <= 90) {
            if (!(this.armorRenderer instanceof HotBarArmorRenderer)) {
                this.armorRenderer = new HotBarArmorRenderer(this.minecraft);
                this.setupArmorRenderer();
            }
        } else if (this.armorRenderer instanceof HotBarArmorRenderer) {
            this.armorRenderer = new BlockArmorRenderer(this.minecraft);
            this.setupArmorRenderer();
        }
        this.armorRenderer.ArmAligns = armal;
        this.armorRenderer.armY = ay;
        this.armorRenderer.armX = ax;
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeArmorOffset() {
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeMoveAll(Boolean bd) {
        WidgetAligns ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().armValign.get()));
        int armX = (Integer)InventoryHUD.getClientConfig().xArmPos.get();
        int armY = (Integer)InventoryHUD.getClientConfig().yArmPos.get();
        this.armorRenderer = bd == false ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        this.setupArmorRenderer();
    }

    public void changePotionMini(boolean mini) {
        this.changePotion(mini, (Boolean)InventoryHUD.getClientConfig().potHor.get());
        this.setupPotionRenderer();
    }

    public void changePotionHor(boolean hor) {
        this.changePotion((Boolean)InventoryHUD.getClientConfig().potMini.get(), hor);
    }

    private void changePotion(boolean mini, boolean hor) {
        this.potionRenderer = hor ? (mini ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft)) : (mini ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft));
        this.setupPotionRenderer();
    }

    public void resetBlackList() {
        this.potionRenderer.resetBlacklist();
    }

    public void disableCurios() {
        this.curiosRenderer.disable();
    }

    public HashMap<String, CuriosSlot> getCuriosSlots() {
        return this.curiosRenderer.slots();
    }

    public boolean hasCuriosSlots() {
        return !this.curiosRenderer.isEmpty();
    }

    static {
        INVBG = new ResourceLocation("inventoryhud", "textures/gui/inv_bg.png");
    }
}

