/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.config.ConfigScreen;
import dlovin.inventoryhud.gui.config.EffectsBlacklistScreen;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;

public class PotionConfigScreen
extends ConfigScreen {
    public PotionConfigScreen(boolean inGame) {
        super(2, inGame);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        String toggle = (Boolean)InventoryHUD.getClientConfig().Potions.get() != false ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        int index = 0;
        this.addButton(index++, toggle, this::ToggleSwitch);
        this.addNumericField(index++, 0, 100, (Integer)InventoryHUD.getClientConfig().potAlpha.get(), this::AlphaChanged, 5);
        this.addButton(index++, ((Boolean)InventoryHUD.getClientConfig().potMini.get()).toString(), this::MiniModeSwitch);
        this.addButton(index++, ((Boolean)InventoryHUD.getClientConfig().potHor.get()).toString(), this::HorModeSwitch);
        this.addNumericField(index++, -5, 5, (Integer)InventoryHUD.getClientConfig().potGap.get(), this::GapChanged, 3);
        this.addNumericField(index++, 1, Integer.MAX_VALUE, (Integer)InventoryHUD.getClientConfig().barDuration.get(), this::BarChanged);
        this.addButton(index++, ((Boolean)InventoryHUD.getClientConfig().showHiddenEffects.get()).toString(), this::HiddenSwitch);
        int blEditBtnWidth = Math.min(this.f_96547_.m_92895_(Translation.BLACKLIST_BTN.getString()) + 8, 40);
        this.addButton(index++, ((Boolean)InventoryHUD.getClientConfig().potionLevels.get()).toString(), this::LevelSwitch);
        this.addButton(index++, ((Boolean)InventoryHUD.getClientConfig().potWithDebug.get()).toString(), this::WithDebug);
        this.addButton(index, blEditBtnWidth, Translation.BLACKLIST_BTN.getString(), b -> this.f_96541_.m_91152_((Screen)new EffectsBlacklistScreen(this.inGame)));
        index = 0;
        this.addText(index++, Translation.POT_TOGGLE.getString(), Translation.POT_TOGGLE_TT);
        this.addText(index++, Translation.POT_ALPHA.getString(), Translation.POT_ALPHA_TT);
        this.addText(index++, Translation.POT_MINI.getString(), Translation.POT_MINI_TT);
        this.addText(index++, Translation.POT_HOR.getString(), Translation.POT_HOR_TT);
        this.addText(index++, Translation.POT_GAP.getString(), Translation.POT_GAP_TT);
        this.addText(index++, Translation.BAR_DUR.getString(), Translation.BAR_DUR_TT);
        this.addText(index++, Translation.HIDDEN_EFFECTS.getString(), Translation.HIDDEN_EFFECTS_TT);
        this.addText(index++, Translation.POTION_LEVELS.getString(), Translation.POTION_LEVELS_TT);
        this.addText(index++, Translation.WITH_DEBUG.getString(), Translation.POT_DEBUG_TT);
        this.addText(index, Translation.BLACKLIST.getString(), Translation.BLACKLIST_TT);
    }

    private void LevelSwitch(ButtonWidget btn) {
        Boolean bd = (Boolean)InventoryHUD.getClientConfig().potionLevels.get() == false;
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.potionLevels = bd;
        InventoryHUD.getClientConfig().potionLevels.set((Object)bd);
        btn.setMessage(bd.toString());
        InventoryHUD.saveConfig();
    }

    private void WithDebug(ButtonWidget btn) {
        Boolean bd = (Boolean)InventoryHUD.getClientConfig().potWithDebug.get() == false;
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.withDebug = bd;
        InventoryHUD.getClientConfig().potWithDebug.set((Object)bd);
        btn.setMessage(bd.toString());
        InventoryHUD.saveConfig();
    }

    private void HiddenSwitch(ButtonWidget btn) {
        Boolean h = (Boolean)InventoryHUD.getClientConfig().showHiddenEffects.get() == false;
        btn.setMessage(h.toString());
        InventoryHUD.getClientConfig().showHiddenEffects.set((Object)h);
        InventoryHUD.saveConfig();
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.showHidden = h;
    }

    private void BarChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 300;
        }
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.barDuration = a * 20;
        InventoryHUD.getClientConfig().barDuration.set((Object)a);
        InventoryHUD.saveConfig();
    }

    private void HorModeSwitch(ButtonWidget btn) {
        boolean hor = (Boolean)InventoryHUD.getClientConfig().potHor.get() == false;
        InventoryHUD.getClientConfig().potHor.set((Object)hor);
        InventoryHUD.saveConfig();
        InventoryHUD.getInstance().getInventoryGui().changePotionHor(hor);
        btn.setMessage(Boolean.toString(hor));
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
    }

    private void AlphaChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 100;
        }
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.potAlpha = (float)a / 100.0f;
        InventoryHUD.getClientConfig().potAlpha.set((Object)a);
        InventoryHUD.saveConfig();
    }

    private void GapChanged(TextField field) {
        int a;
        try {
            a = Integer.parseInt(field.getText());
        }
        catch (NumberFormatException ex) {
            a = 0;
        }
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.potGap = a;
        InventoryHUD.getClientConfig().potGap.set((Object)a);
        InventoryHUD.saveConfig();
    }

    private void ToggleSwitch(ButtonWidget btn) {
        Boolean potion = (Boolean)InventoryHUD.getClientConfig().Potions.get() == false;
        InventoryHUD.potionHUD = potion;
        InventoryHUD.getClientConfig().Potions.set((Object)potion);
        String toggle = potion != false ? ChatFormatting.DARK_GREEN + "ON" : ChatFormatting.DARK_RED + "OFF";
        btn.setMessage(toggle);
        InventoryHUD.saveConfig();
    }

    private void MiniModeSwitch(ButtonWidget btn) {
        boolean mini = (Boolean)InventoryHUD.getClientConfig().potMini.get() == false;
        InventoryHUD.getClientConfig().potMini.set((Object)mini);
        InventoryHUD.saveConfig();
        InventoryHUD.getInstance().getInventoryGui().changePotionMini(mini);
        btn.setMessage(Boolean.toString(mini));
        InventoryHUD.saveConfig();
        InventoryHUD.getInstance().getInventoryGui().potionRenderer.PotPosChanged();
    }
}

