/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.HudRenderer;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;

public class ArmorRenderer
extends HudRenderer {
    protected static Predicate<ItemStack> AMMO_TYPES = i -> i.m_41720_() instanceof ArrowItem;
    public boolean showMain;
    public boolean showOff;
    public boolean showArmor;
    public boolean showEmpty;
    public boolean showInv;
    public boolean showArrows;
    public boolean armBars;
    public boolean showCount;
    public boolean withDebug;
    public boolean showArrowsWithoutWeapon;
    public int armX;
    public int armY;
    public int armAbove;
    public float armScale;
    public WidgetAligns ArmAligns;
    public InvConfig.ArmorView armView;
    public EachItem[] items = new EachItem[8];
    Minecraft mc;
    Font fontRenderer;
    ItemRenderer itemRenderer;
    ResourceLocation[] armorRL = new ResourceLocation[]{new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_helmet.png"), new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_chestplate.png"), new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_leggings.png"), new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_boots.png"), new ResourceLocation("inventoryhud", "textures/item/empty_armor_slot_shield.png"), new ResourceLocation("inventoryhud", "textures/item/empty_main_hand_slot.png"), new ResourceLocation("inventoryhud", "textures/item/inventory.png"), new ResourceLocation("inventoryhud", "textures/item/arrows.png")};

    public ArmorRenderer(Minecraft mc) {
        this.mc = mc;
        this.fontRenderer = mc.f_91062_;
        this.itemRenderer = mc.m_91291_();
    }

    protected String getText(ItemStack item, int damage) {
        return switch (this.armView) {
            default -> throw new IncompatibleClassChangeError();
            case InvConfig.ArmorView.PERCENTAGE -> this.getDamageText(String.valueOf(damage), damage) + ChatFormatting.WHITE + "%";
            case InvConfig.ArmorView.DAMAGE -> this.getDamageText(String.valueOf(item.m_41773_()), damage);
            case InvConfig.ArmorView.DAMAGE_LEFT -> this.getDamageText(String.valueOf(item.m_41776_() - item.m_41773_()), damage);
            case InvConfig.ArmorView.OFF -> null;
        };
    }

    private String getDamageText(String p, int d) {
        Object result = p;
        if (d == 100) {
            result = ChatFormatting.GREEN + (String)result;
        } else if (d < 1) {
            result = ChatFormatting.DARK_RED + (String)result;
        } else if (d <= 10) {
            result = ChatFormatting.RED + (String)result;
        } else if (d <= 25) {
            result = ChatFormatting.GOLD + (String)result;
        } else if (d <= 50) {
            result = ChatFormatting.YELLOW + (String)result;
        }
        return result;
    }

    protected boolean showArrows() {
        return this.showArrows && (this.withProjectileWeapon(this.mc.f_91074_.m_21205_(), this.mc.f_91074_.m_21206_()) || this.showArrowsWithoutWeapon);
    }

    private boolean withProjectileWeapon(ItemStack mainHand, ItemStack offHand) {
        return mainHand.m_41720_() instanceof ProjectileWeaponItem || offHand.m_41720_() instanceof ProjectileWeaponItem;
    }

    Predicate<ItemStack> getAllProj(ItemStack mainHand, ItemStack offHand) {
        Item item = mainHand.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem item2 = (ProjectileWeaponItem)item;
            return item2.m_6442_().and(i -> offHand == i).or(item2.m_6437_());
        }
        item = offHand.m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem item3 = (ProjectileWeaponItem)item;
            return item3.m_6442_().and(i -> mainHand == i).or(item3.m_6437_());
        }
        return AMMO_TYPES;
    }

    protected int[] getFreeAndAmmo() {
        int[] result = new int[]{0, 0};
        Predicate<ItemStack> ammoTypes = this.getAllProj(this.mc.f_91074_.m_21205_(), this.mc.f_91074_.m_21206_());
        for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35974_) {
            if (slot.m_41619_()) {
                result[0] = result[0] + 1;
            }
            if (!this.isAmmo(slot, ammoTypes)) continue;
            result[1] = result[1] + slot.m_41613_();
        }
        for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35976_) {
            if (!this.isAmmo(slot, ammoTypes)) continue;
            result[1] = result[1] + slot.m_41613_();
        }
        return result;
    }

    boolean isAmmo(ItemStack stack, Predicate<ItemStack> ammoTypes) {
        return !stack.m_41619_() && ammoTypes.test(stack);
    }

    int getItemCount(ItemStack item) {
        int result = 0;
        for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35974_) {
            if (!slot.m_41656_(item)) continue;
            result += slot.m_41613_();
        }
        for (ItemStack slot : this.mc.f_91074_.m_150109_().f_35976_) {
            if (!slot.m_41656_(item)) continue;
            result += slot.m_41613_();
        }
        return result;
    }

    boolean getRight(int x, WidgetAligns.HAlign hal) {
        switch (hal) {
            case LEFT: {
                return false;
            }
            case MIDDLE: {
                return x > 0;
            }
            case RIGHT: {
                return true;
            }
        }
        return false;
    }

    void renderElementInBlock(PoseStack mat, int x, int y, int offSetX, int offSetY, float scale, boolean right, @Nullable ResourceLocation res, @Nullable ItemStack item, @Nullable String text, boolean overlay) {
        if (res != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)res);
            ArmorRenderer.m_93133_((PoseStack)mat, (int)offSetX, (int)offSetY, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
        } else {
            PoseStack matr = RenderSystem.m_157191_();
            matr.m_85836_();
            matr.m_85837_((double)((float)x + (float)offSetX * scale), (double)((float)y + (float)offSetY * scale), -256.0);
            matr.m_85841_(scale, scale, 1.0f);
            RenderSystem.m_157182_();
            this.itemRenderer.m_115203_(item, 0, 0);
            if (overlay) {
                this.itemRenderer.m_115174_(this.fontRenderer, item, 0, 0, null);
            }
            matr.m_85849_();
            RenderSystem.m_157182_();
        }
        if (text == null) {
            return;
        }
        if (right) {
            this.fontRenderer.m_92750_(mat, text, (float)(offSetX + 17), (float)(offSetY + 4), 0xFFFFFF);
        } else {
            this.fontRenderer.m_92750_(mat, text, (float)(offSetX - 1 - this.fontRenderer.m_92895_(text)), (float)(offSetY + 4), 0xFFFFFF);
        }
    }

    void renderElement(PoseStack mat, int x, int y, float scale, boolean right, @Nullable ResourceLocation res, @Nullable ItemStack item, @Nullable String text, boolean overlay) {
        if (res != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)res);
            ArmorRenderer.m_93133_((PoseStack)mat, (int)0, (int)0, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
        } else {
            PoseStack matr = RenderSystem.m_157191_();
            matr.m_85836_();
            matr.m_85837_((double)x, (double)y, -256.0);
            matr.m_85841_(scale, scale, 1.0f);
            RenderSystem.m_157182_();
            this.itemRenderer.m_115203_(item, 0, 0);
            if (overlay) {
                this.itemRenderer.m_115174_(this.fontRenderer, item, 0, 0, null);
            }
            matr.m_85849_();
            RenderSystem.m_157182_();
        }
        if (text == null) {
            return;
        }
        if (right) {
            this.fontRenderer.m_92750_(mat, text, 17.0f, 4.0f, 0xFFFFFF);
        } else {
            this.fontRenderer.m_92750_(mat, text, (float)(-1 - this.fontRenderer.m_92895_(text)), 4.0f, 0xFFFFFF);
        }
    }

    public void render(PoseStack mat, int width, int height) {
    }

    protected void preRender(PoseStack stack, int x, int y) {
        stack.m_85836_();
        stack.m_85837_((double)x, (double)y, -256.0);
    }

    protected void postRender(PoseStack stack) {
        stack.m_85849_();
    }
}

