/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.ItemStack;

public class BlockArmorRenderer
extends ArmorRenderer {
    private boolean right;

    public BlockArmorRenderer(Minecraft mc) {
        super(mc);
    }

    public void changeOffset() {
        this.right = this.getRight(this.armX, this.ArmAligns.HorAlign);
    }

    @Override
    public void render(PoseStack mat, int width, int height) {
        int x = this.getX(width, (int)(90.0f * this.armScale), this.armX, this.ArmAligns.HorAlign);
        int y = this.getY(height, (int)(70.0f * this.armScale), this.armY, this.ArmAligns.VertAlign);
        this.preRender(mat, x, y);
        mat.m_85841_(this.armScale, this.armScale, 1.0f);
        this.RenderItems(mat, x, y, this.right, this.armScale);
        this.postRender(mat);
    }

    private void RenderItems(PoseStack mat, int x, int y, boolean right, float scale) {
        int yOffset;
        int i = 5;
        int xOffsetT = right ? 75 : 0;
        for (ItemStack item : this.mc.f_91074_.m_20158_()) {
            int damage;
            if (!this.showMain && i == 5) {
                --i;
                continue;
            }
            if (!this.showOff && i == 4) {
                --i;
                continue;
            }
            if (!this.showArmor && i < 4) {
                --i;
                continue;
            }
            yOffset = i % 4 * 18;
            if (i == 4 && this.showMain) {
                yOffset += 18;
            }
            if (i == 5) {
                yOffset -= 18;
            }
            int xOffset = xOffsetT;
            if (i > 3 && this.showArmor) {
                int n = xOffset = right ? xOffset - 42 : xOffset + 42;
            }
            if ((damage = ArmorStatus.getDamage(item)) >= 0 && damage <= this.armAbove) {
                String text = this.getText(item, damage);
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, null, item, text, this.armBars);
            } else if (damage == -2) {
                String t = null;
                boolean over = true;
                if ((i == 5 || i == 4) && this.showCount) {
                    t = "" + this.getItemCount(item);
                    over = false;
                }
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, null, item, t, over);
            } else if (this.showEmpty) {
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, this.armorRL[i], null, null, false);
            }
            --i;
        }
        if (this.showArrows || this.showInv) {
            int[] values = this.getFreeAndAmmo();
            int xOffset = xOffsetT;
            yOffset = 36;
            if (this.showArmor) {
                int n = xOffset = right ? xOffset - 42 : xOffset + 42;
            }
            if (!this.showMain) {
                yOffset -= 18;
            }
            if (!this.showOff) {
                yOffset -= 18;
            }
            if (this.showInv) {
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, this.armorRL[6], null, "" + values[0], false);
                yOffset += 18;
            }
            if (this.showArrows()) {
                this.renderElementInBlock(mat, x, y, xOffset, yOffset, scale, !right, this.armorRL[7], null, "" + values[1], false);
            }
        }
    }
}

