/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import dlovin.inventoryhud.utils.CuriosIconUtils;
import dlovin.inventoryhud.utils.CuriosSaveUtils;
import dlovin.inventoryhud.utils.CuriosSlot;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class CuriosRenderer
extends ArmorRenderer {
    private int tries = 0;
    private long last = 0L;
    private HashMap<String, CuriosSlot> slots;

    public CuriosRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    public void render(PoseStack mat, int width, int height) {
        this.preRender(mat, 0, 0);
        this.renderCurios(mat, width, height);
        this.postRender(mat);
    }

    private void renderCurios(PoseStack mat, int width, int height) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.mc.f_91074_).ifPresent(handler -> handler.getCurios().forEach((id, stacksHandler) -> {
            for (int j = 0; j < stacksHandler.getSlots(); ++j) {
                Object slotId = id;
                if (j > 0) {
                    slotId = (String)slotId + "_" + (j + 1);
                }
                CuriosSlot slot = this.slots().get(slotId);
                this.renderCurioSlot(mat, slot, (ICurioStacksHandler)stacksHandler, j, width, height);
            }
        }));
    }

    private void renderCurioSlot(PoseStack mat, CuriosSlot slot, ICurioStacksHandler stacksHandler, int index, int width, int height) {
        if (slot != null && slot.enabled) {
            ItemStack stack = stacksHandler.getStacks().getStackInSlot(index);
            int x = this.getX(width, (int)(16.0f * this.armScale), slot.x, slot.aligns.HorAlign);
            int y = this.getY(height, (int)(16.0f * this.armScale), slot.y, slot.aligns.VertAlign);
            boolean right = this.getRight(slot.x, slot.aligns.HorAlign);
            int damage = ArmorStatus.getDamage(stack);
            if (damage >= 0 && damage <= this.armAbove) {
                String text = this.getText(stack, damage);
                this.pushAndRender(mat, x, y, !right, null, stack, text, this.armBars, this.armScale);
            } else if (damage == -2) {
                this.pushAndRender(mat, x, y, !right, null, stack, null, true, this.armScale);
            } else if (this.showEmpty) {
                this.pushAndRender(mat, x, y, !right, slot.icon, null, null, false, this.armScale);
            }
        }
    }

    private void pushAndRender(PoseStack mat, int x, int y, boolean right, ResourceLocation resourceLocation, ItemStack itemStack, String text, boolean over, float scale) {
        mat.m_85836_();
        mat.m_85837_((double)x, (double)y, 0.0);
        mat.m_85841_(scale, scale, 1.0f);
        this.renderElement(mat, x, y, scale, right, resourceLocation, itemStack, text, over);
        mat.m_85849_();
    }

    public void disable() {
        this.slots = null;
        this.tries = 0;
    }

    public HashMap<String, CuriosSlot> slots() {
        if (this.slots == null || this.slots.isEmpty() && this.tries < 100 && System.currentTimeMillis() - this.last > 3000L) {
            this.setupTrinkets();
            this.last = System.currentTimeMillis();
        }
        return this.slots;
    }

    public void setupTrinkets() {
        this.slots = new HashMap();
        int[] i = new int[]{0};
        boolean result = true;
        if (CuriosApi.getSlotHelper() == null) {
            result = this.tryToSetupTrinketsMP();
            if (!result) {
                InventoryHUD.log("Can't find any curios slots, another try in 3 seconds...");
            }
        } else {
            CuriosApi.getSlotHelper().getSlotTypes((LivingEntity)this.mc.f_91074_).forEach(slot -> {
                for (int j = 0; j < slot.getSize(); ++j) {
                    Object slotId = slot.getIdentifier();
                    if (j > 0) {
                        slotId = (String)slotId + "_" + (j + 1);
                    }
                    i[0] = i[0] + 20;
                    this.slots.put((String)slotId, new CuriosSlot(0, i[0], new WidgetAligns(WidgetAligns.HAlign.LEFT, WidgetAligns.VAlign.TOP), false, CuriosIconUtils.getRealResourceLocation(slot.getIdentifier(), CuriosApi.getIconHelper().getIcon(slot.getIdentifier()))));
                }
            });
        }
        if (result) {
            CuriosSaveUtils.sync();
            InventoryHUD.log(String.format("Curios has been initialized with %d slot(s) after %d tries", this.slots.size(), this.tries));
        }
    }

    public boolean tryToSetupTrinketsMP() {
        ++this.tries;
        int[] i = new int[]{0};
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)Minecraft.m_91087_().f_91074_).resolve().ifPresent(curiosItemHandler -> curiosItemHandler.getCurios().values().forEach(slot -> {
            for (int j = 0; j < slot.getSlots(); ++j) {
                Object slotId = slot.getIdentifier();
                if (j > 0) {
                    slotId = (String)slotId + "_" + (j + 1);
                }
                i[0] = i[0] + 20;
                this.slots.put((String)slotId, new CuriosSlot(0, i[0], new WidgetAligns(WidgetAligns.HAlign.LEFT, WidgetAligns.VAlign.TOP), false, CuriosIconUtils.getRealResourceLocation(slot.getIdentifier(), CuriosApi.getIconHelper().getIcon(slot.getIdentifier()))));
            }
        }));
        return this.slots.size() > 0;
    }

    public boolean isEmpty() {
        return this.slots().isEmpty();
    }
}

