/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class EachArmorRenderer
extends ArmorRenderer {
    public EachArmorRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    public void render(PoseStack mat, int width, int height) {
        this.preRender(mat, 0, 0);
        this.renderItems(mat, width, height);
        this.postRender(mat);
    }

    private void renderItems(PoseStack mat, int width, int height) {
        int i = 5;
        for (ItemStack item : this.mc.f_91074_.m_20158_()) {
            if (!this.showMain && i == 5) {
                --i;
                continue;
            }
            if (!this.showOff && i == 4) {
                --i;
                continue;
            }
            if (!this.showArmor && i < 4) {
                --i;
                continue;
            }
            this.renderItem(mat, item, i, width, height);
            --i;
        }
        if (this.showArrows || this.showInv) {
            int[] values = this.getFreeAndAmmo();
            this.renderHelperSlot(mat, width, height, this.showInv, values[0], 6);
            this.renderHelperSlot(mat, width, height, this.showArrows(), values[1], 7);
        }
    }

    private void renderItem(PoseStack mat, ItemStack item, int index, int width, int height) {
        int x = this.getX(width, (int)(16.0f * this.armScale), this.items[index].x, this.items[index].aligns.HorAlign);
        int y = this.getY(height, (int)(16.0f * this.armScale), this.items[index].y, this.items[index].aligns.VertAlign);
        boolean right = this.getRight(this.items[index].x, this.items[index].aligns.HorAlign);
        int damage = ArmorStatus.getDamage(item);
        if (damage >= 0 && damage <= this.armAbove) {
            String text = this.getText(item, damage);
            this.pushAndRender(mat, x, y, !right, null, item, text, this.armBars, this.armScale);
        } else if (damage == -2) {
            String t = null;
            boolean over = true;
            if ((index == 5 || index == 4) && this.showCount) {
                t = "" + this.getItemCount(item);
                over = false;
            }
            this.pushAndRender(mat, x, y, !right, null, item, t, over, this.armScale);
        } else if (this.showEmpty) {
            this.pushAndRender(mat, x, y, !right, this.armorRL[index], null, null, false, this.armScale);
        }
    }

    private void renderHelperSlot(PoseStack mat, int width, int height, boolean enabled, int value, int index) {
        if (enabled) {
            int x = this.getX(width, (int)(16.0f * this.armScale), this.items[index].x, this.items[index].aligns.HorAlign);
            int y = this.getY(height, (int)(16.0f * this.armScale), this.items[index].y, this.items[index].aligns.VertAlign);
            boolean right = this.getRight(this.items[index].x, this.items[index].aligns.HorAlign);
            this.pushAndRender(mat, x, y, !right, this.armorRL[index], null, "" + value, false, this.armScale);
        }
    }

    private void pushAndRender(PoseStack mat, int x, int y, boolean right, ResourceLocation resourceLocation, ItemStack itemStack, String text, boolean over, float scale) {
        mat.m_85836_();
        mat.m_85837_((double)x, (double)y, 0.0);
        mat.m_85841_(scale, scale, 1.0f);
        this.renderElement(mat, x, y, scale, right, resourceLocation, itemStack, text, over);
        mat.m_85849_();
    }
}

