/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.renderers.HudRenderer;
import dlovin.inventoryhud.utils.StringUtils;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class PotionRenderer
extends HudRenderer {
    private final ResourceLocation POTION_DIGITS = new ResourceLocation("inventoryhud", "textures/gui/potion_digits.png");
    protected final int BG_WIDTH;
    protected final int BG_HEIGHT;
    protected final int ICON_SIZE;
    public boolean potMini;
    public boolean showHidden;
    public boolean potionLevels;
    public boolean withDebug;
    public int potX;
    public int potY;
    public int potSide;
    public int potIconSide;
    public int potTextSide;
    public int potVert;
    public int barDuration;
    public int potGap;
    public float potAlpha;
    public WidgetAligns PotAligns;
    public Set<String> blackList;
    Minecraft mc;
    Font fontRenderer;
    final ResourceLocation PMT = new ResourceLocation("inventoryhud", "textures/gui/potminitime.png");

    public PotionRenderer(Minecraft mc, int bgWidth, int bgHeight, int iconSize) {
        this.mc = mc;
        this.fontRenderer = mc.f_91062_;
        this.BG_WIDTH = bgWidth;
        this.BG_HEIGHT = bgHeight;
        this.ICON_SIZE = iconSize;
    }

    public void render(PoseStack mat, int width, int height) {
    }

    protected void preDraw(PoseStack mat) {
        mat.m_85836_();
        mat.m_85837_(0.0, 0.0, -255.0);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
    }

    protected List<MobEffectInstance> filteredEffects() {
        return this.mc.f_91074_.m_21220_().stream().filter(e -> (e.m_19575_() || this.showHidden) && !this.getBlackList().contains(e.m_19544_().m_19481_())).toList();
    }

    void setBarColorByScale(float scale) {
        float r = 1.0f;
        float g = 1.0f;
        if (scale < 0.5f) {
            g = scale / 0.5f;
        } else {
            r = 1.0f - (scale - 0.5f) / 0.5f;
        }
        RenderSystem.m_157429_((float)r, (float)g, (float)0.0f, (float)1.0f);
    }

    float getBarScale(int dur) {
        return Math.min((float)dur / (float)this.barDuration, 1.0f);
    }

    int getBarSize(float scale) {
        return (int)(scale * 12.0f) + 1;
    }

    void drawBackground(PoseStack stack, ResourceLocation bgResource, int x, int y, int bgXScale, int bgYScale) {
        stack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.potAlpha);
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)bgResource);
        PotionRenderer.m_93133_((PoseStack)stack, (int)x, (int)y, (float)this.BG_WIDTH, (float)this.BG_HEIGHT, (int)this.BG_WIDTH, (int)this.BG_HEIGHT, (int)(this.BG_WIDTH * bgXScale), (int)(this.BG_HEIGHT * bgYScale));
        RenderSystem.m_69461_();
        stack.m_85849_();
    }

    void drawIcon(PoseStack stack, MobEffect effect, int x, int y) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureAtlasSprite textureatlassprite = this.mc.m_91306_().m_118732_(effect);
        RenderSystem.m_157456_((int)0, (ResourceLocation)textureatlassprite.m_118414_().m_118330_());
        PotionRenderer.m_93200_((PoseStack)stack, (int)x, (int)y, (int)this.m_93252_(), (int)this.ICON_SIZE, (int)this.ICON_SIZE, (TextureAtlasSprite)textureatlassprite);
    }

    void drawLevel(PoseStack stack, int x, int y, int level) {
        boolean sign;
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.POTION_DIGITS);
        int xOffset = -2;
        int yOffset = 1;
        if (!(++level >= 1 && level <= 9 || this.potionLevels)) {
            PotionRenderer.m_93160_((PoseStack)stack, (int)(x - xOffset - 1), (int)(y + yOffset), (int)7, (int)7, (float)50.0f, (float)0.0f, (int)7, (int)7, (int)64, (int)7);
            return;
        }
        boolean bl = sign = level < 0;
        while (level > 0) {
            int digit = level % 10;
            int texX = digit * 5;
            PotionRenderer.m_93160_((PoseStack)stack, (int)(x - xOffset), (int)(y + yOffset), (int)5, (int)7, (float)texX, (float)0.0f, (int)5, (int)7, (int)64, (int)7);
            xOffset += 4;
            level /= 10;
        }
        if (sign) {
            PotionRenderer.m_93160_((PoseStack)stack, (int)(x - xOffset), (int)(y + yOffset), (int)4, (int)7, (float)57.0f, (float)0.0f, (int)4, (int)7, (int)64, (int)7);
        }
    }

    void drawDurationBar(PoseStack stack, int duration, int x, int y, int width, int height) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.PMT);
        this.setBarColorByScale(this.getBarScale(duration));
        PotionRenderer.m_93133_((PoseStack)stack, (int)x, (int)y, (float)width, (float)height, (int)width, (int)height, (int)width, (int)height);
    }

    void drawDuration(PoseStack stack, int duration, int x, int y) {
        String time = " **:**";
        if (duration < 1600) {
            int minutes = duration / 60;
            int seconds = duration % 60;
            time = duration > 10 ? String.format("%02d:%02d", minutes, seconds) : String.format("%s%02d%s:%s%02d", ChatFormatting.RED, minutes, ChatFormatting.WHITE, ChatFormatting.RED, seconds);
        }
        this.fontRenderer.m_92750_(stack, time, (float)x, (float)y, 0xFFFFFF);
    }

    void postDraw(PoseStack stack) {
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69461_();
        stack.m_85849_();
    }

    private void PotPosVertChanged() {
        switch (this.PotAligns.HorAlign) {
            case RIGHT: {
                if (!this.potMini) {
                    this.potSide = -1;
                    this.potIconSide = 36;
                    this.potTextSide = -22;
                    break;
                }
                this.potSide = -1;
                this.potIconSide = 4;
                this.potTextSide = -15;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    if (!this.potMini) {
                        this.potSide = -1;
                        this.potIconSide = 36;
                        this.potTextSide = -22;
                        break;
                    }
                    this.potSide = -1;
                    this.potIconSide = 4;
                    this.potTextSide = -15;
                    break;
                }
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
                break;
            }
            case LEFT: {
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
            }
        }
    }

    public void PotPosChanged() {
        if (((Boolean)InventoryHUD.getClientConfig().potHor.get()).booleanValue()) {
            this.PotPosHorChanged();
        } else {
            this.PotPosVertChanged();
        }
    }

    private void PotPosHorChanged() {
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    this.potSide = -1;
                    this.potTextSide = 2;
                    this.potIconSide = 4;
                    break;
                }
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case BOTTOM: {
                this.potSide = -1;
                this.potTextSide = 2;
                this.potIconSide = 4;
            }
        }
    }

    public void PotPosYChanged(boolean top) {
        this.potVert = top ? 1 : -1;
    }

    public Set<String> getBlackList() {
        if (this.blackList == null) {
            this.resetBlacklist();
        }
        return this.blackList;
    }

    public void resetBlacklist() {
        this.blackList = StringUtils.effectDescIdsSet((List)InventoryHUD.getClientConfig().effectsBlacklist.get());
    }
}

