/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.gui.widgets.RowOfWidgets;
import dlovin.inventoryhud.gui.widgets.TextField;
import dlovin.inventoryhud.gui.widgets.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class CustomOptionList
extends AbstractSelectionList {
    private static final int ITEM_HEIGHT = 30;
    private final List<RowOfWidgets> rows = new ArrayList<RowOfWidgets>();
    private int maxHeight;
    private int scroll = 0;
    private double tmp_scroll = 0.0;
    private boolean isDragging = false;
    private final ResourceLocation SCROLL = new ResourceLocation("inventoryhud", "textures/gui/scroll.png");

    public CustomOptionList(Minecraft minecraft, Screen screen) {
        this(minecraft, screen, 55);
    }

    public CustomOptionList(Minecraft minecraft, Screen screen, int top) {
        super(minecraft, screen.f_96543_, screen.f_96544_, top, screen.f_96544_ - 32, 30);
    }

    public void addWidget(Widget widget, int rowIndex) {
        if (this.maxHeight < (rowIndex + 1) * 30 + 10) {
            this.maxHeight = (rowIndex + 1) * 30 + 10;
        }
        widget.y = this.f_93390_ + 10 + 30 * rowIndex + widget.y;
        if (this.rows.stream().anyMatch(r -> r.index == rowIndex)) {
            this.rows.stream().filter(r -> r.index == rowIndex).findFirst().get().addWidget(widget);
        } else {
            this.rows.add(new RowOfWidgets(rowIndex, widget));
        }
    }

    public void insertWidget(Widget widget, int row) {
        this.maxHeight = this.rows.size() * 30 + 10;
        widget.y = this.f_93390_ + 10 + 30 * row + widget.y;
        this.rows.stream().filter(r -> r.index >= row).forEach(r -> {
            ++r.index;
            for (Widget w : r.widgetList) {
                w.y += 30;
            }
        });
        this.rows.add(new RowOfWidgets(row, widget));
    }

    public void removeRowWith(Widget widget) {
        int index = 0;
        for (RowOfWidgets row : this.rows) {
            if (!row.widgetList.contains((Object)widget)) continue;
            index = row.index;
            break;
        }
        this.removeRow(index);
    }

    public void removeRow(int index) {
        boolean removed = false;
        Iterator<RowOfWidgets> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            RowOfWidgets item = iterator.next();
            if (item.index != index) continue;
            iterator.remove();
            removed = true;
            break;
        }
        if (!removed) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            if (row.index <= index) continue;
            --row.index;
            for (Widget w : row.widgetList) {
                w.y -= 30;
            }
        }
    }

    public List<Widget> getWidgets() {
        ArrayList<Widget> tmp = new ArrayList<Widget>();
        for (RowOfWidgets row : this.rows) {
            tmp.addAll(row.widgetList);
        }
        return tmp;
    }

    public int rowsCount() {
        return this.rows.size();
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        double tmp = 0.0;
        if (this.maxHeight > this.f_93391_ - this.f_93390_) {
            tmp = (int)(scrollAmount * 5.0);
            int diff = this.maxHeight - (this.f_93391_ - this.f_93390_);
            this.scroll = (int)((double)this.scroll - tmp);
            if (this.scroll < 0) {
                tmp += (double)this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp += (double)(this.scroll - diff);
                this.scroll = diff;
            }
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (w instanceof TextField && ((TextField)w).isFocused()) {
                    ((TextField)w).setFocused2(false);
                }
                w.y = (int)((double)w.y + tmp);
            }
        }
        return true;
    }

    public boolean m_7979_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        if (this.isDragging) {
            int height = this.f_93391_ - this.f_93390_;
            double scale = (double)height / (double)this.maxHeight;
            this.tmp_scroll += p_231045_8_ / scale;
            int tmp = (int)this.tmp_scroll;
            this.tmp_scroll -= (double)tmp;
            int diff = this.maxHeight - (this.f_93391_ - this.f_93390_);
            this.scroll += tmp;
            if (this.scroll < 0) {
                tmp -= this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp -= this.scroll - diff;
                this.scroll = diff;
            }
            for (RowOfWidgets row : this.rows) {
                for (Widget w : row.widgetList) {
                    if (w instanceof TextField && ((TextField)w).isFocused()) {
                        ((TextField)w).setFocused2(false);
                    }
                    w.y -= tmp;
                }
            }
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseBtn) {
        if (!this.m_5953_(mouseX, mouseY)) {
            return false;
        }
        if (this.maxHeight > this.f_93391_ - this.f_93390_ && mouseBtn == 0) {
            int pos = this.f_93388_ > 309 ? this.f_93388_ / 2 + 150 : this.f_93388_ - 9;
            int height = this.f_93391_ - this.f_93390_;
            double scale = (double)height / (double)this.maxHeight;
            int yPos = this.f_93390_ + (int)((double)this.scroll * scale);
            if (this.isOver(mouseX, mouseY, pos + 1, pos + 8, yPos + 1, yPos + (height = (int)((double)height * scale)) - 1)) {
                this.isDragging = true;
            }
        }
        ArrayList<Runnable> clicks = new ArrayList<Runnable>();
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!w.hovered && !(w instanceof TextField)) continue;
                clicks.add(() -> w.m_6375_(mouseX, mouseY, mouseBtn));
            }
        }
        clicks.forEach(Runnable::run);
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseBtn) {
        this.isDragging = false;
        return false;
    }

    public boolean m_5534_(char character, int keyCode) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof TextField) || !((TextField)w).isFocused()) continue;
                w.m_5534_(character, keyCode);
                return true;
            }
        }
        return false;
    }

    public boolean m_7933_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof TextField) || !((TextField)w).isFocused()) continue;
                w.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
                return true;
            }
        }
        super.m_7933_(p_231046_1_, p_231046_2_, p_231046_3_);
        return false;
    }

    private void renderScrollBG(PoseStack mat, int xPos, int height) {
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)this.f_93390_, (int)3, (int)3, (float)0.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)this.f_93390_, (int)3, (int)3, (float)13.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)(this.f_93391_ - 3), (int)3, (int)3, (float)0.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)(this.f_93391_ - 3), (int)3, (int)3, (float)13.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)this.f_93390_, (int)3, (int)3, (float)3.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)(this.f_93390_ + 3), (int)3, (int)(height - 6), (float)13.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)(this.f_93391_ - 3), (int)3, (int)3, (float)3.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)(this.f_93390_ + 3), (int)3, (int)(height - 6), (float)0.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)(this.f_93390_ + 3), (int)3, (int)(height - 6), (float)3.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private void renderScroll(PoseStack mat, int xPos, int height, int pos) {
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)pos, (int)3, (int)3, (float)16.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)pos, (int)3, (int)3, (float)29.0f, (float)0.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)(-3 + height + pos), (int)3, (int)3, (float)16.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)(-3 + height + pos), (int)3, (int)3, (float)29.0f, (float)13.0f, (int)3, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)pos, (int)3, (int)3, (float)19.0f, (float)0.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 6), (int)(3 + pos), (int)3, (int)Math.max(height - 6, 0), (float)29.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)(-3 + height + pos), (int)3, (int)3, (float)19.0f, (float)13.0f, (int)10, (int)3, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)xPos, (int)(3 + pos), (int)3, (int)Math.max(height - 6, 0), (float)16.0f, (float)3.0f, (int)3, (int)10, (int)32, (int)32);
        CustomOptionList.m_93160_((PoseStack)mat, (int)(xPos + 3), (int)(3 + pos), (int)3, (int)Math.max(height - 6, 0), (float)19.0f, (float)3.0f, (int)10, (int)10, (int)32, (int)32);
    }

    private boolean isOver(double p_231047_1_, double p_231047_3_, int min_x, int max_x, int min_y, int max_y) {
        return p_231047_3_ >= (double)min_y && p_231047_3_ <= (double)max_y && p_231047_1_ >= (double)min_x && p_231047_1_ <= (double)max_x;
    }

    protected void m_93451_(@NotNull PoseStack mat, int x, int y, int mx, int my, float pt) {
        if (this.maxHeight > this.f_93391_ - this.f_93390_) {
            int pos = this.f_93388_ > 309 ? this.f_93388_ / 2 + 150 : this.f_93388_ - 9;
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.SCROLL);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_69478_();
            int height = this.f_93391_ - this.f_93390_;
            this.renderScrollBG(mat, pos, height);
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.f_93390_ + (int)((double)this.scroll * scale);
            RenderSystem.m_157429_((float)0.8f, (float)0.8f, (float)0.8f, (float)1.0f);
            if (this.isOver(mx, my, pos + 1, pos + 8, yPos + 1, yPos + height - 1) && this.isDragging) {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            this.renderScroll(mat, pos, height, yPos);
            RenderSystem.m_69461_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.m_6305_(mat, mx, my, pt);
            }
        }
    }

    public void renderTooltips(PoseStack mat, int x, int y) {
        if (y > this.f_93391_ || y < this.f_93390_ || x > this.f_93392_ || x < this.f_93393_) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.renderTooltip(mat, x, y);
            }
        }
    }

    public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
    }
}

