/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class IconWidget
extends Widget {
    private final ResourceLocation BG = new ResourceLocation("inventoryhud", "textures/gui/tf_bg.png");
    private TextureAtlasSprite effectSprite;
    private final Minecraft minecraft = Minecraft.m_91087_();

    public IconWidget(int x, int y, int width, int height, String effectName) {
        super(x, y, width, height, "");
        this.setEffectAtlasSprite(effectName);
    }

    public void setEffectAtlasSprite(String effectName) {
        String[] splitName = effectName.split("[/:]");
        MobEffect effect = splitName.length > 1 ? (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(splitName[0], splitName[1])) : (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(effectName));
        this.effectSprite = effect == null ? null : this.minecraft.m_91306_().m_118732_(effect);
    }

    @Override
    public void m_6305_(@NotNull PoseStack stack, int mouseX, int mouseY, float pt) {
        super.m_6305_(stack, mouseX, mouseY, pt);
        stack.m_85836_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        this.renderBackground(stack);
        this.renderIcon(stack);
        RenderSystem.m_69461_();
        stack.m_85849_();
    }

    private void renderIcon(PoseStack stack) {
        if (this.effectSprite == null) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.effectSprite.m_118414_().m_118330_());
        IconWidget.m_93200_((PoseStack)stack, (int)(this.x + 2), (int)(this.y + 2), (int)this.m_93252_(), (int)16, (int)16, (TextureAtlasSprite)this.effectSprite);
    }

    private void renderBackground(PoseStack stack) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.BG);
        IconWidget.m_93160_((PoseStack)stack, (int)this.x, (int)this.y, (int)2, (int)2, (float)16.0f, (float)0.0f, (int)2, (int)2, (int)32, (int)32);
        IconWidget.m_93160_((PoseStack)stack, (int)(this.x + this.width - 2), (int)this.y, (int)2, (int)2, (float)30.0f, (float)0.0f, (int)2, (int)2, (int)32, (int)32);
        IconWidget.m_93160_((PoseStack)stack, (int)this.x, (int)(this.y + this.height - 2), (int)2, (int)2, (float)16.0f, (float)14.0f, (int)2, (int)2, (int)32, (int)32);
        IconWidget.m_93160_((PoseStack)stack, (int)(this.x + this.width - 2), (int)(this.y + this.height - 2), (int)2, (int)2, (float)30.0f, (float)14.0f, (int)2, (int)2, (int)32, (int)32);
        IconWidget.m_93160_((PoseStack)stack, (int)(this.x + 2), (int)this.y, (int)(this.width - 4), (int)2, (float)18.0f, (float)0.0f, (int)12, (int)2, (int)32, (int)32);
        IconWidget.m_93160_((PoseStack)stack, (int)(this.x + this.width - 2), (int)(this.y + 2), (int)2, (int)(this.height - 4), (float)30.0f, (float)2.0f, (int)2, (int)12, (int)32, (int)32);
        IconWidget.m_93160_((PoseStack)stack, (int)(this.x + 2), (int)(this.y + this.height - 2), (int)(this.width - 4), (int)2, (float)18.0f, (float)14.0f, (int)12, (int)2, (int)32, (int)32);
        IconWidget.m_93160_((PoseStack)stack, (int)this.x, (int)(this.y + 2), (int)2, (int)(this.height - 4), (float)16.0f, (float)2.0f, (int)2, (int)12, (int)32, (int)32);
        IconWidget.m_93160_((PoseStack)stack, (int)(this.x + 2), (int)(this.y + 2), (int)(this.width - 4), (int)(this.height - 4), (float)18.0f, (float)2.0f, (int)12, (int)12, (int)32, (int)32);
    }
}

