/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.block.entity.device;

import cofh.core.util.helpers.AugmentDataHelper;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.InventoryHelper;
import cofh.lib.api.IStorageCallback;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IAreaEffectTile;
import cofh.lib.api.block.entity.ITickableTile;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.xp.XpStorage;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.core.init.TCoreTileEntities;
import cofh.thermal.core.inventory.container.device.DeviceFisherContainer;
import cofh.thermal.core.util.managers.device.FisherManager;
import cofh.thermal.lib.common.ThermalAugmentRules;
import cofh.thermal.lib.tileentity.DeviceTileBase;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class DeviceFisherTile
extends DeviceTileBase
implements ITickableTile.IServerTickable,
IAreaEffectTile {
    public static final BiPredicate<ItemStack, List<ItemStack>> AUG_VALIDATOR = ThermalAugmentRules.createAllowValidator("Upgrade", "Area", "Filter");
    protected static int timeConstant = 4800;
    protected static int minTimeConstant = timeConstant / 20;
    protected static int timeReductionWater = 20;
    protected static boolean particles = true;
    protected ItemStorageCoFH inputSlot = new ItemStorageCoFH(item -> FisherManager.instance().validBoost((ItemStack)item));
    protected SimpleItemHandler internalHandler;
    protected boolean cached;
    protected boolean valid;
    protected static final int RADIUS = 2;
    public int radius = 2;
    protected AABB area;
    protected int process = timeConstant / 2;

    public static void setTimeConstant(int configConstant) {
        timeConstant = configConstant;
        minTimeConstant = timeConstant / 20;
    }

    public static void setTimeReductionWater(int configConstant) {
        timeReductionWater = configConstant;
    }

    public static void setParticles(boolean configConstant) {
        particles = configConstant;
    }

    public DeviceFisherTile(BlockPos pos, BlockState state) {
        super((BlockEntityType)TCoreTileEntities.DEVICE_FISHER_TILE.get(), pos, state);
        this.inventory.addSlot(this.inputSlot, StorageGroup.INPUT);
        this.inventory.addSlots(StorageGroup.OUTPUT, 15, item -> this.filter.valid(item));
        this.xpStorage = new XpStorage(this.getBaseXpStorage());
        this.addAugmentSlots(ThermalCoreConfig.deviceAugments);
        this.initHandlers();
        this.internalHandler = new SimpleItemHandler((IStorageCallback)this, this.inventory.getOutputSlots());
    }

    @Override
    protected void updateValidity() {
        this.area = null;
        if (this.f_58857_ == null || !this.f_58857_.isAreaLoaded(this.f_58858_, 1 + this.radius) || Utils.isClientWorld((Level)this.f_58857_)) {
            return;
        }
        int facingWater = 0;
        this.valid = false;
        BlockState myState = this.m_58900_();
        BlockPos facePos = this.f_58858_.m_142300_((Direction)myState.m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL));
        FluidState state = this.f_58857_.m_6425_(facePos);
        if (state.m_76152_().equals(Fluids.f_76193_)) {
            BlockPos areaPos = this.f_58858_.m_5484_((Direction)myState.m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL), 2);
            Iterable area = BlockPos.m_121940_((BlockPos)areaPos.m_142082_(-1, 0, -1), (BlockPos)areaPos.m_142082_(1, 0, 1));
            for (BlockPos scan : area) {
                state = this.f_58857_.m_6425_(scan);
                if (!state.m_76152_().equals(Fluids.f_76193_)) continue;
                ++facingWater;
            }
            this.valid = facingWater >= 7;
        }
        this.cached = true;
    }

    @Override
    protected void updateActiveState() {
        if (!this.cached) {
            boolean wasValid = this.valid;
            this.updateValidity();
            if (!wasValid && this.valid) {
                this.process = Math.max(minTimeConstant, MathHelper.RANDOM.nextInt(this.getTimeConstant()));
            }
        }
        super.updateActiveState();
    }

    @Override
    protected boolean isValid() {
        return this.valid;
    }

    public void tickServer() {
        this.updateActiveState();
        --this.process;
        if (this.process > 0) {
            return;
        }
        this.updateValidity();
        this.process = Math.max(minTimeConstant, MathHelper.RANDOM.nextInt(this.getTimeConstant()));
        if (!this.isActive) {
            return;
        }
        if (this.valid) {
            LootTable table = this.f_58857_.m_142572_().m_129898_().m_79217_(FisherManager.instance().getBoostLootTable(this.inputSlot.getItemStack()));
            LootContext.Builder contextBuilder = new LootContext.Builder((ServerLevel)this.f_58857_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82528_((Vec3i)this.m_58899_())).m_78977_(this.f_58857_.f_46441_);
            float lootBase = this.baseMod * FisherManager.instance().getBoostOutputMod(this.inputSlot.getItemStack());
            float lootExtra = lootBase - (float)((int)lootBase);
            int lootCount = (int)lootBase + (MathHelper.RANDOM.nextFloat() < lootExtra ? 1 : 0);
            int caught = 0;
            for (int i = 0; i < lootCount; ++i) {
                for (ItemStack stack : table.m_79129_(contextBuilder.m_78975_(LootContextParamSets.f_81410_))) {
                    if (!InventoryHelper.insertStackIntoInventory((IItemHandler)this.internalHandler, (ItemStack)stack, (boolean)false).m_41619_()) continue;
                    ++caught;
                }
            }
            if (caught > 0) {
                if (MathHelper.RANDOM.nextFloat() < FisherManager.instance().getBoostUseChance(this.inputSlot.getItemStack())) {
                    this.inputSlot.consume(1);
                }
                if (this.xpStorageFeature) {
                    this.xpStorage.receiveXp(caught + this.f_58857_.f_46441_.nextInt(2 * caught), false);
                }
                if (particles) {
                    Vec3 splashVec = Vec3.m_82514_((Vec3i)this.f_58858_.m_142300_((Direction)this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL)), (double)1.0);
                    ((ServerLevel)this.f_58857_).m_8767_((ParticleOptions)ParticleTypes.f_123816_, splashVec.f_82479_, splashVec.f_82480_, splashVec.f_82481_, 10, 0.1, 0.0, 0.1, 0.02);
                }
            }
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new DeviceFisherContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    @Override
    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.process = nbt.m_128451_("Proc");
        this.valid = nbt.m_128471_("Valid");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Proc", this.process);
        nbt.m_128379_("Valid", this.valid);
    }

    protected int getTimeConstant() {
        if (this.f_58857_ == null) {
            return timeConstant / 2;
        }
        int constant = timeConstant;
        BlockPos areaPos = this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL), this.radius);
        Iterable area = BlockPos.m_121940_((BlockPos)areaPos.m_142082_(-this.radius, 1 - this.radius, -this.radius), (BlockPos)areaPos.m_142082_(this.radius, -1 + this.radius, this.radius));
        for (BlockPos scan : area) {
            FluidState state = this.f_58857_.m_6425_(scan);
            if (!state.m_76152_().equals(Fluids.f_76193_)) continue;
            constant -= timeReductionWater;
        }
        if (Utils.hasBiomeType((Level)this.f_58857_, (BlockPos)this.f_58858_, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)) {
            constant /= 3;
        }
        if (Utils.hasBiomeType((Level)this.f_58857_, (BlockPos)this.f_58858_, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
            constant /= 2;
        }
        if (this.f_58857_.m_46758_(this.f_58858_)) {
            constant /= 2;
        }
        if (this.inputSlot.isEmpty()) {
            constant *= 2;
        }
        return MathHelper.clamp((int)constant, (int)(timeConstant / 20), (int)timeConstant);
    }

    @Override
    protected Predicate<ItemStack> augValidator() {
        return item -> AugmentDataHelper.hasAugmentData((ItemStack)item) && AUG_VALIDATOR.test((ItemStack)item, this.getAugmentsAsList());
    }

    @Override
    protected void resetAttributes() {
        super.resetAttributes();
        this.radius = 2;
    }

    @Override
    protected void setAttributesFromAugment(CompoundTag augmentData) {
        super.setAttributesFromAugment(augmentData);
        this.radius = (int)((float)this.radius + AugmentableHelper.getAttributeMod((CompoundTag)augmentData, (String)"Radius"));
    }

    @Override
    protected void finalizeAttributes(Map<Enchantment, Integer> enchantmentMap) {
        super.finalizeAttributes(enchantmentMap);
        this.area = null;
    }

    public AABB getArea() {
        if (this.area == null) {
            if (!this.valid) {
                BlockPos areaPos = this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL), 2);
                this.area = new AABB(areaPos.m_142082_(-1, 0, -1), areaPos.m_142082_(2, 1, 2));
            } else {
                BlockPos areaPos = this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_HORIZONTAL), this.radius);
                this.area = new AABB(areaPos.m_142082_(-this.radius, -1 - this.radius, -this.radius), areaPos.m_142082_(1 + this.radius, -1 + this.radius, 1 + this.radius));
            }
        }
        return this.area;
    }

    public int getColor() {
        return this.valid ? (this.isActive ? 35071 : 0x555555) : 0xFF0000;
    }

    @Override
    protected void updateHandlers() {
        LazyOptional prevItemCap = this.itemCap;
        IItemHandler invHandler = this.inventory.getHandler(StorageGroup.INPUT_OUTPUT);
        this.itemCap = this.inventory.hasAccessibleSlots() ? LazyOptional.of(() -> invHandler) : LazyOptional.empty();
        prevItemCap.invalidate();
    }

    @Override
    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (!this.itemCap.isPresent() && this.inventory.hasAccessibleSlots()) {
            IItemHandler handler = this.inventory.getHandler(StorageGroup.INPUT_OUTPUT);
            this.itemCap = LazyOptional.of(() -> handler);
        }
        return this.itemCap.cast();
    }
}

